/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.ingredients.IngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory category;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory category, int x, int y) {
        super(x, y);
        this.logic = logic;
        this.category = category;
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.logic.setRecipeCategory(this.category);
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        return true;
    }

    @Override
    public void draw(boolean selected, int mouseX, int mouseY) {
        super.draw(selected, mouseX, mouseY);
        int iconX = this.x + 4;
        int iconY = this.y + 4;
        IDrawable icon = this.category.getIcon();
        if (icon != null) {
            icon.draw(iconX += (16 - icon.getWidth()) / 2, iconY += (16 - icon.getHeight()) / 2);
        } else {
            List<Object> recipeCatalysts = this.logic.getRecipeCatalysts(this.category);
            if (!recipeCatalysts.isEmpty()) {
                Object ingredient = recipeCatalysts.get(0);
                RecipeCategoryTab.renderIngredient(iconX, iconY, ingredient);
            } else {
                String text = this.category.getTitle().substring(0, 2);
                Minecraft minecraft = Minecraft.func_71410_x();
                FontRenderer fontRenderer = minecraft.field_71466_p;
                int textCenterX = this.x + 12;
                int textCenterY = this.y + 12 - 3;
                int color = this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
                fontRenderer.func_175063_a(text, (float)(textCenterX - fontRenderer.func_78256_a(text) / 2), (float)textCenterY, color);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static <T> void renderIngredient(int iconX, int iconY, T ingredient) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredient);
        RenderSystem.enableDepthTest();
        ingredientRenderer.render(iconX, iconY, ingredient);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableDepthTest();
    }

    @Override
    public boolean isSelected(IRecipeCategory selectedCategory) {
        return this.category.getUid().equals((Object)selectedCategory.getUid());
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        String title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        ResourceLocation uid = this.category.getUid();
        String modId = uid.func_110624_b();
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add(modName);
        }
        return tooltip;
    }
}

