/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.cooking;

import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.config.Constants;
import mezz.jei.plugins.vanilla.cooking.AbstractCookingCategory;
import net.minecraft.block.Blocks;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.util.ResourceLocation;

public class CampfireCategory
extends AbstractCookingCategory<CampfireCookingRecipe> {
    private final IDrawable background;

    public CampfireCategory(IGuiHelper guiHelper) {
        super(guiHelper, Blocks.field_222433_lV, "gui.jei.category.campfire", 400);
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 186, 82, 34);
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.CAMPFIRE;
    }

    @Override
    public Class<? extends CampfireCookingRecipe> getRecipeClass() {
        return CampfireCookingRecipe.class;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void draw(CampfireCookingRecipe recipe, double mouseX, double mouseY) {
        this.animatedFlame.draw(1, 20);
        this.arrow.draw(24, 8);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, CampfireCookingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 8);
        guiItemStacks.set(ingredients);
    }
}

