/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import mezz.jei.config.ClientConfig;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtil() {
    }

    public static void giveStack(ItemStack itemStack, InputMappings.Input input) {
        GiveMode giveMode = ClientConfig.getInstance().getGiveMode();
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        if (minecraft.field_71462_r instanceof GuiContainerCreative && giveMode == GiveMode.MOUSE_PICKUP) {
            int amount = giveMode.getStackSize(itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            CommandUtilServer.mousePickupItemStack((EntityPlayer)player, sendStack);
        } else if (ServerInfo.isJeiOnServer()) {
            int amount = giveMode.getStackSize(itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            Network.sendPacketToServer(packet);
        } else {
            int amount = GiveMode.INVENTORY.getStackSize(itemStack, input);
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public static void setHotbarStack(ItemStack itemStack, int hotbarSlot) {
        if (ServerInfo.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)itemStack.func_77976_d());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            Network.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.func_190926_b()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        EntityPlayerSP sender = Minecraft.func_71410_x().field_71439_g;
        if (sender != null) {
            if (sender.func_195051_bN().func_197034_c(2)) {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            } else if (sender.func_184812_l_()) {
                CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
            } else {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            }
        }
    }

    private static void sendGiveAction(EntityPlayerSP sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = CommandUtilServer.getGiveCommandParameters((EntityPlayer)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(EntityPlayerSP sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.func_71165_d(chatMessage);
        } else {
            TextComponentTranslation errorMessage = new TextComponentTranslation("jei.chat.error.command.too.long", new Object[0]);
            errorMessage.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)errorMessage, false);
            TextComponentString chatMessageComponent = new TextComponentString(chatMessage);
            chatMessageComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)chatMessageComponent, false);
        }
    }

    private static void sendCreativeInventoryActions(EntityPlayerSP sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.field_71071_by.field_70462_a.size() && amount > 0; ++i) {
            ItemStack currentStack = (ItemStack)sender.field_71071_by.field_70462_a.get(i);
            if (currentStack.func_190926_b()) {
                ItemStack sendAllRemaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.func_77969_a(stack) || currentStack.func_77976_d() <= currentStack.func_190916_E()) continue;
            int canAdd = Math.min(currentStack.func_77976_d() - currentStack.func_190916_E(), amount);
            ItemStack fillRemainingSpace = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(canAdd + currentStack.func_190916_E()));
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft.func_71410_x().field_71442_b.func_78761_a(stack, mainInventorySlot);
    }
}

