/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class JeiBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> ingredients;
    private final ItemStack potionInput;
    private final ItemStack potionOutput;
    private final BrewingRecipeUtil brewingRecipeUtil;
    private final List<List<ItemStack>> inputs;
    private final int hashCode;

    public JeiBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput, BrewingRecipeUtil brewingRecipeUtil) {
        this.ingredients = ingredients;
        this.potionInput = potionInput;
        this.potionOutput = potionOutput;
        this.brewingRecipeUtil = brewingRecipeUtil;
        brewingRecipeUtil.addRecipe(potionInput, potionOutput);
        this.inputs = new ArrayList<List<ItemStack>>();
        this.inputs.add(Collections.singletonList(potionInput));
        this.inputs.add(Collections.singletonList(potionInput));
        this.inputs.add(Collections.singletonList(potionInput));
        this.inputs.add(ingredients);
        ItemStack firstIngredient = ingredients.get(0);
        PotionType typeIn = PotionUtils.func_185191_c((ItemStack)potionInput);
        PotionType typeOut = PotionUtils.func_185191_c((ItemStack)potionOutput);
        this.hashCode = com.google.common.base.Objects.hashCode((Object[])new Object[]{potionInput.func_77973_b(), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)typeIn), potionOutput.func_77973_b(), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)typeOut), firstIngredient.func_77973_b()});
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JeiBrewingRecipe)) {
            return false;
        }
        JeiBrewingRecipe other = (JeiBrewingRecipe)obj;
        if (!JeiBrewingRecipe.arePotionsEqual(other.potionInput, this.potionInput)) {
            return false;
        }
        if (!JeiBrewingRecipe.arePotionsEqual(other.potionOutput, this.potionOutput)) {
            return false;
        }
        if (this.ingredients.size() != other.ingredients.size()) {
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.ingredients.get(i), (ItemStack)other.ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean arePotionsEqual(ItemStack potion1, ItemStack potion2) {
        if (potion1.func_77973_b() != potion2.func_77973_b()) {
            return false;
        }
        PotionType type1 = PotionUtils.func_185191_c((ItemStack)potion1);
        PotionType type2 = PotionUtils.func_185191_c((ItemStack)potion2);
        ResourceLocation key1 = type1.getRegistryName();
        ResourceLocation key2 = type2.getRegistryName();
        return Objects.equals(key1, key2);
    }

    @Override
    public int getBrewingSteps() {
        return this.brewingRecipeUtil.getBrewingSteps(this.potionOutput);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        PotionType inputType = PotionUtils.func_185191_c((ItemStack)this.potionInput);
        PotionType outputType = PotionUtils.func_185191_c((ItemStack)this.potionOutput);
        return this.ingredients + " + [" + this.potionInput.func_77973_b() + " " + inputType.func_185174_b("") + "] = [" + this.potionOutput + " " + outputType.func_185174_b("") + "]";
    }
}

