/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.collect.IngredientSet;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.util.ErrorUtil;

public class ModIngredientRegistration
implements IModIngredientRegistration {
    private final Map<IIngredientType, Collection> allIngredientsMap = new IdentityHashMap<IIngredientType, Collection>();
    private final Map<IIngredientType, IIngredientHelper> ingredientHelperMap = new IdentityHashMap<IIngredientType, IIngredientHelper>();
    private final Map<IIngredientType, IIngredientRenderer> ingredientRendererMap = new IdentityHashMap<IIngredientType, IIngredientRenderer>();
    private final ISubtypeManager subtypeManager;

    public ModIngredientRegistration(ISubtypeManager subtypeManager) {
        this.subtypeManager = subtypeManager;
    }

    @Override
    public <V> void register(IIngredientType<V> ingredientType, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(allIngredients, "allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, "ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, "ingredientRenderer");
        this.allIngredientsMap.put(ingredientType, allIngredients);
        this.ingredientHelperMap.put(ingredientType, ingredientHelper);
        this.ingredientRendererMap.put(ingredientType, ingredientRenderer);
    }

    @Override
    public ISubtypeManager getSubtypeManager() {
        return this.subtypeManager;
    }

    public IngredientManager createIngredientManager(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, boolean enableDebugLogs) {
        IdentityHashMap<IIngredientType, IngredientSet> ingredientsMap = new IdentityHashMap<IIngredientType, IngredientSet>();
        for (Map.Entry<IIngredientType, Collection> entry : this.allIngredientsMap.entrySet()) {
            IIngredientType ingredientType = entry.getKey();
            IngredientSet ingredientSet = this.createIngredientSet(ingredientType, entry.getValue());
            ingredientsMap.put(ingredientType, ingredientSet);
        }
        return new IngredientManager(modIdHelper, blacklist, ingredientsMap, (ImmutableMap<IIngredientType, IIngredientHelper>)ImmutableMap.copyOf(this.ingredientHelperMap), (ImmutableMap<IIngredientType, IIngredientRenderer>)ImmutableMap.copyOf(this.ingredientRendererMap), enableDebugLogs);
    }

    private <T> IngredientSet<T> createIngredientSet(IIngredientType<T> ingredientType, Collection<T> ingredients) {
        IIngredientHelper ingredientHelper = this.ingredientHelperMap.get(ingredientType);
        IngredientSet ingredientSet = IngredientSet.create(ingredientHelper);
        ingredientSet.addAll(ingredients);
        return ingredientSet;
    }
}

