/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mezz.jei.util.Log;

public final class FileUtil {
    private FileUtil() {
    }

    public static boolean writeFileSafely(File file, FileOperation fileOperation) {
        File fileNew = new File(file.getAbsolutePath());
        File fileBackup = new File(file.getAbsolutePath() + ".bak");
        File fileTemp = new File(file.getAbsolutePath() + ".tmp");
        try {
            if (fileTemp.exists() && !fileTemp.delete()) {
                throw new IOException("Could not delete old temp file");
            }
            fileOperation.handle(fileTemp);
            if (file.exists()) {
                if (fileBackup.exists() && !fileBackup.delete()) {
                    throw new IOException("Could not delete old backup");
                }
                if (!file.renameTo(fileBackup)) {
                    throw new IOException("Could not backup file");
                }
            }
            if (!fileTemp.renameTo(fileNew)) {
                throw new IOException("Could not rename temp file");
            }
            if (fileBackup.exists() && !fileBackup.delete()) {
                Log.error("Could not delete old backup file {}", fileBackup.getAbsoluteFile());
            }
            return true;
        }
        catch (IOException e) {
            Log.error("Failed to save file {}.", fileNew, e);
            if (fileBackup.exists()) {
                if ((!fileNew.exists() || fileNew.delete()) && fileBackup.renameTo(fileNew)) {
                    Log.info("Restored file from backup.", new Object[0]);
                    return false;
                }
                Log.error("Failed to restore file from backup file {}", fileBackup.getAbsoluteFile());
            }
            return false;
        }
    }

    public static void readFileSafely(File file, FileOperation fileOperation) {
        File fileBackup;
        if (!file.exists() && (fileBackup = new File(file.getAbsolutePath() + ".bak")).exists() && fileBackup.renameTo(file)) {
            Log.info("Restored file from backup.", new Object[0]);
        }
        if (file.exists()) {
            try {
                fileOperation.handle(file);
            }
            catch (IOException e) {
                Log.error("Failed to read file {}.", file, e);
            }
        }
    }

    public static void readZipFileSafely(File file, final String zipEntryName, final ZipInputFileOperation fileOperation) {
        FileUtil.readFileSafely(file, new FileOperation(){

            @Override
            public void handle(File file) throws IOException {
                ZipInputStream zipInput = new ZipInputStream(new FileInputStream(file));
                if (FileUtil.getZipEntry(zipInput, zipEntryName)) {
                    fileOperation.handle(zipInput);
                    zipInput.close();
                }
            }
        });
    }

    public static boolean writeZipFileSafely(File file, final String zipEntryName, final ZipOutputFileOperation fileOperation) {
        return FileUtil.writeFileSafely(file, new FileOperation(){

            @Override
            public void handle(File file) throws IOException {
                ZipOutputStream zipOutput = new ZipOutputStream(new FileOutputStream(file));
                zipOutput.putNextEntry(new ZipEntry(zipEntryName));
                fileOperation.handle(zipOutput);
                zipOutput.closeEntry();
                zipOutput.close();
            }
        });
    }

    public static boolean getZipEntry(ZipInputStream zipInputStream, String zipEntryName) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(zipEntryName)) continue;
            return true;
        }
        return false;
    }

    public static interface ZipOutputFileOperation {
        public void handle(ZipOutputStream var1) throws IOException;
    }

    public static interface ZipInputFileOperation {
        public void handle(ZipInputStream var1) throws IOException;
    }

    public static interface FileOperation {
        public void handle(File var1) throws IOException;
    }
}

