/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.config.Config;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class ItemStackListFactory {
    private final ISubtypeRegistry subtypeRegistry;
    private final Multiset<Item> subtypeCount = HashMultiset.create();

    public ItemStackListFactory(ISubtypeRegistry subtypeRegistry) {
        this.subtypeRegistry = subtypeRegistry;
    }

    public List<ItemStack> create(StackHelper stackHelper) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<String> itemNameSet = new HashSet<String>();
        for (CreativeTabs creativeTab : CreativeTabs.field_78032_a) {
            NonNullList creativeTabItemStacks = NonNullList.func_191196_a();
            try {
                creativeTab.func_78018_a(creativeTabItemStacks);
            }
            catch (RuntimeException e) {
                Log.error("Creative tab crashed while getting items. Some items from this tab will be missing from the item list. {}", creativeTab, e);
            }
            catch (LinkageError e) {
                Log.error("Creative tab crashed while getting items. Some items from this tab will be missing from the item list. {}", creativeTab, e);
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                this.subtypeCount.add((Object)itemStack.func_77973_b());
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.func_190926_b()) {
                    Log.error("Found an empty itemStack from creative tab: {}", creativeTab);
                    continue;
                }
                this.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
        }
        for (Block block : ForgeRegistries.BLOCKS) {
            this.addBlockAndSubBlocks(stackHelper, block, itemList, itemNameSet);
        }
        for (Item item : ForgeRegistries.ITEMS) {
            this.addItemAndSubItems(stackHelper, item, itemList, itemNameSet);
        }
        return itemList;
    }

    private void addItemAndSubItems(StackHelper stackHelper, @Nullable Item item, List<ItemStack> itemList, Set<String> itemNameSet) {
        if (item == null || item == Items.field_190931_a) {
            return;
        }
        NonNullList<ItemStack> items = stackHelper.getSubtypes(item, 1);
        this.subtypeCount.setCount((Object)item, items.size());
        for (ItemStack stack : items) {
            this.addItemStack(stackHelper, stack, itemList, itemNameSet);
        }
    }

    private void addBlockAndSubBlocks(StackHelper stackHelper, @Nullable Block block, List<ItemStack> itemList, Set<String> itemNameSet) {
        if (block == null) {
            return;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            return;
        }
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            String itemStackInfo;
            NonNullList subBlocks = NonNullList.func_191196_a();
            try {
                block.func_149666_a(item, itemTab, subBlocks);
            }
            catch (RuntimeException e) {
                itemStackInfo = ErrorUtil.getItemStackInfo(new ItemStack(item));
                Log.error("Failed to getSubBlocks {}", itemStackInfo, e);
            }
            catch (LinkageError e) {
                itemStackInfo = ErrorUtil.getItemStackInfo(new ItemStack(item));
                Log.error("Failed to getSubBlocks {}", itemStackInfo, e);
            }
            for (ItemStack subBlock : subBlocks) {
                if (subBlock == null) {
                    Log.error("Found null subBlock of {}", block);
                    continue;
                }
                if (subBlock.func_190926_b()) {
                    Log.error("Found empty subBlock of {}", block);
                    continue;
                }
                this.addItemStack(stackHelper, subBlock, itemList, itemNameSet);
            }
        }
    }

    private void addItemStack(StackHelper stackHelper, ItemStack stack, List<ItemStack> itemList, Set<String> itemNameSet) {
        Item item = stack.func_77973_b();
        if (this.subtypeCount.count((Object)item) >= Config.getMaxSubtypes()) {
            return;
        }
        String itemKey = null;
        try {
            this.addFallbackSubtypeInterpreter(stack);
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, StackHelper.UidMode.FULL);
        }
        catch (RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            Log.error("Couldn't get unique name for itemStack {}", stackInfo, e);
        }
        catch (LinkageError e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            Log.error("Couldn't get unique name for itemStack {}", stackInfo, e);
        }
        if (itemKey != null) {
            if (itemNameSet.contains(itemKey)) {
                return;
            }
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }

    private void addFallbackSubtypeInterpreter(ItemStack itemStack) {
        if (!this.subtypeRegistry.hasSubtypeInterpreter(itemStack) && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            this.subtypeRegistry.registerSubtypeInterpreter(itemStack.func_77973_b(), FluidSubtypeInterpreter.INSTANCE);
        }
    }

    private static class FluidSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        public static final FluidSubtypeInterpreter INSTANCE = new FluidSubtypeInterpreter();

        private FluidSubtypeInterpreter() {
        }

        @Override
        @Nullable
        public String getSubtypeInfo(ItemStack itemStack) {
            IFluidHandler capability;
            if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (capability = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                IFluidTankProperties[] tankPropertiesList = capability.getTankProperties();
                StringBuilder info = new StringBuilder();
                for (IFluidTankProperties tankProperties : tankPropertiesList) {
                    String contentsName = FluidSubtypeInterpreter.getContentsName(tankProperties);
                    if (contentsName != null) {
                        info.append(contentsName).append(";");
                        continue;
                    }
                    info.append("empty").append(";");
                }
                if (info.length() > 0) {
                    if (itemStack.func_77981_g()) {
                        info.append("m=").append(itemStack.func_77960_j());
                    }
                    return info.toString();
                }
            }
            return null;
        }

        @Nullable
        private static String getContentsName(IFluidTankProperties fluidTankProperties) {
            Fluid fluid;
            FluidStack contents = fluidTankProperties.getContents();
            if (contents != null && (fluid = contents.getFluid()) != null) {
                return fluid.getName();
            }
            return null;
        }
    }
}

