/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.Config;
import mezz.jei.startup.IModIdHelper;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractModIdHelper
implements IModIdHelper {
    @Override
    public <T> String getModNameForIngredient(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String modId = ingredientHelper.getModId(ingredient);
        return this.getModNameForModId(modId);
    }

    @Override
    public <T> List<String> addModNameToIngredientTooltip(List<String> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        String modNameFormat = Config.getModNameFormat();
        if (modNameFormat.isEmpty()) {
            return tooltip;
        }
        String modName = this.getModNameForIngredient(ingredient, ingredientHelper);
        if (tooltip.size() > 1) {
            String lastTooltipLine = tooltip.get(tooltip.size() - 1);
            if (modName.equals(lastTooltipLine = TextFormatting.func_110646_a((String)lastTooltipLine))) {
                return tooltip;
            }
        }
        ArrayList<String> tooltipCopy = new ArrayList<String>(tooltip);
        tooltipCopy.add(modNameFormat + modName);
        return tooltipCopy;
    }
}

