/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.runtime;

import java.util.Optional;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IJeiKeyMappings;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.gui.BookmarkOverlayDummy;
import mezz.jei.library.gui.IngredientListOverlayDummy;
import mezz.jei.library.gui.recipes.RecipesGuiDummy;
import mezz.jei.library.ingredients.IngredientFilterApiDummy;
import mezz.jei.library.ingredients.TypedIngredient;

public class JeiRuntime
implements IJeiRuntime {
    private final IRecipeManager recipeManager;
    private final IRecipeTransferManager recipeTransferManager;
    private final IEditModeConfig editModeConfig;
    private final IIngredientManager ingredientManager;
    private final IIngredientVisibility ingredientVisibility;
    private final IJeiKeyMappings keyMappings;
    private final IJeiHelpers jeiHelpers;
    private final IScreenHelper screenHelper;
    private IIngredientListOverlay ingredientListOverlay;
    private IBookmarkOverlay bookmarkOverlay;
    private IRecipesGui recipesGui;
    private IIngredientFilter ingredientFilter;

    public JeiRuntime(IRecipeManager recipeManager, IIngredientManager ingredientManager, IIngredientVisibility ingredientVisibility, IJeiKeyMappings keyMappings, IJeiHelpers jeiHelpers, IScreenHelper screenHelper, IRecipeTransferManager recipeTransferManager, IEditModeConfig editModeConfig) {
        this.recipeManager = recipeManager;
        this.recipeTransferManager = recipeTransferManager;
        this.editModeConfig = editModeConfig;
        this.ingredientListOverlay = IngredientListOverlayDummy.INSTANCE;
        this.ingredientVisibility = ingredientVisibility;
        this.bookmarkOverlay = BookmarkOverlayDummy.INSTANCE;
        this.recipesGui = RecipesGuiDummy.INSTANCE;
        this.ingredientFilter = IngredientFilterApiDummy.INSTANCE;
        this.ingredientManager = ingredientManager;
        this.keyMappings = keyMappings;
        this.jeiHelpers = jeiHelpers;
        this.screenHelper = screenHelper;
    }

    public <T> ITypedIngredient<T> createTypedIngredient(IIngredientType<T> ingredientType, T ingredient) {
        Optional<ITypedIngredient<T>> result = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient);
        if (result.isEmpty()) {
            String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient, ingredientType, (IIngredientManager)this.ingredientManager);
            throw new IllegalArgumentException("Invalid ingredient: " + ingredientInfo);
        }
        return result.get();
    }

    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public IIngredientFilter getIngredientFilter() {
        return this.ingredientFilter;
    }

    public IIngredientListOverlay getIngredientListOverlay() {
        return this.ingredientListOverlay;
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public IBookmarkOverlay getBookmarkOverlay() {
        return this.bookmarkOverlay;
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public IRecipesGui getRecipesGui() {
        return this.recipesGui;
    }

    public IIngredientVisibility getIngredientVisibility() {
        return this.ingredientVisibility;
    }

    public IJeiKeyMappings getKeyMappings() {
        return this.keyMappings;
    }

    public IScreenHelper getScreenHelper() {
        return this.screenHelper;
    }

    public IRecipeTransferManager getRecipeTransferManager() {
        return this.recipeTransferManager;
    }

    public IEditModeConfig getEditModeConfig() {
        return this.editModeConfig;
    }

    public void setIngredientListOverlay(IIngredientListOverlay ingredientListOverlay) {
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void setBookmarkOverlay(IBookmarkOverlay bookmarkOverlay) {
        this.bookmarkOverlay = bookmarkOverlay;
    }

    public void setRecipesGui(IRecipesGui recipesGui) {
        this.recipesGui = recipesGui;
    }

    public void setIngredientFilter(IIngredientFilter ingredientFilter) {
        this.ingredientFilter = ingredientFilter;
    }
}

