/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;
    private final IColorHelper colorHelper;

    public ItemStackHelper(StackHelper stackHelper, IColorHelper colorHelper) {
        this.stackHelper = stackHelper;
        this.colorHelper = colorHelper;
    }

    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM_STACK;
    }

    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.getHoverName();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull((Object)displayName, (String)"itemStack.getDisplayName()");
        return displayName;
    }

    public String getUniqueId(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, context);
    }

    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        return StackHelper.getRegistryNameForStack((ItemStack)ingredient);
    }

    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        return (String)itemStackHelper.getCreatorModId(ingredient).or(() -> Services.PLATFORM.getRegistry(Registry.ITEM_REGISTRY).getRegistryName((Object)ingredient.getItem()).map(ResourceLocation::getNamespace)).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registryName for: " + stackInfo);
        });
    }

    public Iterable<Integer> getColors(ItemStack ingredient) {
        return this.colorHelper.getColors(ingredient, 2);
    }

    public ResourceLocation getResourceLocation(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient);
        Item item = ingredient.getItem();
        return (ResourceLocation)Services.PLATFORM.getRegistry(Registry.ITEM_REGISTRY).getRegistryName((Object)item).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        });
    }

    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.copy();
    }

    public ItemStack normalizeIngredient(ItemStack ingredient) {
        ItemStack copy = ingredient.copy();
        copy.setCount(1);
        return copy;
    }

    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.isEmpty();
    }

    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.getItem();
        IPlatformRegistry registry = Services.PLATFORM.getRegistry(Registry.ITEM_REGISTRY);
        return registry.contains((Object)item);
    }

    public Collection<ResourceLocation> getTags(ItemStack ingredient) {
        return TagUtil.getTags((Stream)ingredient.getTags());
    }

    public Collection<String> getCreativeTabNames(ItemStack ingredient) {
        ArrayList<String> creativeTabsStrings = new ArrayList<String>();
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        for (CreativeModeTab itemGroup : itemStackHelper.getCreativeTabs(ingredient)) {
            if (itemGroup == null) continue;
            String creativeTabName = itemGroup.getDisplayName().getString();
            creativeTabsStrings.add(creativeTabName);
        }
        return creativeTabsStrings;
    }

    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo((ItemStack)ingredient);
    }

    public Optional<ResourceLocation> getTagEquivalent(Collection<ItemStack> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, ItemStack::getItem, () -> ((DefaultedRegistry)Registry.ITEM).getTags());
    }
}

