/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.gui.GuiContainerHandlers;
import mezz.jei.library.gui.ScreenHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import org.jetbrains.annotations.Unmodifiable;

public class GuiHandlerRegistration
implements IGuiHandlerRegistration {
    private final GuiContainerHandlers guiContainerHandlers = new GuiContainerHandlers();
    private final List<IGlobalGuiHandler> globalGuiHandlers = new ArrayList<IGlobalGuiHandler>();
    private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers = new HashMap();
    private final Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers = new HashMap();
    private final IJeiHelpers jeiHelpers;
    private static final @Unmodifiable List<Class<? extends Screen>> ghostIngredientGuiBlacklist = List.of(Screen.class, InventoryScreen.class, CreativeModeInventoryScreen.class);

    public GuiHandlerRegistration(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    public <T extends AbstractContainerScreen<?>> void addGuiContainerHandler(Class<? extends T> guiClass, IGuiContainerHandler<T> guiHandler) {
        ErrorUtil.checkNotNull(guiClass, (String)"guiClass");
        ErrorUtil.checkNotNull(guiHandler, (String)"guiHandler");
        this.guiContainerHandlers.add(guiClass, guiHandler);
    }

    public <T extends AbstractContainerScreen<?>> void addGenericGuiContainerHandler(Class<? extends T> guiClass, IGuiContainerHandler<?> guiHandler) {
        ErrorUtil.checkNotNull(guiClass, (String)"guiClass");
        ErrorUtil.checkNotNull(guiHandler, (String)"guiHandler");
        this.guiContainerHandlers.add(guiClass, guiHandler);
    }

    public void addGlobalGuiHandler(IGlobalGuiHandler globalGuiHandler) {
        ErrorUtil.checkNotNull((Object)globalGuiHandler, (String)"globalGuiHandler");
        this.globalGuiHandlers.add(globalGuiHandler);
    }

    public <T extends Screen> void addGuiScreenHandler(Class<T> guiClass, IScreenHandler<T> handler) {
        ErrorUtil.checkNotNull(guiClass, (String)"guiClass");
        Preconditions.checkArgument((boolean)Screen.class.isAssignableFrom(guiClass), (Object)"guiClass must inherit from Screen");
        Preconditions.checkArgument((!Screen.class.equals(guiClass) ? 1 : 0) != 0, (Object)"you cannot add a handler for Screen, only a subclass.");
        ErrorUtil.checkNotNull(handler, (String)"guiScreenHandler");
        this.guiScreenHandlers.put(guiClass, handler);
    }

    public <T extends Screen> void addGhostIngredientHandler(Class<T> guiClass, IGhostIngredientHandler<T> handler) {
        ErrorUtil.checkNotNull(guiClass, (String)"guiClass");
        Preconditions.checkArgument((boolean)Screen.class.isAssignableFrom(guiClass), (Object)"guiClass must inherit from Screen");
        Preconditions.checkArgument((!ghostIngredientGuiBlacklist.contains(guiClass) ? 1 : 0) != 0, (String)"you cannot add a ghost ingredient handler for the following Guis, it would interfere with using JEI: %s", ghostIngredientGuiBlacklist);
        ErrorUtil.checkNotNull(handler, (String)"handler");
        this.ghostIngredientHandlers.put(guiClass, handler);
    }

    public IScreenHelper createGuiScreenHelper(IIngredientManager ingredientManager) {
        return new ScreenHelper(ingredientManager, this.globalGuiHandlers, this.guiContainerHandlers, this.ghostIngredientHandlers, this.guiScreenHandlers);
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }
}

