/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory<?> category;
    private final IIngredientManager ingredientManager;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, Textures textures, int x, int y, IIngredientManager ingredientManager) {
        super(textures, x, y);
        this.logic = logic;
        this.category = category;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (!this.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return Optional.empty();
        }
        if (input.is(keyBindings.getLeftClick())) {
            if (!input.isSimulate()) {
                this.logic.setRecipeCategory(this.category);
                SoundManager soundHandler = Minecraft.getInstance().getSoundManager();
                soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public void draw(boolean selected, PoseStack poseStack, int mouseX, int mouseY) {
        super.draw(selected, poseStack, mouseX, mouseY);
        int iconX = this.x + 4;
        int iconY = this.y + 4;
        IDrawable icon = this.category.getIcon();
        if (icon != null) {
            icon.draw(poseStack, iconX += (16 - icon.getWidth()) / 2, iconY += (16 - icon.getHeight()) / 2);
        } else {
            Optional<ITypedIngredient<?>> firstCatalyst = this.logic.getRecipeCatalysts(this.category).findFirst();
            if (firstCatalyst.isPresent()) {
                ITypedIngredient<?> ingredient = firstCatalyst.get();
                RecipeCategoryTab.renderIngredient(poseStack, iconX, iconY, ingredient, this.ingredientManager);
            } else {
                String text = this.category.getTitle().getString().substring(0, 2);
                Minecraft minecraft = Minecraft.getInstance();
                Font fontRenderer = minecraft.font;
                int textCenterX = this.x + 12;
                int textCenterY = this.y + 12 - 3;
                int color = this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
                int stringCenter = fontRenderer.width(text) / 2;
                fontRenderer.drawShadow(poseStack, text, (float)(textCenterX - stringCenter), (float)textCenterY, color);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static <T> void renderIngredient(PoseStack poseStack, int iconX, int iconY, ITypedIngredient<T> ingredient, IIngredientManager ingredientManager) {
        IIngredientRenderer ingredientRenderer = ingredientManager.getIngredientRenderer(ingredient.getType());
        poseStack.pushPose();
        poseStack.translate((double)iconX, (double)iconY, 0.0);
        RenderSystem.enableDepthTest();
        ingredientRenderer.render(poseStack, ingredient.getIngredient());
        RenderSystem.disableDepthTest();
        poseStack.popPose();
    }

    @Override
    public boolean isSelected(IRecipeCategory<?> selectedCategory) {
        ResourceLocation categoryUid = this.category.getRecipeType().getUid();
        ResourceLocation selectedCategoryUid = selectedCategory.getRecipeType().getUid();
        return categoryUid.equals((Object)selectedCategoryUid);
    }

    @Override
    public List<Component> getTooltip(IModIdHelper modIdHelper) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Component title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        ResourceLocation uid = this.category.getRecipeType().getUid();
        String modId = uid.getNamespace();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add((Component)Component.literal((String)modName));
        }
        return tooltip;
    }
}

