/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.IOnClickHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Textures textures, Runnable onClose) {
        super(0, 0, 0, 0, icon, b -> {}, textures);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(Rect2i area, IRecipeTransferManager recipeTransferManager, @Nullable AbstractContainerMenu container, Player player) {
        this.x = area.getX();
        this.y = area.getY();
        this.width = area.getWidth();
        this.height = area.getHeight();
        this.recipeTransferError = container != null ? (IRecipeTransferError)RecipeTransferUtil.getTransferRecipeError((IRecipeTransferManager)recipeTransferManager, (AbstractContainerMenu)container, this.recipeLayout, (Player)player).orElse(null) : RecipeTransferErrorInternal.INSTANCE;
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.active = true;
            this.visible = true;
        } else {
            this.active = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.visible = type == IRecipeTransferError.Type.USER_FACING;
        }
        this.onClickHandler = (mouseX, mouseY) -> {
            boolean maxTransfer = Screen.hasShiftDown();
            if (container != null && RecipeTransferUtil.transferRecipe((IRecipeTransferManager)recipeTransferManager, (AbstractContainerMenu)container, this.recipeLayout, (Player)player, (boolean)maxTransfer)) {
                this.onClose.run();
            }
        };
    }

    public void drawToolTip(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.recipeTransferError == null) {
                MutableComponent tooltipTransfer = Component.translatable((String)"jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText((PoseStack)poseStack, List.of(tooltipTransfer), (int)mouseX, (int)mouseY);
            } else {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                Rect2i recipeRect = this.recipeLayout.getRect();
                this.recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, recipeRect.getX(), recipeRect.getY());
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.render(poseStack, mouseX, mouseY, partialTicks);
        if (this.visible && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
            RecipeTransferButton.fill((PoseStack)poseStack, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.recipeTransferError.getButtonHighlightColor());
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

