/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.gui.ingredients.IListElement;
import mezz.jei.common.ingredients.IListElementInfo;
import mezz.jei.common.ingredients.IngredientBlacklistInternal;
import mezz.jei.common.ingredients.IngredientFilter;
import mezz.jei.common.ingredients.IngredientInfo;
import mezz.jei.common.ingredients.IngredientListElementFactory;
import mezz.jei.common.ingredients.ListElementInfo;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.config.IClientConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final IClientConfig clientConfig;
    private final RegisteredIngredients registeredIngredients;
    private final IngredientFilter ingredientFilter;

    public IngredientManager(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, IClientConfig clientConfig, RegisteredIngredients registeredIngredients, IngredientFilter ingredientFilter) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        this.clientConfig = clientConfig;
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilter = ingredientFilter;
    }

    public <V> @Unmodifiable Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        return ingredientInfo.getAllIngredients();
    }

    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientHelper(ingredientType);
    }

    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientHelper();
    }

    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientRenderer(ingredientType);
    }

    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientRenderer();
    }

    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.registeredIngredients.getIngredientTypes();
    }

    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.addIngredients(ingredients);
        List<ITypedIngredient> typedIngredients = ingredients.stream().map(i -> TypedIngredient.createTyped(this.registeredIngredients, ingredientType, i)).map(Optional::orElseThrow).toList();
        IIngredientHelper<V> ingredientHelper = ingredientInfo.getIngredientHelper();
        for (ITypedIngredient value : typedIngredients) {
            Optional<IListElementInfo<V>> matchingElementInfo = this.ingredientFilter.searchForMatchingElement(ingredientHelper, value);
            if (matchingElementInfo.isPresent()) {
                IListElement<V> matchingElement = matchingElementInfo.get().getElement();
                ITypedIngredient<V> typedIngredient = matchingElement.getTypedIngredient();
                this.blacklist.removeIngredientFromBlacklist(typedIngredient, ingredientHelper);
                this.ingredientFilter.updateHiddenState(matchingElement);
                if (!this.clientConfig.isDebugModeEnabled()) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
                continue;
            }
            IListElement element = IngredientListElementFactory.createOrderedElement(value);
            IListElementInfo info = ListElementInfo.create(element, this.registeredIngredients, this.modIdHelper);
            if (info == null) continue;
            this.blacklist.removeIngredientFromBlacklist(value, ingredientHelper);
            this.ingredientFilter.addIngredient(info);
            if (!this.clientConfig.isDebugModeEnabled()) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
        }
        this.ingredientFilter.invalidateCache();
    }

    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.registeredIngredients.getIngredientType(ingredient);
    }

    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        return this.registeredIngredients.getIngredientType(ingredientClass);
    }

    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.removeIngredients(ingredients);
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientType);
        ingredients.stream().map(i -> TypedIngredient.createTyped(this.registeredIngredients, ingredientType, i)).flatMap(Optional::stream).forEach(typedIngredient -> {
            this.ingredientFilter.searchForMatchingElement(ingredientHelper, typedIngredient).map(IListElementInfo::getElement).ifPresent(e -> e.setVisible(false));
            this.blacklist.addIngredientToBlacklist(typedIngredient, ingredientHelper);
            if (this.clientConfig.isDebugModeEnabled()) {
                LOGGER.debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
            }
        });
        this.ingredientFilter.invalidateCache();
    }
}

