/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientTooltipHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <V> List<Component> getMutableIngredientTooltipSafe(V ingredient, IIngredientRenderer<V> ingredientRenderer) {
        try {
            Minecraft minecraft = Minecraft.getInstance();
            TooltipFlag.Default tooltipFlag = minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            List tooltip = ingredientRenderer.getTooltip(ingredient, (TooltipFlag)tooltipFlag);
            return new ArrayList<Component>(tooltip);
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Tooltip crashed.", e);
            ArrayList<Component> tooltip = new ArrayList<Component>();
            MutableComponent translated = Component.translatable((String)"jei.tooltip.error.crash");
            tooltip.add((Component)translated.withStyle(ChatFormatting.RED));
            return tooltip;
        }
    }
}

