/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.commands;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public class IguanaCommandToolXP
extends CommandBase {
    public String getCommandName() {
        return "toolxp";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(ICommandSender icommandsender, String[] astring) {
        int hLevel;
        if (astring.length <= 0) throw new WrongUsageException("toolxp [player] <value>", new Object[0]);
        EntityPlayerMP entityplayermp = astring.length >= 2 ? IguanaCommandToolXP.getPlayer((ICommandSender)icommandsender, (String)astring[0]) : IguanaCommandToolXP.getCommandSenderAsPlayer((ICommandSender)icommandsender);
        int xp = astring.length >= 2 ? IguanaCommandToolXP.parseIntWithMinMax(icommandsender, astring[1], 0, Integer.MAX_VALUE) : IguanaCommandToolXP.parseIntWithMinMax(icommandsender, astring[0], 0, Integer.MAX_VALUE);
        ItemStack equipped = entityplayermp.getCurrentEquippedItem();
        if (equipped == null || !(equipped.getItem() instanceof ToolCore)) throw new WrongUsageException("Player must have a Tinker's Construct tool in hand", new Object[0]);
        NBTTagCompound tags = equipped.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.hasKey("ToolLevel")) throw new WrongUsageException("Player must have a levelable Tinker's Construct tool in hand", new Object[0]);
        int level = tags.getInteger("ToolLevel");
        int n = hLevel = tags.hasKey("HarvestLevel") ? (hLevel = tags.getInteger("HarvestLevel")) : -1;
        if ((level < 1 || level > 5) && hLevel < TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel >= TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel()) throw new WrongUsageException("Players tool is already max level", new Object[0]);
        Long toolXP = tags.hasKey("ToolEXP") ? tags.getLong("ToolEXP") : -1L;
        Long headXP = tags.hasKey("HeadEXP") ? tags.getLong("HeadEXP") : -1L;
        LevelingLogic.updateXP(equipped, (EntityPlayer)entityplayermp, toolXP + (long)xp, headXP + (long)xp);
        if (entityplayermp == icommandsender) return;
    }

    public static int parseIntWithMinMax(ICommandSender par0ICommandSender, String par1Str, int min, int max) {
        return IguanaCommandToolXP.parseIntBounded((ICommandSender)par0ICommandSender, (String)par1Str, (int)min, (int)max);
    }

    public String getCommandUsage(ICommandSender icommandsender) {
        return null;
    }

    public int compareTo(Object o) {
        return 0;
    }
}

