/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling;

import codechicken.nei.api.API;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.leveling.LevelingActiveToolMod;
import iguanaman.iguanatweakstconstruct.leveling.handlers.LevelingEventHandler;
import iguanaman.iguanatweakstconstruct.leveling.handlers.LevelingToolTipHandler;
import iguanaman.iguanatweakstconstruct.leveling.handlers.MobHeadTooltipHandler;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModMiningLevelBoost;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModXpAwareRedstone;
import iguanaman.iguanatweakstconstruct.mobheads.IguanaMobHeads;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.reference.Reference;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import iguanaman.iguanatweakstconstruct.util.ModSupportHelper;
import java.util.List;
import java.util.ListIterator;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModRedstone;
import tconstruct.modifiers.tools.ModWindup;
import tconstruct.tools.TinkerTools;

@Pulse(id="ToolLeveling", description="The Iguana Tweaks Leveling System for Tinker's Tools")
public class IguanaToolLeveling {
    public static Item rubberChicken;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        rubberChicken = new Item();
        rubberChicken.setTextureName(Reference.resource("rubber_chicken"));
        rubberChicken.setUnlocalizedName(Reference.prefix("rubberChicken"));
        GameRegistry.registerItem((Item)rubberChicken, (String)"rubberChicken");
        if (event.getSide() == Side.CLIENT && Loader.isModLoaded((String)"NotEnoughItems")) {
            API.hideItem((ItemStack)new ItemStack(rubberChicken));
        }
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        TConstructRegistry.activeModifiers.add(0, new LevelingActiveToolMod());
        this.takeOverModifiers();
        this.registerBoostModifiers();
    }

    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        LevelingEventHandler handler = new LevelingEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)new LevelingToolTipHandler());
        if (Config.mobHeadPickaxeBoost) {
            MinecraftForge.EVENT_BUS.register((Object)new MobHeadTooltipHandler());
        }
    }

    private void takeOverModifiers() {
        List mods = ModifyBuilder.instance.itemModifiers;
        ListIterator<ModXpAwareRedstone> iter = mods.listIterator();
        while (iter.hasNext()) {
            ItemModifier mod = (ItemModifier)iter.next();
            if (!(mod instanceof ModRedstone) || mod instanceof ModWindup) continue;
            iter.set(new ModXpAwareRedstone((ModRedstone)mod));
            Log.trace("Replaced Redstone Modifier");
        }
    }

    private void registerBoostModifiers() {
        ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getVanillaMobHead(2), 20, HarvestLevels._2_copper));
        ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getVanillaMobHead(0), 21, HarvestLevels._3_iron));
        ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getVanillaMobHead(4), 22, HarvestLevels._5_diamond));
        if (IguanaTweaksTConstruct.pulsar.isPulseLoaded("MobHeads")) {
            ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getIguanaMobHead(1), 23, HarvestLevels._5_diamond));
            ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getIguanaMobHead(2), 24, HarvestLevels._6_obsidian));
            if (ModSupportHelper.ThermalFoundation) {
                ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getIguanaMobHead(3), 25, HarvestLevels._6_obsidian));
            }
            ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getIguanaMobHead(0), 26, HarvestLevels._7_ardite));
        }
        ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(this.getVanillaMobHead(1), 27, HarvestLevels._8_cobalt));
        ModifyBuilder.registerModifier((ItemModifier)new ModMiningLevelBoost(new ItemStack[]{new ItemStack(Items.nether_star)}, 28, HarvestLevels._9_manyullym));
        ToolCore[] tools = new ToolCore[]{TinkerTools.pickaxe, TinkerTools.hammer};
        int[] modifierIds = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28};
        String[] renderNames = new String[]{"zombiehead", "skeletonskull", "creeperhead", "zombiepigmanhead", "blazehead", "blizzhead", "endermanhead", "witherskeletonskull", "netherstar"};
        for (ToolCore tool : tools) {
            for (int index = 0; index < modifierIds.length; ++index) {
                TConstructClientRegistry.addEffectRenderMapping((ToolCore)tool, (int)modifierIds[index], (String)Reference.RESOURCE, (String)renderNames[index], (boolean)true);
            }
        }
    }

    private ItemStack[] getVanillaMobHead(int meta) {
        return new ItemStack[]{new ItemStack(Items.skull, 1, meta)};
    }

    private ItemStack[] getIguanaMobHead(int meta) {
        return new ItemStack[]{new ItemStack(IguanaMobHeads.skullItem, 1, meta)};
    }
}

