/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.harvestlevels;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.world.blocks.GravelOre;

public final class HarvestLevelTweaks {
    public static final String[] oreDictPrefixes = new String[]{"ore", "denseore", "oreNether", "denseoreNether", "block", "stone", "brick", "orePoor"};
    public static final String[][] oreDictLevels = new String[][]{new String[0], {"Copper", "Coal", "Tetrahedrite", "Aluminum", "Aluminium", "NaturalAluminum", "AluminumBrass", "Shard", "Bauxite", "Zinc"}, {"Iron", "Pyrite", "Silver", "Lapis"}, {"Tin", "Cassiterite", "Gold", "Lead", "Redstone", "Steel", "Galena", "Nickel", "Invar", "Electrum", "Sphalerite", "Osmium"}, {"Diamond", "Emerald", "Ruby", "Sapphire", "Amethyst", "Cinnabar", "GreenSapphire", "BlackGranite", "RedGranite", "Manganese"}, {"Obsidian", "Tungstate", "Sodalite", "Quartz", "CertusQuartz", "SkyStone"}, {"Ardite", "Uranium", "Olivine", "Sheldonite", "Platinum", "Yellorite"}, {"Cobalt", "Iridium", "Cooperite", "Titanium"}, {"Manyullyn"}, new String[0]};
    public static final String[][] oreDictLevelsMetallurgyFantasy = new String[][]{{"Prometheum", "DeepIron"}, {"Infuscolium"}, {"Oureclase"}, {"AstralSilver"}, {"Carmot"}, {"Mithril"}, {"Rubracium"}, {"Orichalcum"}, {"Adamantine"}, {"Atlarus"}};
    public static final String[][] oreDictLevelsMetallurgyNether = new String[][]{new String[0], new String[0], {"Lemurite", "Ignatius"}, {"ShadowIron"}, {"Midasium", "Vyroxeres"}, {"Ceruclase"}, {"Alduorite"}, {"Kalendrite"}, {"Vulcanite"}, {"Sanguinite"}};
    public static final String[][] oreDictLevelsMetallurgyEnd = new String[][]{new String[0], new String[0], new String[0], new String[0], new String[0], {"Eximite"}, {"Meutoite"}, new String[0], new String[0], new String[0]};
    public static String[][] allOreDicLevels;

    private HarvestLevelTweaks() {
    }

    public static void modifyHarvestLevels() {
        Log.debug("Modifying HarvestLevel of blocks and items");
        HarvestLevelTweaks.modifyOredictBlocks();
        HarvestLevelTweaks.modifyVanillaBlocks();
        HarvestLevelTweaks.modifyTools();
        Log.debug("Finished modifying HarvestLevel of blocks and items");
    }

    private static void modifyVanillaBlocks() {
        new ForgeHooks();
        Blocks.iron_ore.setHarvestLevel("pickaxe", HarvestLevels._2_copper);
        Blocks.iron_block.setHarvestLevel("pickaxe", HarvestLevels._2_copper);
        Blocks.iron_bars.setHarvestLevel("pickaxe", HarvestLevels._2_copper);
        Blocks.lapis_ore.setHarvestLevel("pickaxe", HarvestLevels._2_copper);
        Blocks.lapis_block.setHarvestLevel("pickaxe", HarvestLevels._2_copper);
        Blocks.gold_ore.setHarvestLevel("pickaxe", HarvestLevels._3_iron);
        Blocks.gold_block.setHarvestLevel("pickaxe", HarvestLevels._3_iron);
        Blocks.redstone_ore.setHarvestLevel("pickaxe", HarvestLevels._3_iron);
        Blocks.lit_redstone_ore.setHarvestLevel("pickaxe", HarvestLevels._3_iron);
        Blocks.diamond_ore.setHarvestLevel("pickaxe", HarvestLevels._4_bronze);
        Blocks.diamond_block.setHarvestLevel("pickaxe", HarvestLevels._4_bronze);
        Blocks.emerald_ore.setHarvestLevel("pickaxe", HarvestLevels._4_bronze);
        Blocks.emerald_block.setHarvestLevel("pickaxe", HarvestLevels._4_bronze);
        Blocks.obsidian.setHarvestLevel("pickaxe", HarvestLevels._5_diamond);
        Blocks.enchanting_table.setHarvestLevel("pickaxe", HarvestLevels._5_diamond);
        if (Config.logHarvestLevelChanges) {
            Log.debug("Modified vanilla blocks");
        }
    }

    private static void modifyOredictBlocks() {
        for (int i = 0; i < allOreDicLevels.length; ++i) {
            for (String materialName : allOreDicLevels[i]) {
                HarvestLevelTweaks.modifyOredictBlock(materialName, i);
            }
        }
        if (Config.logHarvestLevelChanges) {
            Log.debug("Modified oredicted blocks");
        }
    }

    public static void modifyOredictBlock(String orePostfix, int hlvl) {
        for (String prefix : oreDictPrefixes) {
            for (ItemStack oreStack : OreDictionary.getOres((String)(prefix + orePostfix))) {
                HarvestLevelTweaks.modifyBlock(oreStack, hlvl);
            }
        }
    }

    public static void modifyBlock(ItemStack stack, int harvestLevel) {
        Block block = Block.getBlockFromItem((Item)stack.getItem());
        int meta = stack.getItemDamage();
        Integer[] metas = meta == Short.MAX_VALUE ? new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15} : new Integer[]{meta};
        Integer[] integerArray = metas;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int m = integerArray[i];
            try {
                if (Config.logHarvestLevelChanges) {
                    Log.debug(String.format("Changed Harvest Level of %s from %d to %d", stack.getUnlocalizedName(), block.getHarvestLevel(m), harvestLevel));
                }
                if (block instanceof GravelOre) {
                    block.setHarvestLevel("shovel", harvestLevel, m);
                } else {
                    block.setHarvestLevel("pickaxe", harvestLevel, m);
                }
                if (!Config.logOverrideChanges || !Loader.instance().isInState(LoaderState.POSTINITIALIZATION)) continue;
                Log.info(String.format("Block Override: Changed Harvest Level of %s to %d", stack.getUnlocalizedName(), harvestLevel));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void modifyTools() {
        ItemStack tmp = new ItemStack(Items.stick);
        for (Object o : Item.itemRegistry) {
            Item item = (Item)o;
            for (String toolClass : item.getToolClasses(tmp)) {
                int old = item.getHarvestLevel(tmp, toolClass);
                if (old <= 0) continue;
                int hlvl = HarvestLevelTweaks.getUpdatedHarvestLevel(old);
                HarvestLevelTweaks.updateToolHarvestLevel(item, toolClass, hlvl);
                if (!Config.logMiningLevelChanges) continue;
                Log.debug(String.format("Changed Harvest Level for %s of %s from %d to %d", toolClass, item.getUnlocalizedName(), old, hlvl));
            }
        }
        if (Config.logMiningLevelChanges) {
            Log.debug("Modified tools");
        }
    }

    public static int getUpdatedHarvestLevel(int old) {
        switch (old) {
            case 1: {
                return HarvestLevels._0_stone;
            }
            case 2: {
                return HarvestLevels._3_iron;
            }
            case 3: {
                return HarvestLevels._5_diamond;
            }
        }
        return old + 2;
    }

    public static void updateToolHarvestLevel(Item item, String toolClass, int hlvl) {
        item.setHarvestLevel(toolClass, hlvl);
        for (Class<?> clazz = item.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!clazz.getSimpleName().equals("ItemToolAdv")) continue;
            try {
                Field hlvlField = clazz.getDeclaredField("harvestLevel");
                hlvlField.setAccessible(true);
                hlvlField.set(item, hlvl);
            }
            catch (NoSuchFieldException e) {
                Log.error("Couldn't find harvestlevel of " + item.getUnlocalizedName());
            }
            catch (IllegalAccessException e) {
                Log.error("Couldn't change harvestlevel of " + item.getUnlocalizedName());
            }
            break;
        }
        if (item.getHarvestLevel(new ItemStack(item), toolClass) != hlvl) {
            Log.error("Could not set harvestlevel of " + item.getUnlocalizedName() + ". Contact the Mod Author to properly support Item.setHarvestLevel().");
        }
    }

    static {
        String[][][] lists = new String[][][]{oreDictLevels, oreDictLevelsMetallurgyFantasy, oreDictLevelsMetallurgyNether, oreDictLevelsMetallurgyEnd};
        allOreDicLevels = new String[oreDictLevels.length][];
        for (int i = 0; i < 10; ++i) {
            int size = 0;
            for (String[][] list : lists) {
                size += list.length;
            }
            HarvestLevelTweaks.allOreDicLevels[i] = new String[size];
            int j = 0;
            for (String[][] list : lists) {
                for (String entry : list[i]) {
                    HarvestLevelTweaks.allOreDicLevels[i][j++] = entry;
                }
            }
        }
    }
}

