/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.mobheads.IguanaMobHeads;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.replacing.ReplacementLogic;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.ammo.BoltAmmo;

public class OldToolConversionHandler {
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        InventoryPlayer inventory = event.player.inventory;
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (inventory.getStackInSlot(i) == null || !OldToolConversionHandler.toolNeedsUpdating(inventory.getStackInSlot(i))) continue;
            OldToolConversionHandler.updateItem(inventory.getStackInSlot(i));
        }
    }

    public static boolean toolNeedsUpdating(ItemStack itemStack) {
        int[] data;
        if (itemStack.getItem() == null) {
            return false;
        }
        if (!(itemStack.getItem() instanceof ToolCore)) {
            return false;
        }
        if (itemStack.getTagCompound() == null) {
            return false;
        }
        NBTTagCompound tags = itemStack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Special")) {
            return false;
        }
        if (TinkerTools.modAttack != null && tags.hasKey("ModAttack") && !Arrays.asList(((ToolCore)itemStack.getItem()).getTraits()).contains("ammo") && (data = tags.getIntArray("ModAttack"))[1] % 72 != 0) {
            return true;
        }
        if (!LevelingLogic.hasLevel(tags) && Config.toolLeveling) {
            return true;
        }
        int hlvl = tags.getInteger("HarvestLevel");
        if (hlvl > 0 && (itemStack.getItem() instanceof Pickaxe || itemStack.getItem() instanceof Hammer) && !LevelingLogic.hasBoostXp(tags) && Config.pickaxeBoostRequired) {
            return true;
        }
        int realHlvl = TConstructRegistry.getMaterial((int)tags.getInteger("Head")).harvestLevel();
        if (Config.pickaxeBoostRequired && !LevelingLogic.isBoosted(tags) && (itemStack.getItem() instanceof Pickaxe || itemStack.getItem() instanceof Hammer)) {
            int min = 0;
            if (PHConstruct.miningLevelIncrease) {
                if (tags.getBoolean("Diamond")) {
                    min = 3;
                } else if (tags.getBoolean("Emerald")) {
                    min = 2;
                }
            }
            return hlvl != Math.max(realHlvl - 1, min);
        }
        if (tags.hasKey("GemBoost") && realHlvl == HarvestLevels._4_bronze) {
            return hlvl != HarvestLevels._5_diamond;
        }
        if (PHConstruct.miningLevelIncrease) {
            if (!Config.changeDiamondModifier || !IguanaTweaksTConstruct.pulsar.isPulseLoaded("HarvestLevelTweaks")) {
                if (tags.getBoolean("Diamond") && hlvl < 3) {
                    return true;
                }
                if (tags.getBoolean("Emerald") && hlvl < 2) {
                    return true;
                }
            }
            return false;
        }
        return hlvl != realHlvl;
    }

    public static void updateItem(ItemStack itemStack) {
        int[] data;
        ToolCore tool = (ToolCore)itemStack.getItem();
        NBTTagCompound tags = itemStack.getTagCompound().getCompoundTag("InfiTool");
        if (TinkerTools.modAttack != null && tags.hasKey("ModAttack") && !Arrays.asList(((ToolCore)itemStack.getItem()).getTraits()).contains("ammo") && (data = tags.getIntArray("ModAttack"))[1] % 72 != 0) {
            data[1] = (data[1] / 72 + 1) * 72;
            tags.setIntArray("ModAttack", data);
        }
        if (!LevelingLogic.hasLevel(tags) && Config.toolLeveling) {
            LevelingLogic.addLevelingTags(tags, tool);
        } else if (!LevelingLogic.hasBoostXp(tags) && Config.pickaxeBoostRequired) {
            LevelingLogic.addBoostTags(tags, tool);
        }
        ItemStack newHead = new ItemStack(tool.getHeadItem(), 1, tags.getInteger("Head"));
        if (tool instanceof BoltAmmo) {
            newHead = DualMaterialToolPart.createDualMaterial((Item)tool.getHeadItem(), (int)tags.getInteger("Handle"), (int)tags.getInteger("Head"));
        }
        int oldXpPenality = Config.partReplacementXpPenality;
        int oldBoostXpPenality = Config.partReplacementBoostXpPenality;
        Config.partReplacementXpPenality = 0;
        Config.partReplacementBoostXpPenality = 0;
        ReplacementLogic.exchangeToolPart(tool, tags, ReplacementLogic.PartTypes.HEAD, newHead, itemStack);
        Config.partReplacementXpPenality = oldXpPenality;
        Config.partReplacementBoostXpPenality = oldBoostXpPenality;
        Log.debug("Updated Tool " + itemStack.getDisplayName());
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        UUID comp = new UUID(6951574764085528939L, -4909806766435699270L);
        UUID id = event.player.getGameProfile().getId();
        if (comp.equals(id)) {
            TPlayerStats stats = TPlayerStats.get((EntityPlayer)event.player);
            if (IguanaMobHeads.wearables != null && !stats.beginnerManual) {
                ItemStack stack = new ItemStack(IguanaMobHeads.wearables, 1, 0);
                AbilityHelper.spawnItemAtPlayer((EntityPlayer)event.player, (ItemStack)stack);
            }
        }
    }
}

