/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.natura;

import com.progwml6.natura.Natura;
import com.progwml6.natura.common.block.BlockEnumBerryBush;
import com.progwml6.natura.nether.block.bush.BlockNetherBerryBush;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.bush.BlockOverworldBerryBush;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;
import com.progwml6.natura.overworld.block.saguaro.BlockSaguaro;
import com.progwml6.natura.overworld.block.saguaro.BlockSaguaroBaby;
import com.progwml6.natura.shared.NaturaCommons;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.library.RecipeRemover;
import iguanaman.hungeroverhaul.module.bonemeal.BonemealModule;
import iguanaman.hungeroverhaul.module.bonemeal.modification.BonemealModification;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import squeek.applecore.api.food.FoodValues;

public class NaturaModule {
    public static Random random = new Random();
    private static Boolean isNaturaOverworldLoaded = Natura.pulseManager.isPulseLoaded("NaturaOverworld");
    private static Boolean isNaturaNetherLoaded = Natura.pulseManager.isPulseLoaded("NaturaNether");

    public static void init() {
        ShapelessOreRecipe sor;
        String registryName;
        random.setSeed(3244L);
        ItemStack barley = NaturaCommons.barley.copy();
        ItemStack barleySeeds = ItemStack.EMPTY;
        if (isNaturaOverworldLoaded.booleanValue()) {
            barleySeeds = NaturaOverworld.barley_seeds.copy();
        }
        ItemStack barleyFlour = NaturaCommons.barleyFlour.copy();
        ItemStack wheatFlour = NaturaCommons.wheatFlour.copy();
        if (Config.addSeedsCraftingRecipe && isNaturaOverworldLoaded.booleanValue() && barleySeeds != ItemStack.EMPTY) {
            registryName = "hungeroverhaul:barleyseeds";
            sor = new ShapelessOreRecipe(null, barleySeeds, new Object[]{barley});
            ForgeRegistries.RECIPES.register(sor.setRegistryName(registryName));
        }
        if (Config.removeNaturaFlourCraftingRecipes || Config.addSeedsCraftingRecipe) {
            RecipeRemover.removeAnyRecipe(barleyFlour);
            RecipeRemover.removeAnyRecipe(wheatFlour);
        }
        if (Config.removeNaturaFlourSmeltingRecipe) {
            RecipeRemover.removeFurnaceRecipe(barleyFlour);
            RecipeRemover.removeFurnaceRecipe(wheatFlour);
        }
        if (Config.addAlternateNaturaFlourCraftingRecipes) {
            registryName = "hungeroverhaul:barleyflour";
            sor = new ShapelessOreRecipe(null, barleyFlour, new Object[]{barley, barley});
            ForgeRegistries.RECIPES.register(sor.setRegistryName(registryName));
            String registryName1 = "hungeroverhaul:wheatflour";
            ShapelessOreRecipe sor1 = new ShapelessOreRecipe(null, wheatFlour, new Object[]{Items.WHEAT, Items.WHEAT});
            ForgeRegistries.RECIPES.register(sor1.setRegistryName(registryName1));
        }
        if (Config.modifyFoodValues && Config.useHOFoodValues) {
            if (isNaturaOverworldLoaded.booleanValue()) {
                FoodModifier.setModifiedFoodValues(NaturaCommons.raspberry, new FoodValues(1, 0.1f));
                FoodModifier.setModifiedFoodValues(NaturaCommons.blueberry, new FoodValues(1, 0.1f));
                FoodModifier.setModifiedFoodValues(NaturaCommons.blackberry, new FoodValues(1, 0.1f));
                FoodModifier.setModifiedFoodValues(NaturaCommons.maloberry, new FoodValues(1, 0.1f));
            }
            if (isNaturaNetherLoaded.booleanValue()) {
                FoodModifier.setModifiedFoodValues(NaturaCommons.blightberry, new FoodValues(1, 0.1f));
                FoodModifier.setModifiedFoodValues(NaturaCommons.duskberry, new FoodValues(1, 0.1f));
                FoodModifier.setModifiedFoodValues(NaturaCommons.skyberry, new FoodValues(1, 0.1f));
                FoodModifier.setModifiedFoodValues(NaturaCommons.stingberry, new FoodValues(1, 0.1f));
            }
            if (isNaturaOverworldLoaded.booleanValue()) {
                FoodModifier.setModifiedFoodValues(NaturaCommons.berryMedley, new FoodValues(3, 0.15f));
            }
        }
        PlantGrowthModification cottonGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.FOREST, 1.0f).setBiomeGrowthModifier(BiomeDictionary.Type.PLAINS, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNaturaCotton.class, cottonGrowthModification);
        PlantGrowthModification barleyGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.FOREST, 1.0f).setBiomeGrowthModifier(BiomeDictionary.Type.PLAINS, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNaturaBarley.class, barleyGrowthModification);
        PlantGrowthModification saguaroGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cactusRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.SANDY, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockSaguaro.class, saguaroGrowthModification);
        PlantGrowthModule.registerPlantGrowthModifier(BlockSaguaroBaby.class, saguaroGrowthModification);
        PlantGrowthModification berryBushGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.FOREST, 1.0f).setBiomeGrowthModifier(BiomeDictionary.Type.PLAINS, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockOverworldBerryBush.class, berryBushGrowthModification);
        PlantGrowthModification netherBushGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.NETHER, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNetherBerryBush.class, netherBushGrowthModification);
        BonemealModification naturaCottonBonemealModification = new BonemealModification(){

            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState) {
                int currentMeta = (Integer)currentState.getValue((IProperty)BlockNaturaCotton.AGE);
                int metaFullyGrown = 4;
                int metaIncrease = 0;
                if (currentMeta != metaFullyGrown) {
                    metaIncrease = 1;
                    if (Config.difficultyScalingBoneMeal && world.getDifficulty().ordinal() < EnumDifficulty.NORMAL.ordinal()) {
                        int metaRandomIncreaseRange = currentMeta < 3 ? 2 : 3;
                        metaIncrease += random.nextInt(metaRandomIncreaseRange);
                    }
                }
                return currentState.withProperty((IProperty)BlockNaturaCotton.AGE, (Comparable)Integer.valueOf(Math.min(currentMeta + metaIncrease, metaFullyGrown)));
            }
        };
        BonemealModule.registerBonemealModifier(BlockNaturaCotton.class, naturaCottonBonemealModification);
        BonemealModification naturaBarleyBonemealModification = new BonemealModification(){

            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState) {
                int currentMeta = (Integer)currentState.getValue((IProperty)BlockNaturaBarley.AGE);
                int metaFullyGrown = 3;
                int metaIncrease = 0;
                if (currentMeta != metaFullyGrown) {
                    metaIncrease = 1;
                    if (Config.difficultyScalingBoneMeal && world.getDifficulty().ordinal() < EnumDifficulty.NORMAL.ordinal()) {
                        int metaRandomIncreaseRange = currentMeta < 3 ? 2 : 3;
                        metaIncrease += random.nextInt(metaRandomIncreaseRange);
                    }
                }
                return currentState.withProperty((IProperty)BlockNaturaBarley.AGE, (Comparable)Integer.valueOf(Math.min(currentMeta + metaIncrease, metaFullyGrown)));
            }
        };
        BonemealModule.registerBonemealModifier(BlockNaturaBarley.class, naturaBarleyBonemealModification);
        BonemealModification naturaBushBonemealModification = new BonemealModification(){

            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState) {
                int currentMeta;
                int resultingMeta = currentMeta = ((Integer)currentState.getValue((IProperty)BlockEnumBerryBush.AGE)).intValue();
                if (currentMeta / 4 < 2 && (!(currentState.getBlock() instanceof BlockNetherBerryBush) || world.rand.nextBoolean())) {
                    int setMeta = world.rand.nextInt(2) + 1 + currentMeta / 4;
                    if (setMeta > 2) {
                        setMeta = 2;
                    }
                    if (Config.difficultyScalingBoneMeal && world.getDifficulty().ordinal() >= EnumDifficulty.NORMAL.ordinal()) {
                        setMeta = 1;
                    }
                    resultingMeta = currentMeta % 4 + setMeta * 4;
                }
                return currentState.withProperty((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(resultingMeta));
            }

            @Override
            public void onBonemeal(World world, BlockPos pos, IBlockState state, IBlockState resultingState) {
                BlockPos posUp = pos.up();
                IBlockState stateAbove = world.getBlockState(posUp);
                if (stateAbove == null || stateAbove.getBlock().isAir(stateAbove, (IBlockAccess)world, posUp)) {
                    int randomRange;
                    int n = randomRange = state.getBlock() instanceof BlockNetherBerryBush ? 6 : 3;
                    if (world.rand.nextInt(randomRange) == 0) {
                        world.setBlockState(posUp, state.withProperty((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf((Integer)resultingState.getValue((IProperty)BlockEnumBerryBush.AGE) % 4)), 3);
                    }
                }
            }
        };
        BonemealModule.registerBonemealModifier(BlockOverworldBerryBush.class, naturaBushBonemealModification);
        BonemealModule.registerBonemealModifier(BlockNetherBerryBush.class, naturaBushBonemealModification);
    }
}

