/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.json;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import iguanaman.hungeroverhaul.HungerOverhaul;
import iguanaman.hungeroverhaul.food.FoodModifier;
import iguanaman.hungeroverhaul.json.Food;
import iguanaman.hungeroverhaul.json.GameObject;
import iguanaman.hungeroverhaul.json.HOJsonData;
import iguanaman.hungeroverhaul.util.IguanaEventHook;
import iguanaman.hungeroverhaul.util.ItemAndBlockList;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.FilenameUtils;
import squeek.applecore.api.food.FoodValues;

public class JsonModule {
    private static Gson GSON;
    private static List<File> hojsons;
    private static List<HOJsonData> hoData;

    public static void preinit(File configFolder) {
        GsonBuilder builder = new GsonBuilder();
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        GSON = builder.create();
        File hoFolder = new File(configFolder, "HungerOverhaul");
        if (!hoFolder.exists()) {
            hoFolder.mkdirs();
        }
        for (File potentialConfigFile : configFolder.listFiles()) {
            if (!FilenameUtils.getExtension((String)potentialConfigFile.getName()).equalsIgnoreCase("json")) continue;
            hojsons.add(potentialConfigFile);
        }
    }

    public static void init() {
        HungerOverhaul.Log.info("Loading JSON Files");
        for (File j : hojsons) {
            try {
                FileReader reader = new FileReader(j);
                HOJsonData hod = (HOJsonData)GSON.fromJson((Reader)reader, HOJsonData.class);
                reader.close();
                hoData.add(hod);
            }
            catch (Exception e) {
                HungerOverhaul.Log.warn("Error Loading json files: ", (Throwable)e);
            }
        }
        HungerOverhaul.Log.info("Loading data from json");
        for (HOJsonData h : hoData) {
            if (h == null) continue;
            if (h.foods != null) {
                for (Food f : h.foods) {
                    ItemStack itemStack = f.toItemStack();
                    FoodValues foodValues = f.toFoodValues();
                    if (itemStack == null || itemStack.getItem() == null || foodValues == null) continue;
                    FoodModifier.setModifiedFoodValues(itemStack, foodValues);
                }
            }
            if (h.foodsBlacklist != null) {
                for (GameObject gameObj : h.foodsBlacklist) {
                    JsonModule.addGameObjectToList(FoodModifier.blacklist, gameObj);
                }
            }
            if (h.dropsBlacklist != null) {
                for (GameObject gameObj : h.dropsBlacklist) {
                    JsonModule.addGameObjectToList(IguanaEventHook.harvestDropsBlacklist, gameObj);
                }
            }
            if (h.harvestBlacklist == null) continue;
            for (GameObject gameObj : h.harvestBlacklist) {
                JsonModule.addGameObjectToList(IguanaEventHook.rightClickHarvestBlacklist, gameObj);
            }
        }
        HungerOverhaul.Log.info("Loaded all data from JSON");
    }

    public static void addGameObjectToList(ItemAndBlockList list, GameObject gameObj) {
        if (gameObj.name.isEmpty()) {
            return;
        }
        if (gameObj.meta == Short.MAX_VALUE) {
            if (gameObj.toBlock() != null) {
                list.add(gameObj.toBlock());
            }
            if (gameObj.toItem() != null) {
                list.add(gameObj.toItem());
            }
        } else {
            ItemStack itemStack = gameObj.toItemStack();
            if (itemStack != null) {
                list.add(itemStack);
            }
        }
    }

    static {
        hojsons = Lists.newArrayList();
        hoData = Lists.newArrayList();
    }
}

