package iguanaman.hungeroverhaul.module.natura;

import com.progwml6.natura.Natura;
import com.progwml6.natura.common.block.BlockEnumBerryBush;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.bush.BlockNetherBerryBush;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.bush.BlockOverworldBerryBush;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;
import com.progwml6.natura.overworld.block.saguaro.BlockSaguaro;
import com.progwml6.natura.overworld.block.saguaro.BlockSaguaroBaby;
import com.progwml6.natura.shared.NaturaCommons;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.library.RecipeRemover;
import iguanaman.hungeroverhaul.library.Util;
import iguanaman.hungeroverhaul.module.bonemeal.BonemealModule;
import iguanaman.hungeroverhaul.module.bonemeal.modification.BonemealModification;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary.Type;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import squeek.applecore.api.food.FoodValues;

import java.util.Random;

public class NaturaModule
{
    public static Random random = new Random();

    private static Boolean isNaturaOverworldLoaded = Natura.pulseManager.isPulseLoaded(NaturaOverworld.PulseId);

    private static Boolean isNaturaNetherLoaded = Natura.pulseManager.isPulseLoaded(NaturaNether.PulseId);

    public static void init()
    {
        random.setSeed(2 ^ 16 + 2 ^ 8 + (4 * 3 * 271));

        ItemStack barley = NaturaCommons.barley.func_77946_l();
        ItemStack barleySeeds = ItemStack.field_190927_a;

        if (isNaturaOverworldLoaded)
        {
            barleySeeds = NaturaOverworld.barley_seeds.func_77946_l();
        }

        ItemStack barleyFlour = NaturaCommons.barleyFlour.func_77946_l();
        ItemStack wheatFlour = NaturaCommons.wheatFlour.func_77946_l();

        if (Config.addSeedsCraftingRecipe && isNaturaOverworldLoaded && barleySeeds != ItemStack.field_190927_a)
        {
            String registryName = Util.MODID + ":barleyseeds";

            ShapelessOreRecipe sor = new ShapelessOreRecipe(null, barleySeeds, barley);

            ForgeRegistries.RECIPES.register(sor.setRegistryName(registryName));
        }

        // seed recipe conflicts with the default flour recipe, so remove it
        if (Config.removeNaturaFlourCraftingRecipes || Config.addSeedsCraftingRecipe)
        {
            RecipeRemover.removeAnyRecipe(barleyFlour);
            RecipeRemover.removeAnyRecipe(wheatFlour);
        }

        if (Config.removeNaturaFlourSmeltingRecipe)
        {
            RecipeRemover.removeFurnaceRecipe(barleyFlour);
            RecipeRemover.removeFurnaceRecipe(wheatFlour);
        }

        if (Config.addAlternateNaturaFlourCraftingRecipes)
        {
            String registryName = Util.MODID + ":barleyflour";

            ShapelessOreRecipe sor = new ShapelessOreRecipe(null, barleyFlour, barley, barley);

            ForgeRegistries.RECIPES.register(sor.setRegistryName(registryName));

            String registryName1 = Util.MODID + ":wheatflour";

            ShapelessOreRecipe sor1 = new ShapelessOreRecipe(null, wheatFlour, Items.field_151015_O, Items.field_151015_O);

            ForgeRegistries.RECIPES.register(sor1.setRegistryName(registryName1));
        }

        /*
         * Food values
         */
        if (Config.modifyFoodValues && Config.useHOFoodValues)
        {
            if (isNaturaOverworldLoaded)
            {
                FoodModifier.setModifiedFoodValues(NaturaCommons.raspberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.blueberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.blackberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.maloberry, new FoodValues(1, 0.1F));
            }

            if (isNaturaNetherLoaded)
            {
                FoodModifier.setModifiedFoodValues(NaturaCommons.blightberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.duskberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.skyberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.stingberry, new FoodValues(1, 0.1F));
            }

            if (isNaturaOverworldLoaded)
            {
                FoodModifier.setModifiedFoodValues(NaturaCommons.berryMedley, new FoodValues(3, 0.15F));
            }
        }

        /*
         * Plant growth
         */
        PlantGrowthModification cottonGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.FOREST, 1).setBiomeGrowthModifier(Type.PLAINS, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNaturaCotton.class, cottonGrowthModification);

        PlantGrowthModification barleyGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.FOREST, 1).setBiomeGrowthModifier(Type.PLAINS, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNaturaBarley.class, barleyGrowthModification);

        PlantGrowthModification saguaroGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cactusRegrowthMultiplier).setBiomeGrowthModifier(Type.SANDY, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockSaguaro.class, saguaroGrowthModification);
        PlantGrowthModule.registerPlantGrowthModifier(BlockSaguaroBaby.class, saguaroGrowthModification);

        PlantGrowthModification berryBushGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.FOREST, 1).setBiomeGrowthModifier(Type.PLAINS, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockOverworldBerryBush.class, berryBushGrowthModification);

        PlantGrowthModification netherBushGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.NETHER, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNetherBerryBush.class, netherBushGrowthModification);

        /*
         * Bonemeal
         */
        BonemealModification naturaCottonBonemealModification = new BonemealModification()
        {
            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState)
            {
                int currentMeta = currentState.func_177229_b(BlockNaturaCotton.AGE);
                int metaFullyGrown = 4;
                int metaIncrease = 0;

                if (currentMeta != metaFullyGrown)
                {
                    metaIncrease = 1;

                    if (Config.difficultyScalingBoneMeal && world.func_175659_aa().ordinal() < EnumDifficulty.NORMAL.ordinal())
                    {
                        int metaRandomIncreaseRange = currentMeta < 3 ? 2 : 3;
                        metaIncrease += random.nextInt(metaRandomIncreaseRange);
                    }
                }

                return currentState.func_177226_a(BlockNaturaCotton.AGE, Math.min(currentMeta + metaIncrease, metaFullyGrown));
            }
        };
        BonemealModule.registerBonemealModifier(BlockNaturaCotton.class, naturaCottonBonemealModification);

        BonemealModification naturaBarleyBonemealModification = new BonemealModification()
        {
            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState)
            {
                int currentMeta = currentState.func_177229_b(BlockNaturaBarley.AGE);
                int metaFullyGrown = 3;
                int metaIncrease = 0;

                if (currentMeta != metaFullyGrown)
                {
                    metaIncrease = 1;

                    if (Config.difficultyScalingBoneMeal && world.func_175659_aa().ordinal() < EnumDifficulty.NORMAL.ordinal())
                    {
                        int metaRandomIncreaseRange = currentMeta < 3 ? 2 : 3;
                        metaIncrease += random.nextInt(metaRandomIncreaseRange);
                    }
                }

                return currentState.func_177226_a(BlockNaturaBarley.AGE, Math.min(currentMeta + metaIncrease, metaFullyGrown));
            }
        };
        BonemealModule.registerBonemealModifier(BlockNaturaBarley.class, naturaBarleyBonemealModification);

        BonemealModification naturaBushBonemealModification = new BonemealModification()
        {
            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState)
            {
                int currentMeta = currentState.func_177229_b(BlockEnumBerryBush.AGE);

                int resultingMeta = currentMeta;

                if (currentMeta / 4 < 2)
                {
                    if (!(currentState.func_177230_c() instanceof BlockNetherBerryBush) || world.field_73012_v.nextBoolean())
                    {
                        int setMeta = world.field_73012_v.nextInt(2) + 1 + currentMeta / 4;

                        if (setMeta > 2)
                        {
                            setMeta = 2;
                        }
                        if (Config.difficultyScalingBoneMeal && world.func_175659_aa().ordinal() >= EnumDifficulty.NORMAL.ordinal())
                        {
                            setMeta = 1;
                        }

                        resultingMeta = currentMeta % 4 + setMeta * 4;
                    }
                }
                return currentState.func_177226_a(BlockEnumBerryBush.AGE, resultingMeta);
            }

            @Override
            public void onBonemeal(World world, BlockPos pos, IBlockState state, IBlockState resultingState)
            {
                BlockPos posUp = pos.func_177984_a();
                IBlockState stateAbove = world.func_180495_p(posUp);

                if (stateAbove == null || stateAbove.func_177230_c().isAir(stateAbove, world, posUp))
                {
                    int randomRange = state.func_177230_c() instanceof BlockNetherBerryBush ? 6 : 3;

                    if (world.field_73012_v.nextInt(randomRange) == 0)
                    {
                        world.func_180501_a(posUp, state.func_177226_a(BlockEnumBerryBush.AGE, resultingState.func_177229_b(BlockEnumBerryBush.AGE) % 4), 3);
                    }
                }
            }
        };
        BonemealModule.registerBonemealModifier(BlockOverworldBerryBush.class, naturaBushBonemealModification);
        BonemealModule.registerBonemealModifier(BlockNetherBerryBush.class, naturaBushBonemealModification);
    }

}
