/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.event;

import com.google.common.collect.ImmutableList;
import iguanaman.hungeroverhaul.HungerOverhaul;
import iguanaman.hungeroverhaul.library.ItemAndBlockList;
import iguanaman.hungeroverhaul.module.event.HungerOverhaulEventHook;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    public static String BLACKLIST_RIGHT_CLICK = "BlacklistRightClick";
    public static String BLACKLIST_DROPS = "BlacklistDrops";
    public static String BLACKLIST_FOOD = "BlacklistFood";

    public static void processMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            ItemAndBlockList blacklist = null;
            if (message.key.equalsIgnoreCase(BLACKLIST_RIGHT_CLICK)) {
                blacklist = HungerOverhaulEventHook.rightClickHarvestBlacklist;
            } else if (message.key.equalsIgnoreCase(BLACKLIST_DROPS)) {
                blacklist = HungerOverhaulEventHook.harvestDropsBlacklist;
            } else if (message.key.equalsIgnoreCase(BLACKLIST_FOOD)) {
                blacklist = FoodModifier.blacklist;
            }
            if (blacklist == null) continue;
            if (message.isItemStackMessage() && message.getItemStackValue() != null) {
                blacklist.add(message.getItemStackValue());
                continue;
            }
            if (!message.isStringMessage() || message.getStringValue() == null) continue;
            try {
                blacklist.add(message.getStringValue());
            }
            catch (ClassNotFoundException e) {
                HungerOverhaul.log.error("Class to blacklist not found (IMC sent by mod " + message.getSender() + ")");
                e.printStackTrace();
            }
        }
    }
}

