/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.growth;

import iguanaman.hungeroverhaul.common.RandomHelper;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlantGrowthModule {
    private static HashMap<Class<? extends Block>, PlantGrowthModification> plantGrowthModificationsByBlockClass = new HashMap();
    private static HashMap<Block, PlantGrowthModification> plantGrowthModificationsByBlock = new HashMap();

    public static void registerPlantGrowthModifier(Class<? extends Block> blockClass, PlantGrowthModification growthModification) {
        plantGrowthModificationsByBlockClass.put(blockClass, growthModification);
    }

    public static void registerPlantGrowthModifier(Block block, PlantGrowthModification growthModification) {
        plantGrowthModificationsByBlock.put(block, growthModification);
    }

    public static PlantGrowthModification getPlantGrowthModification(Block block) {
        if (block == null) {
            return null;
        }
        PlantGrowthModification growthModification = plantGrowthModificationsByBlock.get(block);
        if (growthModification != null) {
            return growthModification;
        }
        return PlantGrowthModule.getPlantGrowthModification(block.getClass());
    }

    public static PlantGrowthModification getPlantGrowthModification(Class<? extends Block> blockClass) {
        PlantGrowthModification growthModifier = plantGrowthModificationsByBlockClass.get(blockClass);
        if (growthModifier == null) {
            for (Map.Entry<Class<? extends Block>, PlantGrowthModification> entry : plantGrowthModificationsByBlockClass.entrySet()) {
                if (!entry.getKey().isAssignableFrom(blockClass)) continue;
                return entry.getValue();
            }
        }
        return growthModifier;
    }

    @SubscribeEvent
    public void allowGrowthTick(BlockEvent.CropGrowEvent.Pre event) {
        float sunlightModifier;
        PlantGrowthModification growthModification = PlantGrowthModule.getPlantGrowthModification(event.getState().func_177230_c().getClass());
        if (growthModification == null) {
            return;
        }
        float f = sunlightModifier = !growthModification.needsSunlight || growthModification.needsSunlight && event.getWorld().func_72935_r() && event.getWorld().func_175678_i(event.getPos()) ? 1.0f : Config.noSunlightRegrowthMultiplier;
        if (sunlightModifier == 0.0f) {
            event.setResult(Event.Result.DENY);
            return;
        }
        float biomeModifier = growthModification.wrongBiomeMultiplier;
        if (!growthModification.biomeGrowthModifiers.isEmpty()) {
            biomeModifier = Config.wrongBiomeRegrowthMultiplier;
            Biome biome = event.getWorld().func_180494_b(event.getPos());
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                if (!growthModification.biomeGrowthModifiers.containsKey(type)) continue;
                biomeModifier = growthModification.getBiomeGrowthModifier(type);
                break;
            }
        }
        if (biomeModifier == 0.0f) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (RandomHelper.nextFloat(event.getWorld().field_73012_v, growthModification.growthTickProbability * biomeModifier * sunlightModifier) >= 1.0f) {
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setResult(Event.Result.DEFAULT);
    }
}

