/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.vanilla;

import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.library.RecipeRemover;
import iguanaman.hungeroverhaul.module.bonemeal.BonemealModule;
import iguanaman.hungeroverhaul.module.bonemeal.modification.BonemealModification;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import squeek.applecore.api.food.FoodValues;

public class VanillaModule {
    public static void init() {
        if (Config.addSeedsCraftingRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.WHEAT_SEEDS, new Object[]{Items.WHEAT}));
        }
        if (Config.modifyFoodValues && Config.useHOFoodValues) {
            FoodModifier.setModifiedFoodValues(Items.APPLE, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.BREAD, new FoodValues(3, 0.2f));
            FoodModifier.setModifiedFoodValues(Items.PORKCHOP, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.COOKED_PORKCHOP, new FoodValues(2, 0.15f));
            FoodModifier.setModifiedFoodValues(Items.FISH, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.COOKED_FISH, new FoodValues(2, 0.1f));
            FoodModifier.setModifiedFoodValues(Items.COOKIE, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.MELON, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.BEEF, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.COOKED_BEEF, new FoodValues(2, 0.15f));
            FoodModifier.setModifiedFoodValues(Items.CHICKEN, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.COOKED_CHICKEN, new FoodValues(2, 0.15f));
            FoodModifier.setModifiedFoodValues(Items.ROTTEN_FLESH, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.BAKED_POTATO, new FoodValues(2, 0.15f));
            FoodModifier.setModifiedFoodValues(Items.POISONOUS_POTATO, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.PUMPKIN_PIE, new FoodValues(3, 0.15f));
            FoodModifier.setModifiedFoodValues(Items.MUSHROOM_STEW, new FoodValues(2, 0.1f));
            FoodModifier.setModifiedFoodValues(Items.CARROT, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.POTATO, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.MUTTON, new FoodValues(1, 0.05f));
            FoodModifier.setModifiedFoodValues(Items.COOKED_MUTTON, new FoodValues(2, 0.1f));
        }
        PlantGrowthModification cropGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.FOREST, 1.0f).setBiomeGrowthModifier(BiomeDictionary.Type.PLAINS, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockCrops.class, cropGrowthModification);
        PlantGrowthModule.registerPlantGrowthModifier(BlockCarrot.class, cropGrowthModification);
        PlantGrowthModule.registerPlantGrowthModifier(BlockPotato.class, cropGrowthModification);
        PlantGrowthModule.registerPlantGrowthModifier(BlockBeetroot.class, cropGrowthModification);
        PlantGrowthModification reedGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.sugarcaneRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.JUNGLE, 1.0f).setBiomeGrowthModifier(BiomeDictionary.Type.SWAMP, 1.0f).setWrongBiomeMultiplier(Config.wrongBiomeRegrowthMultiplierSugarcane);
        PlantGrowthModule.registerPlantGrowthModifier(BlockReed.class, reedGrowthModification);
        PlantGrowthModification stemGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.JUNGLE, 1.0f).setBiomeGrowthModifier(BiomeDictionary.Type.SWAMP, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockStem.class, stemGrowthModification);
        PlantGrowthModification cocoaGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cocoaRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.JUNGLE, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockCocoa.class, cocoaGrowthModification);
        PlantGrowthModification cactusGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cactusRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.SANDY, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockCactus.class, cactusGrowthModification);
        PlantGrowthModification saplingGrowthModification = new PlantGrowthModification().setGrowthTickProbability(Config.saplingRegrowthMultiplier);
        PlantGrowthModule.registerPlantGrowthModifier(BlockSapling.class, saplingGrowthModification);
        PlantGrowthModification netherWartGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.netherWartRegrowthMultiplier).setBiomeGrowthModifier(BiomeDictionary.Type.NETHER, 1.0f);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNetherWart.class, netherWartGrowthModification);
        BonemealModification cropBonemealModification = new BonemealModification(){

            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState) {
                if (currentState.getBlock() instanceof BlockCrops) {
                    int currentMeta = (Integer)currentState.getValue((IProperty)BlockCrops.AGE);
                    int metaIncrease = 1;
                    if (Config.difficultyScalingBoneMeal && world.getDifficulty().getDifficultyId() < EnumDifficulty.EASY.getDifficultyId()) {
                        metaIncrease = world.rand.nextInt(3);
                    }
                    return currentState.withProperty((IProperty)BlockCrops.AGE, (Comparable)Integer.valueOf(Math.min(currentMeta + metaIncrease, 7)));
                }
                return currentState;
            }
        };
        BonemealModule.registerBonemealModifier(BlockCrops.class, cropBonemealModification);
        BonemealModule.registerBonemealModifier(BlockCarrot.class, cropBonemealModification);
        BonemealModule.registerBonemealModifier(BlockPotato.class, cropBonemealModification);
        BonemealModification beetrootBonemealModification = new BonemealModification(){

            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState) {
                if (currentState.getBlock() instanceof BlockBeetroot) {
                    int currentMeta = (Integer)currentState.getValue((IProperty)BlockBeetroot.BEETROOT_AGE);
                    int metaIncrease = 1;
                    if (Config.difficultyScalingBoneMeal && world.getDifficulty().getDifficultyId() < EnumDifficulty.EASY.getDifficultyId()) {
                        metaIncrease = world.rand.nextInt(2);
                    }
                    return currentState.withProperty((IProperty)BlockBeetroot.BEETROOT_AGE, (Comparable)Integer.valueOf(Math.min(currentMeta + metaIncrease, 3)));
                }
                return currentState;
            }
        };
        BonemealModule.registerBonemealModifier(BlockBeetroot.class, beetrootBonemealModification);
    }

    public static void postInit() {
        if (Config.removeHoeRecipes) {
            RecipeRemover.removeAnyRecipe(new ItemStack(Items.WOODEN_HOE));
            RecipeRemover.removeAnyRecipe(new ItemStack(Items.STONE_HOE));
        }
    }
}

