/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.common;

import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.progwml6.natura.overworld.NaturaOverworld;
import iguanaman.hungeroverhaul.common.RandomHelper;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.natura.helper.NaturaHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class BlockHelper {
    public static List<ItemStack> modifyCropDrops(List<ItemStack> drops, IBlockState state, int minSeeds, int maxSeeds, int minProduce, int maxProduce) {
        ArrayList<ItemStack> modifiedDrops = new ArrayList<ItemStack>();
        int seeds = RandomHelper.getRandomIntFromRange(minSeeds, maxSeeds);
        int produce = RandomHelper.getRandomIntFromRange(minProduce, maxProduce);
        ItemStack seedItem = BlockHelper.getSeedsOfBlock(state, seeds);
        ItemStack produceItem = BlockHelper.getProduceOfBlock(state, produce);
        boolean produceIsNotSeed = seedItem.getItem() != produceItem.getItem() || seedItem.getItemDamage() != produceItem.getItemDamage();
        for (ItemStack item : drops) {
            if (item.isItemEqual(seedItem) || item.isItemEqual(produceItem)) continue;
            modifiedDrops.add(item);
        }
        if (produceIsNotSeed && seedItem.stackSize > 0) {
            modifiedDrops.add(seedItem);
        }
        if (produceItem.stackSize > 0) {
            modifiedDrops.add(produceItem);
        }
        return modifiedDrops;
    }

    public static ItemStack getSeedOfBlock(IBlockState state) {
        return BlockHelper.getSeedsOfBlock(state, 1);
    }

    public static ItemStack getSeedsOfBlock(IBlockState state, int num) {
        return new ItemStack(BlockHelper.getSeedItem(state), num, BlockHelper.getSeedMetadata(state));
    }

    public static ItemStack getProduceOfBlock(IBlockState state) {
        return BlockHelper.getProduceOfBlock(state, 1);
    }

    public static ItemStack getProduceOfBlock(IBlockState state, int num) {
        return new ItemStack(BlockHelper.getProduceItem(state), num, BlockHelper.getProduceMetadata(state));
    }

    public static Item getSeedItem(IBlockState state) {
        Item seedForProduct;
        Item itemDropped = state.getBlock().getItemDropped(state, RandomHelper.random, 0);
        if (Loader.isModLoaded((String)"natura") && (state.getBlock() == NaturaOverworld.barleyCrop || state.getBlock() == NaturaOverworld.cottonCrop)) {
            Item seedForProduct2 = NaturaHelper.cropToSeedMap.get(state.getBlock());
            if (seedForProduct2 != null) {
                return seedForProduct2;
            }
        } else if (Loader.isModLoaded((String)"harvestcraft") && state.getBlock() instanceof BlockPamCrop && (seedForProduct = PamsModsHelper.productToSeedMap.get(itemDropped)) != null) {
            return seedForProduct;
        }
        return itemDropped;
    }

    public static Item getProduceItem(IBlockState state) {
        return state.getBlock().getItemDropped(state, RandomHelper.random, 0);
    }

    public static int getProduceMetadata(IBlockState state) {
        return state.getBlock().damageDropped(state);
    }

    public static int getSeedMetadata(IBlockState state) {
        if (Loader.isModLoaded((String)"natura") && state.getBlock() == NaturaOverworld.barleyCrop) {
            return NaturaOverworld.barley_seeds.copy().getItemDamage();
        }
        if (Loader.isModLoaded((String)"natura") && state.getBlock() == NaturaOverworld.cottonCrop) {
            return NaturaOverworld.cotton_seeds.copy().getItemDamage();
        }
        return state.getBlock().damageDropped(state);
    }
}

