/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.bonemeal;

import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.bonemeal.modification.BonemealModification;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BonemealModule {
    private static HashMap<Class<? extends Block>, BonemealModification> bonemealModificationsByBlockClass = new HashMap();
    private static HashMap<Block, BonemealModification> bonemealModificationsByBlock = new HashMap();

    public static void registerBonemealModifier(Class<? extends Block> blockClass, BonemealModification bonemealModification) {
        bonemealModificationsByBlockClass.put(blockClass, bonemealModification);
    }

    public static void registerBonemealModifier(Block block, BonemealModification bonemealModification) {
        bonemealModificationsByBlock.put(block, bonemealModification);
    }

    public static BonemealModification getBonemealModification(Block block) {
        BonemealModification bonemealModification = bonemealModificationsByBlock.get(block);
        if (bonemealModification != null) {
            return bonemealModification;
        }
        return BonemealModule.getBonemealModification(block.getClass());
    }

    public static BonemealModification getBonemealModification(Class<? extends Block> blockClass) {
        BonemealModification bonemealModification = bonemealModificationsByBlockClass.get(blockClass);
        if (bonemealModification == null) {
            for (Map.Entry<Class<? extends Block>, BonemealModification> entry : bonemealModificationsByBlockClass.entrySet()) {
                if (!entry.getKey().isInstance(blockClass)) continue;
                return entry.getValue();
            }
        }
        return bonemealModification;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBonemealUsed(BonemealEvent event) {
        if (event.getWorld().isRemote) {
            return;
        }
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled() || Config.bonemealEffectiveness == 1.0f) {
            return;
        }
        BonemealModification bonemealModification = BonemealModule.getBonemealModification(event.getBlock().getBlock());
        if (bonemealModification == null) {
            return;
        }
        if (Config.bonemealEffectiveness == 0.0f) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (event.getWorld().rand.nextFloat() < Config.bonemealEffectiveness) {
            if (Config.modifyBonemealGrowth) {
                IBlockState resultingState;
                IBlockState state = event.getWorld().getBlockState(event.getPos());
                if (state != (resultingState = bonemealModification.getNewState(event.getWorld(), event.getPos(), state))) {
                    event.getWorld().setBlockState(event.getPos(), resultingState, 3);
                }
                bonemealModification.onBonemeal(event.getWorld(), event.getPos(), event.getBlock(), resultingState);
                event.setResult(Event.Result.ALLOW);
            }
        } else {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

