/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.client;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mods.natura.blocks.trees.SaguaroBlock;
import mods.natura.client.NProxyClient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;

public class SaguaroRenderer
implements ISimpleBlockRenderingHandler {
    public static int model = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            NProxyClient.renderStandardInvBlock(renderer, block, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            int meta = world.func_72805_g(x, y, z);
            if (meta == 0) {
                return this.renderCactus(renderer, world, x, y, z, (SaguaroBlock)block);
            }
            if (meta == 1 || meta == 2) {
                return this.renderSmall(renderer, world, x, y, z, block);
            }
            return this.renderFruit((SaguaroBlock)block, x, y, z, world, meta);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return model;
    }

    boolean renderCactus(RenderBlocks renderblocks, IBlockAccess iblockaccess, int x, int y, int z, SaguaroBlock cactus) {
        float offset;
        float botX = offset = 0.125f;
        float botY = 0.0f;
        float botZ = offset;
        float topX = 1.0f - offset;
        float topY = 1.0f - offset;
        float topZ = 1.0f - offset;
        int airBelow = iblockaccess.func_72798_a(x, y - 1, z);
        int cactusAbove = iblockaccess.func_72798_a(x, y + 1, z);
        if (airBelow == 0) {
            botY = offset;
        }
        if (cactusAbove == cactus.field_71990_ca) {
            topY = 1.0f;
        }
        renderblocks.func_83020_a((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
        renderblocks.func_78570_q((Block)cactus, x, y, z);
        botY = offset;
        topY = 1.0f - offset;
        if (cactus.canConnectSuguaroTo(iblockaccess, x + 1, y, z) && (airBelow == 0 || iblockaccess.func_72798_a(x + 1, y - 1, z) == 0)) {
            botX = 1.0f - offset;
            topX = 1.0f;
            renderblocks.func_83020_a((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.func_78570_q((Block)cactus, x, y, z);
        }
        if (cactus.canConnectSuguaroTo(iblockaccess, x - 1, y, z) && (airBelow == 0 || iblockaccess.func_72798_a(x - 1, y - 1, z) == 0)) {
            botX = 0.0f;
            topX = offset;
            renderblocks.func_83020_a((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.func_78570_q((Block)cactus, x, y, z);
        }
        botX = offset;
        topX = 1.0f - offset;
        if (cactus.canConnectSuguaroTo(iblockaccess, x, y, z + 1) && (airBelow == 0 || iblockaccess.func_72798_a(x, y - 1, z + 1) == 0)) {
            botZ = 1.0f - offset;
            topZ = 1.0f;
            renderblocks.func_83020_a((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.func_78570_q((Block)cactus, x, y, z);
        }
        if (cactus.canConnectSuguaroTo(iblockaccess, x, y, z - 1) && (airBelow == 0 || iblockaccess.func_72798_a(x, y - 1, z - 1) == 0)) {
            botZ = 0.0f;
            topZ = offset;
            renderblocks.func_83020_a((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.func_78570_q((Block)cactus, x, y, z);
        }
        return true;
    }

    public boolean renderFruit(SaguaroBlock block, int x, int y, int z, IBlockAccess world, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_71874_e(world, x, y, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        int direction = BlockDirectional.func_72217_d((int)meta);
        int sizer = SaguaroBlock.func_72219_c(meta + 5);
        if (sizer > 4) {
            sizer = 0;
        }
        Icon icon = block.icons[3];
        int offsetX = 4 + sizer * 2;
        int offsetY = 5 + sizer * 2;
        double d0 = 16.0 - (double)offsetX;
        double d1 = 16.0;
        double d2 = 4.0;
        double d3 = 4.0 + (double)offsetY;
        double d4 = icon.func_94214_a(d0);
        double d5 = icon.func_94214_a(d1);
        double d6 = icon.func_94207_b(d2);
        double d7 = icon.func_94207_b(d3);
        double d8 = 0.0;
        double d9 = 0.0;
        switch (direction) {
            case 0: {
                d8 = 8.0 - (double)(offsetX / 2);
                d9 = 18.0 - (double)offsetX;
                break;
            }
            case 1: {
                d8 = -2.0;
                d9 = 8.0 - (double)(offsetX / 2);
                break;
            }
            case 2: {
                d8 = 8.0 - (double)(offsetX / 2);
                d9 = -2.0;
                break;
            }
            case 3: {
                d8 = 18.0 - (double)offsetX;
                d9 = 8.0 - (double)(offsetX / 2);
            }
        }
        double d10 = (double)x + d8 / 16.0;
        double d11 = (double)x + (d8 + (double)offsetX) / 16.0;
        double d12 = (double)y + (12.0 - (double)offsetY) / 16.0;
        double d13 = (double)y + 0.75;
        double d14 = (double)z + d9 / 16.0;
        double d15 = (double)z + (d9 + (double)offsetX) / 16.0;
        tessellator.func_78374_a(d10, d12, d14, d4, d7);
        tessellator.func_78374_a(d10, d12, d15, d5, d7);
        tessellator.func_78374_a(d10, d13, d15, d5, d6);
        tessellator.func_78374_a(d10, d13, d14, d4, d6);
        tessellator.func_78374_a(d11, d12, d15, d4, d7);
        tessellator.func_78374_a(d11, d12, d14, d5, d7);
        tessellator.func_78374_a(d11, d13, d14, d5, d6);
        tessellator.func_78374_a(d11, d13, d15, d4, d6);
        tessellator.func_78374_a(d11, d12, d14, d4, d7);
        tessellator.func_78374_a(d10, d12, d14, d5, d7);
        tessellator.func_78374_a(d10, d13, d14, d5, d6);
        tessellator.func_78374_a(d11, d13, d14, d4, d6);
        tessellator.func_78374_a(d10, d12, d15, d4, d7);
        tessellator.func_78374_a(d11, d12, d15, d5, d7);
        tessellator.func_78374_a(d11, d13, d15, d5, d6);
        tessellator.func_78374_a(d10, d13, d15, d4, d6);
        int i2 = offsetX;
        if (sizer >= 2) {
            i2 = offsetX - 1;
        }
        d4 = icon.func_94209_e();
        d5 = icon.func_94214_a((double)i2);
        d6 = icon.func_94206_g();
        d7 = icon.func_94207_b((double)i2);
        tessellator.func_78374_a(d10, d13, d15, d4, d7);
        tessellator.func_78374_a(d11, d13, d15, d5, d7);
        tessellator.func_78374_a(d11, d13, d14, d5, d6);
        tessellator.func_78374_a(d10, d13, d14, d4, d6);
        tessellator.func_78374_a(d10, d12, d14, d4, d6);
        tessellator.func_78374_a(d11, d12, d14, d5, d6);
        tessellator.func_78374_a(d11, d12, d15, d5, d7);
        tessellator.func_78374_a(d10, d12, d15, d4, d7);
        d4 = icon.func_94214_a(12.0);
        d5 = icon.func_94212_f();
        d6 = icon.func_94206_g();
        d7 = icon.func_94207_b(4.0);
        d8 = 8.0;
        d9 = 0.0;
        switch (direction) {
            case 0: {
                d8 = 8.0;
                d9 = 12.0;
                double d16 = d4;
                d4 = d5;
                d5 = d16;
                break;
            }
            case 1: {
                d8 = 0.0;
                d9 = 8.0;
                break;
            }
            case 2: {
                d8 = 8.0;
                d9 = 0.0;
                break;
            }
            case 3: {
                d8 = 12.0;
                d9 = 8.0;
                double d16 = d4;
                d4 = d5;
                d5 = d16;
            }
        }
        d10 = (double)x + d8 / 16.0;
        d11 = (double)x + (d8 + 4.0) / 16.0;
        d12 = (double)y + 0.75;
        d13 = (double)y + 1.0;
        d14 = (double)z + d9 / 16.0;
        d15 = (double)z + (d9 + 4.0) / 16.0;
        return true;
    }

    boolean renderSmall(RenderBlocks renderer, IBlockAccess iblockaccess, int x, int y, int z, Block block) {
        renderer.func_83020_a((double)0.325f, 0.0, (double)0.325f, (double)0.675f, 0.5, (double)0.675f);
        renderer.func_78570_q(block, x, y, z);
        return true;
    }
}

