/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class NetherBerryBushItem
extends ItemBlock {
    public static final String[] blockType = new String[]{"blight", "dusk", "sky", "sting", "blight", "dusk", "sky", "sting", "blight", "dusk", "sky", "sting", "blight", "dusk", "sky", "sting"};

    public NetherBerryBushItem(int i) {
        super(i);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int meta) {
        return meta % 4;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (side != 1) {
            return false;
        }
        if (player.canPlayerEdit(x, y, z, side, stack) && player.canPlayerEdit(x, y + 1, z, side, stack)) {
            Block block = Block.blocksList[world.getBlockId(x, y, z)];
            if (block != null && (block.canSustainPlant(world, x, y, z, ForgeDirection.UP, (IPlantable)NContent.netherBerryBush) || block == Block.netherrack) && world.isAirBlock(x, y + 1, z)) {
                world.setBlock(x, y + 1, z, NContent.netherBerryBush.blockID, stack.getItemDamage() % 4, 3);
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
                if (!world.isRemote) {
                    world.playAuxSFX(2001, x, y, z, NContent.netherBerryBush.blockID);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "block.bush.berry." + blockType[itemstack.getItemDamage()];
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("A little bit evil");
        switch (stack.getItemDamage() % 4) {
            case 0: {
                list.add("Killer healing");
                break;
            }
            case 1: {
                list.add("Visible night");
                break;
            }
            case 2: {
                list.add("Slow dive");
                break;
            }
            case 3: {
                list.add("Hit like a truck");
            }
        }
    }
}

