/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class BoneBag
extends Item {
    String textureName;

    public BoneBag(int id, String texture) {
        super(id);
        this.textureName = texture;
        this.setCreativeTab(NaturaTab.tab);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (side != 1) {
            return false;
        }
        boolean planted = false;
        for (int posX = x - 1; posX <= x + 1; ++posX) {
            for (int posZ = z - 1; posZ <= z + 1; ++posZ) {
                if (!player.canPlayerEdit(posX, y, posZ, side, stack) || !player.canPlayerEdit(posX, y + 1, posZ, side, stack) || !BoneBag.applyBonemeal(stack, world, posX, y, posZ, player)) continue;
                planted = true;
                if (world.isRemote) continue;
                world.playAuxSFX(2005, posX, y, posZ, 0);
            }
        }
        if (planted) {
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            if (stack.stackSize < 1) {
                player.destroyCurrentEquippedItem();
            }
        }
        return planted;
    }

    public static boolean applyBonemeal(ItemStack par0ItemStack, World par1World, int par2, int par3, int par4, EntityPlayer player) {
        int l = par1World.getBlockId(par2, par3, par4);
        BonemealEvent event = new BonemealEvent(player, par1World, l, par2, par3, par4);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (l == Block.sapling.blockID) {
            if (!par1World.isRemote && (double)par1World.rand.nextFloat() < 0.45) {
                ((BlockSapling)Block.sapling).markOrGrowMarked(par1World, par2, par3, par4, par1World.rand);
            }
            return true;
        }
        if (l != Block.mushroomBrown.blockID && l != Block.mushroomRed.blockID) {
            if (l != Block.melonStem.blockID && l != Block.pumpkinStem.blockID) {
                if (l > 0 && Block.blocksList[l] instanceof BlockCrops) {
                    if (par1World.getBlockMetadata(par2, par3, par4) == 7) {
                        return false;
                    }
                    if (!par1World.isRemote) {
                        ((BlockCrops)Block.blocksList[l]).fertilize(par1World, par2, par3, par4);
                    }
                    return true;
                }
                if (l == Block.cocoaPlant.blockID) {
                    int i1 = par1World.getBlockMetadata(par2, par3, par4);
                    int j1 = BlockDirectional.getDirection((int)i1);
                    int k1 = BlockCocoa.func_72219_c((int)i1);
                    if (k1 >= 2) {
                        return false;
                    }
                    if (!par1World.isRemote) {
                        par1World.setBlockMetadataWithNotify(par2, par3, par4, ++k1 << 2 | j1, 2);
                    }
                    return true;
                }
                if (l != Block.grass.blockID) {
                    return false;
                }
                if (!par1World.isRemote) {
                    --par0ItemStack.stackSize;
                    block0: for (int i1 = 0; i1 < 128; ++i1) {
                        int j1 = par2;
                        int k1 = par3 + 1;
                        int l1 = par4;
                        for (int i2 = 0; i2 < i1 / 16; ++i2) {
                            if (par1World.getBlockId(j1 += itemRand.nextInt(3) - 1, (k1 += (itemRand.nextInt(3) - 1) * itemRand.nextInt(3) / 2) - 1, l1 += itemRand.nextInt(3) - 1) != Block.grass.blockID || par1World.isBlockNormalCube(j1, k1, l1)) continue block0;
                        }
                        if (par1World.getBlockId(j1, k1, l1) != 0) continue;
                        if (itemRand.nextInt(10) != 0) {
                            if (!Block.tallGrass.canBlockStay(par1World, j1, k1, l1)) continue;
                            par1World.setBlock(j1, k1, l1, Block.tallGrass.blockID, 1, 3);
                            continue;
                        }
                        ForgeHooks.plantGrass((World)par1World, (int)j1, (int)k1, (int)l1);
                    }
                }
                return true;
            }
            if (par1World.getBlockMetadata(par2, par3, par4) == 7) {
                return false;
            }
            if (!par1World.isRemote) {
                ((BlockStem)Block.blocksList[l]).fertilizeStem(par1World, par2, par3, par4);
            }
            return true;
        }
        if (!par1World.isRemote && (double)par1World.rand.nextFloat() < 0.4) {
            ((BlockMushroom)Block.blocksList[l]).fertilizeMushroom(par1World, par2, par3, par4, par1World.rand);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("natura:seedbag_" + this.textureName);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("Grows plants in a 3x3 area");
    }
}

