/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks;

import mods.natura.Natura;
import mods.natura.blocks.NBlock;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CloudBlock
extends NBlock {
    public CloudBlock(int id) {
        super(id, Natura.cloud, 0.3f, new String[]{"cloud_white", "cloud_gray", "cloud_dark", "cloud_sulfur"});
        this.setStepSound(Block.soundClothFootstep);
        this.setUnlocalizedName("cloud");
        this.setCreativeTab(NaturaTab.tab);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        EntityArrow entityarrow;
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 3 && entity instanceof EntityArrow && !world.isRemote && (entityarrow = (EntityArrow)entity).isBurning()) {
            this.explode(world, x, y, z, 1, (EntityLivingBase)(entityarrow.shootingEntity instanceof EntityLiving ? (EntityLiving)entityarrow.shootingEntity : null));
            world.setBlockToAir(x, y, z);
            return;
        }
        if (entity.motionY < 0.0) {
            entity.motionY *= 0.005;
        }
        entity.fallDistance = 0.0f;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 3 && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().itemID == Item.flintAndSteel.itemID) {
            world.setBlockToAir(x, y, z);
            this.explode(world, x, y, z, 1, (EntityLivingBase)player);
            return true;
        }
        return super.onBlockActivated(world, x, y, z, player, par6, par7, par8, par9);
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion par5Explosion) {
    }

    public void explode(World world, int x, int y, int z, int size, EntityLivingBase living) {
        world.createExplosion((Entity)living, (double)x, (double)y, (double)z, (float)size, true);
    }

    public boolean canDropFromExplosion(Explosion par1Explosion) {
        return false;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        int blockID = iblockaccess.getBlockId(x, y, z);
        if (blockID == NContent.cloud.blockID) {
            return false;
        }
        return super.shouldSideBeRendered(iblockaccess, x, y, z, side);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int damageDropped(int meta) {
        return meta;
    }

    public boolean isBlockSolid(IBlockAccess iblockaccess, int x, int y, int z, int l) {
        int blockID = iblockaccess.getBlockId(x, y, z);
        if (blockID == NContent.cloud.blockID) {
            return false;
        }
        return super.isBlockSolid(iblockaccess, x, y, z, l);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (world.getBlockId(x, y - 1, z) == NContent.cloud.blockID) {
            return null;
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 0.0625), (double)((double)z + 1.0));
    }
}

