/*
 * Decompiled with CFR 0.152.
 */
package appeng.api;

import appeng.api.DimentionalCoord;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IGridTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileRef<T>
extends WorldCoord {
    private World w;
    boolean wasGrid;

    public TileRef(TileEntity gte) {
        super(gte.xCoord, gte.yCoord, gte.zCoord);
        TileEntity te = gte;
        this.wasGrid = te instanceof IGridTileEntity;
        this.w = te.worldObj;
        if (te.worldObj == null) {
            throw new RuntimeException("Tile has no world.");
        }
    }

    public T getTile() throws AppEngTileMissingException {
        TileEntity te;
        if (this.w.getChunkProvider().chunkExists(this.x >> 4, this.z >> 4) && (te = this.w.getBlockTileEntity(this.x, this.y, this.z)) != null) {
            try {
                TileEntity ttt = te;
                return (T)ttt;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.wasGrid) {
            MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent(null, this.w, this));
        }
        throw new AppEngTileMissingException(this.w, this.x, this.y, this.z);
    }

    public DimentionalCoord getCoord() {
        return new DimentionalCoord(this.w, this.x, this.y, this.z);
    }
}

