/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class DarkwoodGen
extends WorldGenerator {
    private final int minTreeHeight;
    private final int metaWood;
    private final boolean seekGround;

    public DarkwoodGen(boolean par1) {
        this(par1, 4, 0);
    }

    public DarkwoodGen(boolean par1, int par2, int par3) {
        super(par1);
        this.minTreeHeight = par2;
        this.metaWood = par3;
        this.seekGround = !par1;
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = y;
        do {
            int underID;
            if ((underID = world.func_72798_a(x, --height, z)) != Block.field_72012_bb.field_71990_ca && underID != Block.field_72013_bc.field_71990_ca && underID != NContent.taintedSoil.field_71990_ca && height >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }

    public boolean func_76484_a(World world, Random random, int xPos, int yPos, int zPos) {
        int treeHeight = random.nextInt(3) + this.minTreeHeight;
        if (treeHeight < 4) {
            treeHeight = 4;
        }
        boolean flag = true;
        if (this.seekGround) {
            yPos = this.findGround(world, xPos, yPos, zPos);
        }
        if (yPos >= 1 && yPos + treeHeight + 1 <= 256) {
            boolean isSoil;
            int k1;
            int j1;
            int b0;
            int i1;
            for (i1 = yPos; i1 <= yPos + 1 + treeHeight; ++i1) {
                b0 = 1;
                if (i1 == yPos) {
                    b0 = 0;
                }
                if (i1 >= yPos + 1 + treeHeight - 2) {
                    b0 = 2;
                }
                for (int l1 = xPos - b0; l1 <= xPos + b0 && flag; ++l1) {
                    for (j1 = zPos - b0; j1 <= zPos + b0 && flag; ++j1) {
                        if (i1 >= 0 && i1 < 256) {
                            k1 = world.func_72798_a(l1, i1, j1);
                            Block block = Block.field_71973_m[k1];
                            if (k1 == 0 || block.isLeaves(world, l1, i1, j1) || k1 == Block.field_72012_bb.field_71990_ca || k1 == Block.field_72013_bc.field_71990_ca || k1 == NContent.taintedSoil.field_71990_ca || block.isWood(world, l1, i1, j1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            i1 = world.func_72798_a(xPos, yPos - 1, zPos);
            Block soil = Block.field_71973_m[i1];
            boolean bl = isSoil = soil != null && soil.canSustainPlant(world, xPos, yPos - 1, zPos, ForgeDirection.UP, (IPlantable)NContent.floraSapling) || soil == Block.field_72012_bb;
            if (isSoil && yPos < 256 - treeHeight - 1) {
                soil.onPlantGrow(world, xPos, yPos - 1, zPos, xPos, yPos, zPos);
                b0 = 3;
                int b1 = 0;
                for (j1 = yPos - b0 + treeHeight; j1 <= yPos + treeHeight; ++j1) {
                    k1 = j1 - (yPos + treeHeight);
                    int i2 = b1 + 1 - k1 / 2;
                    for (int j2 = xPos - i2; j2 <= xPos + i2; ++j2) {
                        int k2 = j2 - xPos;
                        for (int l2 = zPos - i2; l2 <= zPos + i2; ++l2) {
                            int j3;
                            Block block;
                            int i3 = l2 - zPos;
                            if (Math.abs(k2) == i2 && Math.abs(i3) == i2 && (random.nextInt(2) == 0 || k1 == 0) || (block = Block.field_71973_m[j3 = world.func_72798_a(j2, j1, l2)]) != null && !block.canBeReplacedByLeaves(world, j2, j1, l2)) continue;
                            this.func_76485_a(world, j2, j1, l2, NContent.darkLeaves.field_71990_ca, random.nextInt(25) == 0 ? 2 : (random.nextInt(15) == 0 ? 1 : 0));
                        }
                    }
                }
                for (j1 = 0; j1 < treeHeight; ++j1) {
                    k1 = world.func_72798_a(xPos, yPos + j1, zPos);
                    Block block = Block.field_71973_m[k1];
                    if (k1 != 0 && block != null && !block.isLeaves(world, xPos, yPos + j1, zPos)) continue;
                    this.func_76485_a(world, xPos, yPos + j1, zPos, NContent.darkTree.field_71990_ca, this.metaWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

