/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import tconstruct.library.component.LogicComponent;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.CoordTupleSort;
import tconstruct.library.util.IFacingLogic;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;

public class TankLayerScan
extends LogicComponent {
    protected TileEntity master;
    protected IMasterLogic imaster;
    protected Block[] scanBlocks;
    protected CoordTuple masterCoord;
    protected boolean completeStructure;
    protected int bricks = 0;
    protected int airBlocks = 0;
    protected HashSet<CoordTuple> layerBlockCoords = new HashSet();
    protected HashSet<CoordTuple> layerAirCoords = new HashSet();
    public ArrayList<CoordTuple> blockCoords = new ArrayList();
    public ArrayList<CoordTuple> airCoords = new ArrayList();
    protected ArrayList<int[]> validAirCoords = new ArrayList();
    protected CoordTuple returnStone;
    private boolean debug = false;

    public TankLayerScan(TileEntity te, Block ... ids) {
        assert (te instanceof IMasterLogic) : "TileEntity must be an instance of IMasterLogic";
        this.master = te;
        this.imaster = (IMasterLogic)te;
        this.scanBlocks = ids;
        this.masterCoord = new CoordTuple(te.field_70329_l, te.field_70330_m, te.field_70327_n);
        this.validAirCoords.add(new int[]{1, 0});
        this.validAirCoords.add(new int[]{-1, 0});
        this.validAirCoords.add(new int[]{0, 1});
        this.validAirCoords.add(new int[]{0, -1});
    }

    public void checkValidStructure() {
        this.bricks = 0;
        this.airBlocks = 0;
        this.blockCoords.clear();
        this.airCoords.clear();
        boolean validAir = false;
        byte dir = this.getDirection();
        switch (this.getDirection()) {
            case 2: 
            case 3: {
                if (!this.checkAir(this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n - 1) || !this.checkAir(this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n + 1)) break;
                validAir = true;
                break;
            }
            case 4: 
            case 5: {
                if (!this.checkAir(this.master.field_70329_l - 1, this.master.field_70330_m, this.master.field_70327_n) || !this.checkAir(this.master.field_70329_l + 1, this.master.field_70330_m, this.master.field_70327_n)) break;
                validAir = true;
            }
        }
        boolean validBlocks = false;
        int xPos = 0;
        int zPos = 0;
        if (dir == 2) {
            xPos = 1;
        }
        if (dir == 3) {
            xPos = -1;
        }
        if (dir == 4) {
            zPos = -1;
        }
        if (dir == 5) {
            zPos = 1;
        }
        this.returnStone = new CoordTuple(this.master.field_70329_l - xPos, this.master.field_70330_m, this.master.field_70327_n - zPos);
        if (this.initialRecurseLayer(this.master.field_70329_l + xPos, this.master.field_70330_m, this.master.field_70327_n + zPos)) {
            xPos = 0;
            zPos = 0;
            switch (dir) {
                case 2: {
                    zPos = 1;
                    break;
                }
                case 3: {
                    zPos = -1;
                    break;
                }
                case 4: {
                    xPos = 1;
                    break;
                }
                case 5: {
                    xPos = -1;
                }
            }
            if (!this.world.field_72995_K && this.debug) {
                System.out.println("Bricks in recursion: " + this.blockCoords.size());
            }
            this.blockCoords.clear();
            this.bricks = 0;
            boolean sealed = this.floodTest(this.master.field_70329_l + xPos, this.master.field_70330_m, this.master.field_70327_n + zPos);
            if (!this.world.field_72995_K && this.debug) {
                System.out.println("Air in ring: " + this.airBlocks);
                System.out.println("Bricks in ring: " + this.bricks);
            }
            if (sealed) {
                this.blockCoords.add(new CoordTuple(this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n));
                this.layerAirCoords = new HashSet<CoordTuple>(this.airCoords);
                this.layerBlockCoords = new HashSet<CoordTuple>(this.blockCoords);
                int lowY = this.recurseStructureDown(this.master.field_70330_m - 1);
                if (lowY != -1) {
                    this.completeStructure = true;
                    this.recurseStructureUp(this.master.field_70330_m + 1);
                    this.finalizeStructure();
                    if (!this.world.field_72995_K && this.debug) {
                        System.out.println("Air in structure: " + this.airCoords.size());
                        System.out.println("Bricks in structure: " + this.blockCoords.size());
                    }
                }
            }
        }
    }

    protected void finalizeStructure() {
        Collections.sort(this.airCoords, new CoordTupleSort());
        for (CoordTuple coord : this.blockCoords) {
            TileEntity servant = this.world.func_72796_p(coord.x, coord.y, coord.z);
            if (!(servant instanceof IServantLogic)) continue;
            ((IServantLogic)servant).verifyMaster(this.imaster, this.world, this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n);
        }
    }

    public boolean isComplete() {
        return this.completeStructure;
    }

    public int getAirLayerSize() {
        return this.layerAirCoords.size();
    }

    public int getAirSize() {
        return this.airBlocks;
    }

    public CoordTuple getAirByIndex(int index) {
        if (index >= this.airCoords.size() || index < 0) {
            return null;
        }
        return this.airCoords.get(index);
    }

    private byte getDirection() {
        if (this.master instanceof IFacingLogic) {
            return ((IFacingLogic)this.master).getRenderDirection();
        }
        return 0;
    }

    protected boolean checkAir(int x, int y, int z) {
        Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
        return block == null || block.isAirBlock(this.world, x, y, z);
    }

    protected boolean checkServant(int x, int y, int z) {
        Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
        if (block == null || block.isAirBlock(this.world, x, y, z) || !this.isValidBlock(x, y, z)) {
            return false;
        }
        if (!block.hasTileEntity(this.world.func_72805_g(x, y, z))) {
            return false;
        }
        TileEntity be = this.world.func_72796_p(x, y, z);
        if (be instanceof IServantLogic) {
            return ((IServantLogic)be).setPotentialMaster(this.imaster, this.world, x, y, z);
        }
        return false;
    }

    protected boolean initialRecurseLayer(int x, int y, int z) {
        if (this.bricks > 4000) {
            return false;
        }
        CoordTuple keystone = new CoordTuple(x, y, z);
        if (keystone.equals(this.returnStone)) {
            return true;
        }
        for (int xPos = -1; xPos <= 1; ++xPos) {
            for (int zPos = -1; zPos <= 1; ++zPos) {
                CoordTuple coord = new CoordTuple(x + xPos, y, z + zPos);
                if (this.blockCoords.contains(coord) || !this.isValidBlock(x + xPos, y, z + zPos)) continue;
                ++this.bricks;
                this.blockCoords.add(coord);
                return this.initialRecurseLayer(x + xPos, y, z + zPos);
            }
        }
        return false;
    }

    protected boolean isValidBlock(int x, int y, int z) {
        Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
        if (block != null) {
            for (int i = 0; i < this.scanBlocks.length; ++i) {
                if (block != this.scanBlocks[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean floodTest(int x, int y, int z) {
        if (this.airBlocks > 4000) {
            return false;
        }
        for (int[] offset : this.validAirCoords) {
            CoordTuple coord = new CoordTuple(x + offset[0], y, z + offset[1]);
            if (this.airCoords.contains(coord)) continue;
            if (this.checkAir(x + offset[0], y, z + offset[1])) {
                this.addAirBlock(coord.x, y, coord.z);
                this.floodTest(x + offset[0], y, z + offset[1]);
                continue;
            }
            if (this.blockCoords.contains(coord) || !this.checkServant(x + offset[0], y, z + offset[1])) continue;
            ++this.bricks;
            this.blockCoords.add(coord);
        }
        return true;
    }

    public int recurseStructureDown(int y) {
        Iterator<CoordTuple> i = this.layerAirCoords.iterator();
        if (i.hasNext()) {
            CoordTuple coord2 = i.next();
            if (this.checkAir(coord2.x, y, coord2.z)) {
                boolean valid = true;
                this.addAirBlock(coord2.x, y, coord2.z);
                while (i.hasNext()) {
                    coord2 = i.next();
                    if (this.checkAir(coord2.x, y, coord2.z)) {
                        this.addAirBlock(coord2.x, y, coord2.z);
                        continue;
                    }
                    valid = false;
                    break;
                }
                for (CoordTuple coord2 : this.layerBlockCoords) {
                    if (this.checkServant(coord2.x, y, coord2.z)) {
                        this.blockCoords.add(new CoordTuple(coord2.x, y, coord2.z));
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (valid) {
                    return this.recurseStructureDown(y - 1);
                }
            } else if (this.checkServant(coord2.x, y, coord2.z)) {
                boolean valid = true;
                while (i.hasNext()) {
                    coord2 = i.next();
                    if (this.checkServant(coord2.x, y, coord2.z)) {
                        this.blockCoords.add(new CoordTuple(coord2.x, y, coord2.z));
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (valid) {
                    return y + 1;
                }
            }
        }
        return -1;
    }

    public void recurseStructureUp(int y) {
        Iterator<CoordTuple> i = this.layerBlockCoords.iterator();
        if (i.hasNext()) {
            CoordTuple coord2 = i.next();
            if (this.checkServant(coord2.x, y, coord2.z)) {
                boolean valid = true;
                while (i.hasNext()) {
                    coord2 = i.next();
                    if (this.checkServant(coord2.x, y, coord2.z)) {
                        this.blockCoords.add(new CoordTuple(coord2.x, y, coord2.z));
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (valid) {
                    for (CoordTuple coord2 : this.layerAirCoords) {
                        if (this.checkAir(coord2.x, y, coord2.z)) {
                            this.addAirBlock(coord2.x, y, coord2.z);
                            continue;
                        }
                        valid = false;
                        break;
                    }
                }
                if (valid) {
                    this.recurseStructureUp(y + 1);
                }
            }
        }
    }

    protected void addAirBlock(int x, int y, int z) {
        ++this.airBlocks;
        this.airCoords.add(new CoordTuple(x, y, z));
    }

    public void cleanup() {
        for (CoordTuple coord : this.blockCoords) {
            TileEntity te = this.world.func_72796_p(coord.x, coord.y, coord.z);
            if (te == null || !(te instanceof IServantLogic)) continue;
            ((IServantLogic)te).invalidateMaster(this.imaster, this.world, this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n);
        }
    }

    @Override
    public void readNetworkNBT(NBTTagCompound tags) {
        NBTTagList air;
        NBTTagList blocks;
        this.completeStructure = tags.func_74767_n("Complete");
        NBTTagList layerAir = tags.func_74761_m("AirLayer");
        if (layerAir != null) {
            this.layerAirCoords.clear();
            for (int i = 0; i < layerAir.func_74745_c(); ++i) {
                NBTTagIntArray tag = (NBTTagIntArray)layerAir.func_74743_b(i);
                int[] coord = tag.field_74749_a;
                this.layerAirCoords.add(new CoordTuple(coord[0], coord[1], coord[2]));
            }
        }
        if ((blocks = tags.func_74761_m("AirLayer")) != null) {
            this.blockCoords.clear();
            for (int i = 0; i < blocks.func_74745_c(); ++i) {
                NBTTagIntArray tag = (NBTTagIntArray)blocks.func_74743_b(i);
                int[] coord = tag.field_74749_a;
                this.blockCoords.add(new CoordTuple(coord[0], coord[1], coord[2]));
            }
        }
        if ((air = tags.func_74761_m("AirLayer")) != null) {
            this.airCoords.clear();
            for (int i = 0; i < air.func_74745_c(); ++i) {
                NBTTagIntArray tag = (NBTTagIntArray)air.func_74743_b(i);
                int[] coord = tag.field_74749_a;
                this.airCoords.add(new CoordTuple(coord[0], coord[1], coord[2]));
            }
        }
    }

    @Override
    public void writeNetworkNBT(NBTTagCompound tags) {
        tags.func_74757_a("Complete", this.completeStructure);
        NBTTagList layerAir = new NBTTagList();
        for (CoordTuple coord : this.layerAirCoords) {
            layerAir.func_74742_a((NBTBase)new NBTTagIntArray("coord", new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("AirLayer", (NBTBase)layerAir);
        NBTTagList blocks = new NBTTagList();
        for (CoordTuple coord : this.blockCoords) {
            blocks.func_74742_a((NBTBase)new NBTTagIntArray("coord", new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("Blocks", (NBTBase)blocks);
        NBTTagList air = new NBTTagList();
        for (CoordTuple coord : this.airCoords) {
            air.func_74742_a((NBTBase)new NBTTagIntArray("coord", new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("Air", (NBTBase)air);
    }
}

