/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import java.util.Random;
import mods.natura.blocks.crops.CropBlock;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class HerbBlock
extends CropBlock {
    protected HerbBlock(int id) {
        super(id);
        this.setTickRandomly(true);
        float var3 = 0.5f;
        this.setBlockBounds(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.25f, 0.5f + var3);
        this.setCreativeTab(null);
        this.setHardness(0.0f);
        this.setStepSound(soundGrassFootstep);
        this.disableStats();
        this.setCreativeTab(NaturaTab.tab);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        float grow;
        int meta;
        this.checkFlowerChange(world, x, y, z);
        int light = world.getBlockLightValue(x, y, z);
        if (light >= 8 && (meta = world.getBlockMetadata(x, y, z)) % 4 != 3 && random.nextInt((int)(50.0f / (grow = this.getGrowthRate(world, x, y, z, meta, light))) + 1) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, ++meta, 2);
        }
    }

    @Override
    public void fertilize(World world, int x, int y, int z) {
    }

    @Override
    boolean requiresSun(int meta) {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }

    @Override
    protected int getCropItem(int meta) {
        return NContent.plantItem.itemID;
    }

    @Override
    protected int getSeedItem(int meta) {
        return NContent.seeds.itemID;
    }

    @Override
    public int damageDropped(int meta) {
        return 0;
    }

    @Override
    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z);
    }

    @Override
    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    @Override
    public boolean canBlockStay(World par1World, int x, int y, int z) {
        Block soil = blocksList[par1World.getBlockId(x, y - 1, z)];
        return soil != null && soil.blockMaterial == Material.rock;
    }
}

