/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.util.IPattern;

public class PatternBuilder {
    public static PatternBuilder instance = new PatternBuilder();
    public List<ItemKey> materials = new ArrayList<ItemKey>();
    public HashMap materialSets = new HashMap();
    public List<IPattern> toolPatterns = new ArrayList<IPattern>();

    public void registerMaterial(ItemStack material, int value, String key) {
        this.materials.add(new ItemKey(material.func_77973_b(), material.func_77960_j(), value, key));
    }

    public void registerMaterialSet(String key, ItemStack shard, ItemStack rod, int materialID) {
        this.materialSets.put(key, new MaterialSet(shard, rod, materialID));
        this.materials.add(new ItemKey(shard.func_77973_b(), shard.func_77960_j(), 1, key));
    }

    public void registerFullMaterial(ItemStack material, int value, String key, ItemStack shard, ItemStack rod, int materialID) {
        this.materials.add(new ItemKey(material.func_77973_b(), material.func_77960_j(), value, key));
        this.materials.add(new ItemKey(shard.func_77973_b(), shard.func_77960_j(), 1, key));
        this.materialSets.put(key, new MaterialSet(shard, rod, materialID));
    }

    public void addToolPattern(IPattern item) {
        this.toolPatterns.add(item);
    }

    public ItemStack[] getToolPart(ItemStack material, ItemStack pattern, ItemStack otherPattern) {
        if (material != null && pattern != null) {
            MaterialSet mat;
            ItemStack toolPart;
            PartBuilderEvent.NormalPart event = new PartBuilderEvent.NormalPart(material, pattern, otherPattern);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.ALLOW) {
                return event.getResultStacks();
            }
            if (event.getResult() == Event.Result.DENY) {
                return null;
            }
            ItemKey key = this.getItemKey(material);
            if (key != null && (toolPart = this.getMatchingPattern(pattern, material, mat = (MaterialSet)this.materialSets.get(key.key))) != null) {
                int totalMaterial = key.value * material.field_77994_a;
                int patternValue = ((IPattern)pattern.func_77973_b()).getPatternCost(pattern);
                if (totalMaterial < patternValue) {
                    return null;
                }
                if (patternValue == key.value) {
                    return new ItemStack[]{toolPart, null};
                }
                if (patternValue % 2 == 1) {
                    return new ItemStack[]{toolPart, mat.shard.func_77946_l()};
                }
                return new ItemStack[]{toolPart, null};
            }
        }
        return null;
    }

    public int getPartID(ItemStack material) {
        ItemKey key;
        if (material != null && (key = this.getItemKey(material)) != null) {
            MaterialSet set = (MaterialSet)this.materialSets.get(key.key);
            return set.materialID;
        }
        return Short.MAX_VALUE;
    }

    public int getPartValue(ItemStack material) {
        if (material != null) {
            ItemKey key = this.getItemKey(material);
            if (key != null) {
                return key.value;
            }
            for (CustomMaterial mat : TConstructRegistry.customMaterials) {
                if (!material.func_77969_a(mat.input)) continue;
                return mat.value;
            }
        }
        return 0;
    }

    public ItemKey getItemKey(ItemStack material) {
        Item mat = material.func_77973_b();
        int damage = material.func_77960_j();
        for (ItemKey ik : this.materials) {
            if (mat != ik.item || ik.damage != Short.MAX_VALUE && damage != ik.damage) continue;
            return ik;
        }
        return null;
    }

    public ItemStack getMatchingPattern(ItemStack stack, ItemStack input, MaterialSet set) {
        Item item = stack.func_77973_b();
        for (IPattern pattern : this.toolPatterns) {
            if (pattern != item) continue;
            return pattern.getPatternOutput(stack, input, set);
        }
        return null;
    }

    public ItemStack getShardFromSet(String materialset) {
        MaterialSet set = (MaterialSet)this.materialSets.get(materialset);
        if (set != null) {
            return set.shard.func_77946_l();
        }
        return null;
    }

    public ItemStack getRodFromSet(String materialset) {
        MaterialSet set = (MaterialSet)this.materialSets.get(materialset);
        if (set != null) {
            return set.rod.func_77946_l();
        }
        return null;
    }

    public void registerMaterial(Block material, int value, String key) {
        this.registerMaterial(new ItemStack(material, 1, Short.MAX_VALUE), value, key);
    }

    public void registerMaterial(Item material, int value, String key) {
        this.registerMaterial(new ItemStack(material, 1, Short.MAX_VALUE), value, key);
    }

    public void registerFullMaterial(Block material, int value, String key, ItemStack shard, ItemStack rod, int materialID) {
        this.registerFullMaterial(new ItemStack(material, 1, Short.MAX_VALUE), value, key, shard, rod, materialID);
    }

    public void registerFullMaterial(Item material, int value, String key, ItemStack shard, ItemStack rod, int materialID) {
        this.registerFullMaterial(new ItemStack(material, 1, Short.MAX_VALUE), value, key, shard, rod, materialID);
    }

    public class MaterialSet {
        public final ItemStack shard;
        public final ItemStack rod;
        public final int materialID;

        public MaterialSet(ItemStack s, ItemStack r, int id) {
            this.shard = s;
            this.rod = r;
            this.materialID = id;
        }
    }

    public class ItemKey {
        public final Item item;
        public final int damage;
        public final int value;
        public final String key;

        public ItemKey(Item i, int d, int v, String s) {
            this.item = i;
            this.damage = d;
            this.value = v;
            this.key = s;
        }
    }
}

