/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class NSpecialFood
extends ItemFood {
    int[] hunger;
    float[] saturation;
    String[] unlocalizedNames;
    String[] iconNames;
    Icon[] icons;

    public NSpecialFood(int id, int[] hunger, float[] saturation, String[] textureNames, String[] iconNames) {
        super(id, 0, 0.0f, false);
        this.hunger = hunger;
        this.saturation = saturation;
        this.unlocalizedNames = textureNames;
        this.iconNames = iconNames;
        this.setHasSubtypes(true);
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        --stack.stackSize;
        int damage = stack.getItemDamage();
        player.getFoodStats().addStats(this.hunger[damage], this.saturation[damage]);
        world.playSoundAtEntity((Entity)player, "random.burp", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
        this.onFoodEaten(stack, world, player);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.icons = new Icon[this.iconNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.iconNames[i]);
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        int arr = MathHelper.clamp_int((int)stack.getItemDamage(), (int)0, (int)this.unlocalizedNames.length);
        return this.getUnlocalizedName() + "." + this.unlocalizedNames[arr];
    }

    public void getSubItems(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < this.unlocalizedNames.length; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }
}

