/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.component;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.library.component.LogicComponent;
import tconstruct.library.crafting.Smeltery;

public class MultiFluidTank
extends LogicComponent
implements IFluidTank {
    public ArrayList<FluidStack> fluidlist = new ArrayList();
    protected int maxLiquid;
    protected int currentLiquid;

    public MultiFluidTank() {
    }

    public MultiFluidTank(int max) {
        this.maxLiquid = max;
    }

    public void setCapacity(int i) {
        this.maxLiquid = i;
    }

    public int getCapacity() {
        return this.maxLiquid;
    }

    public int getFluidAmount() {
        return this.currentLiquid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidlist.size() == 0) {
            return null;
        }
        FluidStack liquid = this.fluidlist.get(0);
        if (liquid != null) {
            if (liquid.amount - maxDrain <= 0) {
                FluidStack liq = liquid.copy();
                if (doDrain) {
                    this.fluidlist.remove(liquid);
                    this.currentLiquid = 0;
                }
                return liq;
            }
            if (doDrain) {
                liquid.amount -= maxDrain;
                this.currentLiquid -= maxDrain;
            }
            return new FluidStack(liquid.fluidID, maxDrain, liquid.tag);
        }
        return new FluidStack(0, 0);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && this.currentLiquid < this.maxLiquid) {
            if (resource.amount + this.currentLiquid > this.maxLiquid) {
                resource.amount = this.maxLiquid - this.currentLiquid;
            }
            int amount = resource.amount;
            if (doFill && this.addFluidToTank(resource, false)) {
                ArrayList alloys = Smeltery.mixMetals(this.fluidlist);
                for (int al = 0; al < alloys.size(); ++al) {
                    FluidStack liquid = (FluidStack)alloys.get(al);
                    this.addFluidToTank(liquid, true);
                }
            }
            return amount;
        }
        return 0;
    }

    public boolean addFluidToTank(FluidStack liquid, boolean first) {
        if (this.fluidlist.size() == 0) {
            this.fluidlist.add(liquid.copy());
            this.currentLiquid += liquid.amount;
            return true;
        }
        if (liquid.amount + this.currentLiquid > this.maxLiquid) {
            return false;
        }
        this.currentLiquid += liquid.amount;
        boolean added = false;
        for (int i = 0; i < this.fluidlist.size(); ++i) {
            FluidStack l = this.fluidlist.get(i);
            if (l.isFluidEqual(liquid)) {
                l.amount += liquid.amount;
                added = true;
            }
            if (l.amount > 0) continue;
            this.fluidlist.remove(l);
            --i;
        }
        if (!added) {
            if (first) {
                this.fluidlist.add(0, liquid.copy());
            } else {
                this.fluidlist.add(liquid.copy());
            }
        }
        return true;
    }

    public FluidStack getFluid() {
        if (this.fluidlist.size() == 0) {
            return null;
        }
        return this.fluidlist.get(0);
    }

    public List<FluidStack> getAllFluids() {
        return this.fluidlist;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidTankInfo[] getMultiTankInfo() {
        FluidTankInfo[] info = new FluidTankInfo[this.fluidlist.size() + 1];
        for (int i = 0; i < this.fluidlist.size(); ++i) {
            FluidStack fluid = this.fluidlist.get(i);
            info[i] = new FluidTankInfo(fluid.copy(), fluid.amount);
        }
        info[this.fluidlist.size()] = new FluidTankInfo(null, this.maxLiquid - this.currentLiquid);
        return info;
    }

    @Override
    public void readNetworkNBT(NBTTagCompound tags) {
        NBTTagList liquidTag = tags.getTagList("Liquids");
        this.fluidlist.clear();
        for (int iter = 0; iter < liquidTag.tagCount(); ++iter) {
            NBTTagCompound nbt = (NBTTagCompound)liquidTag.tagAt(iter);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            if (fluid == null) continue;
            this.fluidlist.add(fluid);
        }
    }

    @Override
    public void writeNetworkNBT(NBTTagCompound tags) {
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.fluidlist) {
            NBTTagCompound nbt = new NBTTagCompound();
            liquid.writeToNBT(nbt);
            taglist.appendTag((NBTBase)nbt);
        }
        tags.setTag("Liquids", (NBTBase)taglist);
    }
}

