/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PlankSlab2Item
extends ItemBlock {
    public static final String[] blockType = new String[]{"purpleheart", "tiger", "willow", "darkwood", "fusewood", "", "", ""};
    int blockID;
    Block block;

    public PlankSlab2Item(int id) {
        super(id);
        this.blockID = id + 256;
        this.block = Block.blocksList[id + 256];
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int md) {
        return md;
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "block.wood." + blockType[itemstack.getItemDamage()] + ".slab";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        switch (stack.getItemDamage()) {
            case 0: {
                list.add("Heart of Wood");
                break;
            }
            case 1: {
                list.add("Wild Grain");
                break;
            }
            case 2: {
                list.add("The Weeper");
                break;
            }
            case 3: {
                list.add("Nether Tree");
                break;
            }
            case 4: {
                list.add("Nether Tree");
                list.add("Explosive Personality");
            }
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean flag;
        int id = world.getBlockId(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        int trueMeta = meta % 8;
        boolean bl = flag = (id & 8) != 0;
        if ((side == 1 && !flag || side == 0 && flag) && id == this.blockID && trueMeta == stack.getItemDamage() && world.setBlock(x, y, z, NContent.planks.blockID, trueMeta + 8, 3)) {
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.block.stepSound.getPlaceSound(), (this.block.stepSound.getVolume() + 1.0f) / 2.0f, this.block.stepSound.getPitch() * 0.8f);
            --stack.stackSize;
            return true;
        }
        return super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }
}

