/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorseBredSelector;
import net.minecraft.entity.passive.EntityHorseGroupData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityHorse
extends EntityAnimal
implements IInvBasic {
    private static final IEntitySelector field_110276_bu = new EntityHorseBredSelector();
    private static final Attribute field_110271_bv = new RangedAttribute("horse.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private static final String[] field_110270_bw = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final String[] field_110273_bx = new String[]{"", "meo", "goo", "dio"};
    private static final int[] field_110272_by = new int[]{0, 5, 7, 11};
    private static final String[] field_110268_bz = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] field_110269_bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] field_110291_bB = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] field_110292_bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    private int field_110289_bD;
    private int field_110290_bE;
    private int field_110295_bF;
    public int field_110278_bp;
    public int field_110279_bq;
    protected boolean field_110275_br;
    private AnimalChest field_110296_bG;
    private boolean field_110293_bH;
    protected int field_110274_bs;
    protected float field_110277_bt;
    private boolean field_110294_bI;
    private float field_110283_bJ;
    private float field_110284_bK;
    private float field_110281_bL;
    private float field_110282_bM;
    private float field_110287_bN;
    private float field_110288_bO;
    private int field_110285_bP;
    private String field_110286_bQ;
    private String[] field_110280_bR = new String[3];

    public EntityHorse(World p_i1685_1_) {
        super(p_i1685_1_);
        this.func_70105_a(1.4f, 1.6f);
        this.field_70178_ae = false;
        this.func_110207_m(false);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new EntityAIPanic(this, 1.2));
        this.field_70714_bg.func_75776_a(1, new EntityAIRunAroundLikeCrazy(this, 1.2));
        this.field_70714_bg.func_75776_a(2, new EntityAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(4, new EntityAIFollowParent(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new EntityAIWander(this, 0.7));
        this.field_70714_bg.func_75776_a(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
        this.func_110226_cD();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, 0);
        this.field_70180_af.func_75682_a(19, (byte)0);
        this.field_70180_af.func_75682_a(20, 0);
        this.field_70180_af.func_75682_a(21, String.valueOf(""));
        this.field_70180_af.func_75682_a(22, 0);
    }

    public void func_110214_p(int p_110214_1_) {
        this.field_70180_af.func_75692_b(19, (byte)p_110214_1_);
        this.func_110230_cF();
    }

    public int func_110265_bP() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void func_110235_q(int p_110235_1_) {
        this.field_70180_af.func_75692_b(20, p_110235_1_);
        this.func_110230_cF();
    }

    public int func_110202_bQ() {
        return this.field_70180_af.func_75679_c(20);
    }

    @Override
    public String func_70023_ak() {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        int n = this.func_110265_bP();
        switch (n) {
            default: {
                return StatCollector.func_74838_a("entity.horse.name");
            }
            case 1: {
                return StatCollector.func_74838_a("entity.donkey.name");
            }
            case 2: {
                return StatCollector.func_74838_a("entity.mule.name");
            }
            case 4: {
                return StatCollector.func_74838_a("entity.skeletonhorse.name");
            }
            case 3: 
        }
        return StatCollector.func_74838_a("entity.zombiehorse.name");
    }

    private boolean func_110233_w(int p_110233_1_) {
        return (this.field_70180_af.func_75679_c(16) & p_110233_1_) != 0;
    }

    private void func_110208_b(int p_110208_1_, boolean p_110208_2_) {
        int n = this.field_70180_af.func_75679_c(16);
        if (p_110208_2_) {
            this.field_70180_af.func_75692_b(16, n | p_110208_1_);
        } else {
            this.field_70180_af.func_75692_b(16, n & ~p_110208_1_);
        }
    }

    public boolean func_110228_bR() {
        return !this.func_70631_g_();
    }

    public boolean func_110248_bS() {
        return this.func_110233_w(2);
    }

    public boolean func_110253_bW() {
        return this.func_110228_bR();
    }

    public String func_142019_cb() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void func_110213_b(String p_110213_1_) {
        this.field_70180_af.func_75692_b(21, p_110213_1_);
    }

    public float func_110254_bY() {
        int n = this.func_70874_b();
        if (n >= 0) {
            return 1.0f;
        }
        return 0.5f + (float)(-24000 - n) / -24000.0f * 0.5f;
    }

    @Override
    public void func_98054_a(boolean p_98054_1_) {
        if (p_98054_1_) {
            this.func_98055_j(this.func_110254_bY());
        } else {
            this.func_98055_j(1.0f);
        }
    }

    public boolean func_110246_bZ() {
        return this.field_110275_br;
    }

    public void func_110234_j(boolean p_110234_1_) {
        this.func_110208_b(2, p_110234_1_);
    }

    public void func_110255_k(boolean p_110255_1_) {
        this.field_110275_br = p_110255_1_;
    }

    @Override
    public boolean func_110164_bC() {
        return !this.func_110256_cu() && super.func_110164_bC();
    }

    @Override
    protected void func_142017_o(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.func_110204_cc()) {
            this.func_110227_p(false);
        }
    }

    public boolean func_110261_ca() {
        return this.func_110233_w(8);
    }

    public int func_110241_cb() {
        return this.field_70180_af.func_75679_c(22);
    }

    public int func_110260_d(ItemStack p_110260_1_) {
        if (p_110260_1_ == null) {
            return 0;
        }
        if (p_110260_1_.field_77993_c == Item.field_111215_ce.field_77779_bT) {
            return 1;
        }
        if (p_110260_1_.field_77993_c == Item.field_111216_cf.field_77779_bT) {
            return 2;
        }
        if (p_110260_1_.field_77993_c == Item.field_111213_cg.field_77779_bT) {
            return 3;
        }
        return 0;
    }

    public boolean func_110204_cc() {
        return this.func_110233_w(32);
    }

    public boolean func_110209_cd() {
        return this.func_110233_w(64);
    }

    public boolean func_110205_ce() {
        return this.func_110233_w(16);
    }

    public boolean func_110243_cf() {
        return this.field_110293_bH;
    }

    public void func_110236_r(int p_110236_1_) {
        this.field_70180_af.func_75692_b(22, p_110236_1_);
        this.func_110230_cF();
    }

    public void func_110242_l(boolean p_110242_1_) {
        this.func_110208_b(16, p_110242_1_);
    }

    public void func_110207_m(boolean p_110207_1_) {
        this.func_110208_b(8, p_110207_1_);
    }

    public void func_110221_n(boolean p_110221_1_) {
        this.field_110293_bH = p_110221_1_;
    }

    public void func_110251_o(boolean p_110251_1_) {
        this.func_110208_b(4, p_110251_1_);
    }

    public int func_110252_cg() {
        return this.field_110274_bs;
    }

    public void func_110238_s(int p_110238_1_) {
        this.field_110274_bs = p_110238_1_;
    }

    public int func_110198_t(int p_110198_1_) {
        int n = MathHelper.func_76125_a(this.func_110252_cg() + p_110198_1_, 0, this.func_110218_cm());
        this.func_110238_s(n);
        return n;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        Entity entity = p_70097_1_.func_76346_g();
        if (this.field_70153_n != null && this.field_70153_n.equals(entity)) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    public int func_70658_aO() {
        return field_110272_by[this.func_110241_cb()];
    }

    @Override
    public boolean func_70104_M() {
        return this.field_70153_n == null;
    }

    public boolean func_110262_ch() {
        int n = MathHelper.func_76128_c(this.field_70165_t);
        int n2 = MathHelper.func_76128_c(this.field_70161_v);
        this.field_70170_p.func_72807_a(n, n2);
        return true;
    }

    public void func_110224_ci() {
        if (this.field_70170_p.field_72995_K || !this.func_110261_ca()) {
            return;
        }
        this.func_70025_b(Block.field_72077_au.field_71990_ca, 1);
        this.func_110207_m(false);
    }

    private void func_110266_cB() {
        this.func_110249_cI();
        this.field_70170_p.func_72956_a(this, "eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
    }

    @Override
    protected void func_70069_a(float p_70069_1_) {
        int n;
        int n2;
        if (p_70069_1_ > 1.0f) {
            this.func_85030_a("mob.horse.land", 0.4f, 1.0f);
        }
        if ((n2 = MathHelper.func_76123_f(p_70069_1_ * 0.5f - 3.0f)) <= 0) {
            return;
        }
        this.func_70097_a(DamageSource.field_76379_h, n2);
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70097_a(DamageSource.field_76379_h, n2);
        }
        if ((n = this.field_70170_p.func_72798_a(MathHelper.func_76128_c(this.field_70165_t), MathHelper.func_76128_c(this.field_70163_u - 0.2 - (double)this.field_70126_B), MathHelper.func_76128_c(this.field_70161_v))) > 0) {
            StepSound stepSound = Block.field_71973_m[n].field_72020_cn;
            this.field_70170_p.func_72956_a(this, stepSound.func_72675_d(), stepSound.func_72677_b() * 0.5f, stepSound.func_72678_c() * 0.75f);
        }
    }

    private int func_110225_cC() {
        int n = this.func_110265_bP();
        if (this.func_110261_ca() && (n == 1 || n == 2)) {
            return 17;
        }
        return 2;
    }

    private void func_110226_cD() {
        AnimalChest animalChest = this.field_110296_bG;
        this.field_110296_bG = new AnimalChest("HorseChest", this.func_110225_cC());
        this.field_110296_bG.func_110133_a(this.func_70023_ak());
        if (animalChest != null) {
            animalChest.func_110132_b(this);
            int n = Math.min(animalChest.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (int i = 0; i < n; ++i) {
                ItemStack itemStack = animalChest.func_70301_a(i);
                if (itemStack == null) continue;
                this.field_110296_bG.func_70299_a(i, itemStack.func_77946_l());
            }
            animalChest = null;
        }
        this.field_110296_bG.func_110134_a(this);
        this.func_110232_cE();
    }

    private void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110251_o(this.field_110296_bG.func_70301_a(0) != null);
            if (this.func_110259_cr()) {
                this.func_110236_r(this.func_110260_d(this.field_110296_bG.func_70301_a(1)));
            }
        }
    }

    @Override
    public void func_76316_a(InventoryBasic p_76316_1_) {
        int n = this.func_110241_cb();
        boolean bl = this.func_110257_ck();
        this.func_110232_cE();
        if (this.field_70173_aa > 20) {
            if (n == 0 && n != this.func_110241_cb()) {
                this.func_85030_a("mob.horse.armor", 0.5f, 1.0f);
            }
            if (!bl && this.func_110257_ck()) {
                this.func_85030_a("mob.horse.leather", 0.5f, 1.0f);
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        this.func_110262_ch();
        return super.func_70601_bi();
    }

    protected EntityHorse func_110250_a(Entity p_110250_1_, double p_110250_2_) {
        double d = Double.MAX_VALUE;
        Entity entity = null;
        List list = this.field_70170_p.func_94576_a(p_110250_1_, p_110250_1_.field_70121_D.func_72321_a(p_110250_2_, p_110250_2_, p_110250_2_), field_110276_bu);
        for (Entity entity2 : list) {
            double d2 = entity2.func_70092_e(p_110250_1_.field_70165_t, p_110250_1_.field_70163_u, p_110250_1_.field_70161_v);
            if (!(d2 < d)) continue;
            entity = entity2;
            d = d2;
        }
        return (EntityHorse)entity;
    }

    public double func_110215_cj() {
        return this.func_110148_a(field_110271_bv).func_111126_e();
    }

    @Override
    protected String func_70673_aS() {
        this.func_110249_cI();
        int n = this.func_110265_bP();
        if (n == 3) {
            return "mob.horse.zombie.death";
        }
        if (n == 4) {
            return "mob.horse.skeleton.death";
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.death";
        }
        return "mob.horse.death";
    }

    @Override
    protected int func_70633_aT() {
        boolean bl = this.field_70146_Z.nextInt(4) == 0;
        int n = this.func_110265_bP();
        if (n == 4) {
            return Item.field_77755_aX.field_77779_bT;
        }
        if (n == 3) {
            if (bl) {
                return 0;
            }
            return Item.field_77737_bm.field_77779_bT;
        }
        return Item.field_77770_aF.field_77779_bT;
    }

    @Override
    protected String func_70621_aR() {
        int n;
        this.func_110249_cI();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_110220_cK();
        }
        if ((n = this.func_110265_bP()) == 3) {
            return "mob.horse.zombie.hit";
        }
        if (n == 4) {
            return "mob.horse.skeleton.hit";
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.hit";
        }
        return "mob.horse.hit";
    }

    public boolean func_110257_ck() {
        return this.func_110233_w(4);
    }

    @Override
    protected String func_70639_aQ() {
        int n;
        this.func_110249_cI();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.func_110220_cK();
        }
        if ((n = this.func_110265_bP()) == 3) {
            return "mob.horse.zombie.idle";
        }
        if (n == 4) {
            return "mob.horse.skeleton.idle";
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.idle";
        }
        return "mob.horse.idle";
    }

    protected String func_110217_cl() {
        this.func_110249_cI();
        this.func_110220_cK();
        int n = this.func_110265_bP();
        if (n == 3 || n == 4) {
            return null;
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.angry";
        }
        return "mob.horse.angry";
    }

    @Override
    protected void func_70036_a(int p_70036_1_, int p_70036_2_, int p_70036_3_, int p_70036_4_) {
        StepSound stepSound = Block.field_71973_m[p_70036_4_].field_72020_cn;
        if (this.field_70170_p.func_72798_a(p_70036_1_, p_70036_2_ + 1, p_70036_3_) == Block.field_72037_aS.field_71990_ca) {
            stepSound = Block.field_72037_aS.field_72020_cn;
        }
        if (!Block.field_71973_m[p_70036_4_].field_72018_cp.func_76224_d()) {
            int n = this.func_110265_bP();
            if (this.field_70153_n != null && n != 1 && n != 2) {
                ++this.field_110285_bP;
                if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                    this.func_85030_a("mob.horse.gallop", stepSound.func_72677_b() * 0.15f, stepSound.func_72678_c());
                    if (n == 0 && this.field_70146_Z.nextInt(10) == 0) {
                        this.func_85030_a("mob.horse.breathe", stepSound.func_72677_b() * 0.6f, stepSound.func_72678_c());
                    }
                } else if (this.field_110285_bP <= 5) {
                    this.func_85030_a("mob.horse.wood", stepSound.func_72677_b() * 0.15f, stepSound.func_72678_c());
                }
            } else if (stepSound == Block.field_71967_e) {
                this.func_85030_a("mob.horse.soft", stepSound.func_72677_b() * 0.15f, stepSound.func_72678_c());
            } else {
                this.func_85030_a("mob.horse.wood", stepSound.func_72677_b() * 0.15f, stepSound.func_72678_c());
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(field_110271_bv);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(53.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.225f);
    }

    @Override
    public int func_70641_bl() {
        return 6;
    }

    public int func_110218_cm() {
        return 100;
    }

    @Override
    protected float func_70599_aP() {
        return 0.8f;
    }

    @Override
    public int func_70627_aG() {
        return 400;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110239_cn() {
        return this.func_110265_bP() == 0 || this.func_110241_cb() > 0;
    }

    private void func_110230_cF() {
        this.field_110286_bQ = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void func_110247_cG() {
        int n;
        this.field_110286_bQ = "horse/";
        this.field_110280_bR[0] = null;
        this.field_110280_bR[1] = null;
        this.field_110280_bR[2] = null;
        int n2 = this.func_110265_bP();
        int n3 = this.func_110202_bQ();
        if (n2 == 0) {
            n = n3 & 0xFF;
            int n4 = (n3 & 0xFF00) >> 8;
            this.field_110280_bR[0] = field_110268_bz[n];
            this.field_110286_bQ = this.field_110286_bQ + field_110269_bA[n];
            this.field_110280_bR[1] = field_110291_bB[n4];
            this.field_110286_bQ = this.field_110286_bQ + field_110292_bC[n4];
        } else {
            this.field_110280_bR[0] = "";
            this.field_110286_bQ = this.field_110286_bQ + "_" + n2 + "_";
        }
        n = this.func_110241_cb();
        this.field_110280_bR[2] = field_110270_bw[n];
        this.field_110286_bQ = this.field_110286_bQ + field_110273_bx[n];
    }

    @SideOnly(value=Side.CLIENT)
    public String func_110264_co() {
        if (this.field_110286_bQ == null) {
            this.func_110247_cG();
        }
        return this.field_110286_bQ;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] func_110212_cp() {
        if (this.field_110286_bQ == null) {
            this.func_110247_cG();
        }
        return this.field_110280_bR;
    }

    public void func_110199_f(EntityPlayer p_110199_1_) {
        if (!this.field_70170_p.field_72995_K && (this.field_70153_n == null || this.field_70153_n == p_110199_1_) && this.func_110248_bS()) {
            this.field_110296_bG.func_110133_a(this.func_70023_ak());
            p_110199_1_.func_110298_a(this, this.field_110296_bG);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        ItemStack itemStack = p_70085_1_.field_71071_by.func_70448_g();
        if (itemStack != null && itemStack.field_77993_c == Item.field_77815_bC.field_77779_bT) {
            return super.func_70085_c(p_70085_1_);
        }
        if (!this.func_110248_bS() && this.func_110256_cu()) {
            return false;
        }
        if (this.func_110248_bS() && this.func_110228_bR() && p_70085_1_.func_70093_af()) {
            this.func_110199_f(p_70085_1_);
            return true;
        }
        if (this.func_110253_bW() && this.field_70153_n != null) {
            return super.func_70085_c(p_70085_1_);
        }
        if (itemStack != null) {
            boolean bl = false;
            if (this.func_110259_cr()) {
                int n = -1;
                if (itemStack.field_77993_c == Item.field_111215_ce.field_77779_bT) {
                    n = 1;
                } else if (itemStack.field_77993_c == Item.field_111216_cf.field_77779_bT) {
                    n = 2;
                } else if (itemStack.field_77993_c == Item.field_111213_cg.field_77779_bT) {
                    n = 3;
                }
                if (n >= 0) {
                    if (!this.func_110248_bS()) {
                        this.func_110231_cz();
                        return true;
                    }
                    this.func_110199_f(p_70085_1_);
                    return true;
                }
            }
            if (!bl && !this.func_110256_cu()) {
                float f = 0.0f;
                int n = 0;
                int n2 = 0;
                if (itemStack.field_77993_c == Item.field_77685_T.field_77779_bT) {
                    f = 2.0f;
                    n = 60;
                    n2 = 3;
                } else if (itemStack.field_77993_c == Item.field_77747_aY.field_77779_bT) {
                    f = 1.0f;
                    n = 30;
                    n2 = 3;
                } else if (itemStack.field_77993_c == Item.field_77684_U.field_77779_bT) {
                    f = 7.0f;
                    n = 180;
                    n2 = 3;
                } else if (itemStack.field_77993_c == Block.field_111038_cB.field_71990_ca) {
                    f = 20.0f;
                    n = 180;
                } else if (itemStack.field_77993_c == Item.field_77706_j.field_77779_bT) {
                    f = 3.0f;
                    n = 60;
                    n2 = 3;
                } else if (itemStack.field_77993_c == Item.field_82798_bP.field_77779_bT) {
                    f = 4.0f;
                    n = 60;
                    n2 = 5;
                    if (this.func_110248_bS() && this.func_70874_b() == 0) {
                        bl = true;
                        this.func_110196_bT();
                    }
                } else if (itemStack.field_77993_c == Item.field_77778_at.field_77779_bT) {
                    f = 10.0f;
                    n = 240;
                    n2 = 10;
                    if (this.func_110248_bS() && this.func_70874_b() == 0) {
                        bl = true;
                        this.func_110196_bT();
                    }
                }
                if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
                    this.func_70691_i(f);
                    bl = true;
                }
                if (!this.func_110228_bR() && n > 0) {
                    this.func_110195_a(n);
                    bl = true;
                }
                if (n2 > 0 && (bl || !this.func_110248_bS()) && n2 < this.func_110218_cm()) {
                    bl = true;
                    this.func_110198_t(n2);
                }
                if (bl) {
                    this.func_110266_cB();
                }
            }
            if (!this.func_110248_bS() && !bl) {
                if (itemStack != null && itemStack.func_111282_a(p_70085_1_, this)) {
                    return true;
                }
                this.func_110231_cz();
                return true;
            }
            if (!bl && this.func_110229_cs() && !this.func_110261_ca() && itemStack.field_77993_c == Block.field_72077_au.field_71990_ca) {
                this.func_110207_m(true);
                this.func_85030_a("mob.chickenplop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                bl = true;
                this.func_110226_cD();
            }
            if (!bl && this.func_110253_bW() && !this.func_110257_ck() && itemStack.field_77993_c == Item.field_77765_aA.field_77779_bT) {
                this.func_110199_f(p_70085_1_);
                return true;
            }
            if (bl) {
                if (!p_70085_1_.field_71075_bZ.field_75098_d && --itemStack.field_77994_a == 0) {
                    p_70085_1_.field_71071_by.func_70299_a(p_70085_1_.field_71071_by.field_70461_c, null);
                }
                return true;
            }
        }
        if (this.func_110253_bW() && this.field_70153_n == null) {
            if (itemStack != null && itemStack.func_111282_a(p_70085_1_, this)) {
                return true;
            }
            this.func_110237_h(p_70085_1_);
            return true;
        }
        return super.func_70085_c(p_70085_1_);
    }

    private void func_110237_h(EntityPlayer p_110237_1_) {
        p_110237_1_.field_70177_z = this.field_70177_z;
        p_110237_1_.field_70125_A = this.field_70125_A;
        this.func_110227_p(false);
        this.func_110219_q(false);
        if (!this.field_70170_p.field_72995_K) {
            p_110237_1_.func_70078_a(this);
        }
    }

    public boolean func_110259_cr() {
        return this.func_110265_bP() == 0;
    }

    public boolean func_110229_cs() {
        int n = this.func_110265_bP();
        return n == 2 || n == 1;
    }

    @Override
    protected boolean func_70610_aX() {
        if (this.field_70153_n != null && this.func_110257_ck()) {
            return true;
        }
        return this.func_110204_cc() || this.func_110209_cd();
    }

    public boolean func_110256_cu() {
        int n = this.func_110265_bP();
        return n == 3 || n == 4;
    }

    public boolean func_110222_cv() {
        return this.func_110256_cu() || this.func_110265_bP() == 2;
    }

    @Override
    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    private void func_110210_cH() {
        this.field_110278_bp = 1;
    }

    @Override
    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110244_cA();
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            EntityHorse entityHorse;
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (!this.func_110204_cc() && this.field_70153_n == null && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_72798_a(MathHelper.func_76128_c(this.field_70165_t), MathHelper.func_76128_c(this.field_70163_u) - 1, MathHelper.func_76128_c(this.field_70161_v)) == Block.field_71980_u.field_71990_ca) {
                this.func_110227_p(true);
            }
            if (this.func_110204_cc() && ++this.field_110289_bD > 50) {
                this.field_110289_bD = 0;
                this.func_110227_p(false);
            }
            if (this.func_110205_ce() && !this.func_110228_bR() && !this.func_110204_cc() && (entityHorse = this.func_110250_a(this, 16.0)) != null && this.func_70068_e(entityHorse) > 4.0) {
                PathEntity pathEntity = this.field_70170_p.func_72865_a(this, entityHorse, 16.0f, true, false, false, true);
                this.func_70778_a(pathEntity);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75684_a()) {
            this.field_70180_af.func_111144_e();
            this.func_110230_cF();
        }
        if (this.field_110290_bE > 0 && ++this.field_110290_bE > 30) {
            this.field_110290_bE = 0;
            this.func_110208_b(128, false);
        }
        if (!this.field_70170_p.field_72995_K && this.field_110295_bF > 0 && ++this.field_110295_bF > 20) {
            this.field_110295_bF = 0;
            this.func_110219_q(false);
        }
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.field_110284_bK = this.field_110283_bJ;
        if (this.func_110204_cc()) {
            this.field_110283_bJ += (1.0f - this.field_110283_bJ) * 0.4f + 0.05f;
            if (this.field_110283_bJ > 1.0f) {
                this.field_110283_bJ = 1.0f;
            }
        } else {
            this.field_110283_bJ += (0.0f - this.field_110283_bJ) * 0.4f - 0.05f;
            if (this.field_110283_bJ < 0.0f) {
                this.field_110283_bJ = 0.0f;
            }
        }
        this.field_110282_bM = this.field_110281_bL;
        if (this.func_110209_cd()) {
            this.field_110283_bJ = 0.0f;
            this.field_110284_bK = 0.0f;
            this.field_110281_bL += (1.0f - this.field_110281_bL) * 0.4f + 0.05f;
            if (this.field_110281_bL > 1.0f) {
                this.field_110281_bL = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.field_110281_bL += (0.8f * this.field_110281_bL * this.field_110281_bL * this.field_110281_bL - this.field_110281_bL) * 0.6f - 0.05f;
            if (this.field_110281_bL < 0.0f) {
                this.field_110281_bL = 0.0f;
            }
        }
        this.field_110288_bO = this.field_110287_bN;
        if (this.func_110233_w(128)) {
            this.field_110287_bN += (1.0f - this.field_110287_bN) * 0.7f + 0.05f;
            if (this.field_110287_bN > 1.0f) {
                this.field_110287_bN = 1.0f;
            }
        } else {
            this.field_110287_bN += (0.0f - this.field_110287_bN) * 0.7f - 0.05f;
            if (this.field_110287_bN < 0.0f) {
                this.field_110287_bN = 0.0f;
            }
        }
    }

    private void func_110249_cI() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_110290_bE = 1;
            this.func_110208_b(128, true);
        }
    }

    private boolean func_110200_cJ() {
        return this.field_70153_n == null && this.field_70154_o == null && this.func_110248_bS() && this.func_110228_bR() && !this.func_110222_cv() && this.func_110143_aJ() >= this.func_110138_aP();
    }

    @Override
    public void func_70019_c(boolean p_70019_1_) {
        this.func_110208_b(32, p_70019_1_);
    }

    public void func_110227_p(boolean p_110227_1_) {
        this.func_70019_c(p_110227_1_);
    }

    public void func_110219_q(boolean p_110219_1_) {
        if (p_110219_1_) {
            this.func_110227_p(false);
        }
        this.func_110208_b(64, p_110219_1_);
    }

    private void func_110220_cK() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_110295_bF = 1;
            this.func_110219_q(true);
        }
    }

    public void func_110231_cz() {
        this.func_110220_cK();
        String string = this.func_110217_cl();
        if (string != null) {
            this.func_85030_a(string, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_110244_cA() {
        this.func_110240_a(this, this.field_110296_bG);
        this.func_110224_ci();
    }

    private void func_110240_a(Entity p_110240_1_, AnimalChest p_110240_2_) {
        if (p_110240_2_ == null || this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < p_110240_2_.func_70302_i_(); ++i) {
            ItemStack itemStack = p_110240_2_.func_70301_a(i);
            if (itemStack == null) continue;
            this.func_70099_a(itemStack, 0.0f);
        }
    }

    public boolean func_110263_g(EntityPlayer p_110263_1_) {
        this.func_110213_b(p_110263_1_.func_70005_c_());
        this.func_110234_j(true);
        return true;
    }

    @Override
    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.field_70153_n == null || !this.func_110257_ck()) {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(p_70612_1_, p_70612_2_);
            return;
        }
        this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
        this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        p_70612_1_ = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
        p_70612_2_ = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
        if (p_70612_2_ <= 0.0f) {
            p_70612_2_ *= 0.25f;
            this.field_110285_bP = 0;
        }
        if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.field_110294_bI) {
            p_70612_1_ = 0.0f;
            p_70612_2_ = 0.0f;
        }
        if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
            this.field_70181_x = this.func_110215_cj() * (double)this.field_110277_bt;
            if (this.func_70644_a(Potion.field_76430_j)) {
                this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
            }
            this.func_110255_k(true);
            this.field_70160_al = true;
            if (p_70612_2_ > 0.0f) {
                float f = MathHelper.func_76126_a(this.field_70177_z * (float)Math.PI / 180.0f);
                float f2 = MathHelper.func_76134_b(this.field_70177_z * (float)Math.PI / 180.0f);
                this.field_70159_w += (double)(-0.4f * f * this.field_110277_bt);
                this.field_70179_y += (double)(0.4f * f2 * this.field_110277_bt);
                this.func_85030_a("mob.horse.jump", 0.4f, 1.0f);
            }
            this.field_110277_bt = 0.0f;
        }
        this.field_70138_W = 1.0f;
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
        if (this.field_70122_E) {
            this.field_110277_bt = 0.0f;
            this.func_110255_k(false);
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d = this.field_70165_t - this.field_70169_q;
        double d2 = this.field_70161_v - this.field_70166_s;
        float f = MathHelper.func_76133_a(d * d + d2 * d2) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.field_70721_aZ += (f - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Override
    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74757_a("EatingHaystack", this.func_110204_cc());
        p_70014_1_.func_74757_a("ChestedHorse", this.func_110261_ca());
        p_70014_1_.func_74757_a("HasReproduced", this.func_110243_cf());
        p_70014_1_.func_74757_a("Bred", this.func_110205_ce());
        p_70014_1_.func_74768_a("Type", this.func_110265_bP());
        p_70014_1_.func_74768_a("Variant", this.func_110202_bQ());
        p_70014_1_.func_74768_a("Temper", this.func_110252_cg());
        p_70014_1_.func_74757_a("Tame", this.func_110248_bS());
        p_70014_1_.func_74778_a("OwnerName", this.func_142019_cb());
        if (this.func_110261_ca()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (int i = 2; i < this.field_110296_bG.func_70302_i_(); ++i) {
                ItemStack itemStack = this.field_110296_bG.func_70301_a(i);
                if (itemStack == null) continue;
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74774_a("Slot", (byte)i);
                itemStack.func_77955_b(nBTTagCompound);
                nBTTagList.func_74742_a(nBTTagCompound);
            }
            p_70014_1_.func_74782_a("Items", nBTTagList);
        }
        if (this.field_110296_bG.func_70301_a(1) != null) {
            p_70014_1_.func_74782_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound("ArmorItem")));
        }
        if (this.field_110296_bG.func_70301_a(0) != null) {
            p_70014_1_.func_74782_a("SaddleItem", this.field_110296_bG.func_70301_a(0).func_77955_b(new NBTTagCompound("SaddleItem")));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound p_70037_1_) {
        Object object;
        AttributeInstance attributeInstance;
        super.func_70037_a(p_70037_1_);
        this.func_110227_p(p_70037_1_.func_74767_n("EatingHaystack"));
        this.func_110242_l(p_70037_1_.func_74767_n("Bred"));
        this.func_110207_m(p_70037_1_.func_74767_n("ChestedHorse"));
        this.func_110221_n(p_70037_1_.func_74767_n("HasReproduced"));
        this.func_110214_p(p_70037_1_.func_74762_e("Type"));
        this.func_110235_q(p_70037_1_.func_74762_e("Variant"));
        this.func_110238_s(p_70037_1_.func_74762_e("Temper"));
        this.func_110234_j(p_70037_1_.func_74767_n("Tame"));
        if (p_70037_1_.func_74764_b("OwnerName")) {
            this.func_110213_b(p_70037_1_.func_74779_i("OwnerName"));
        }
        if ((attributeInstance = this.func_110140_aT().func_111152_a("Speed")) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(attributeInstance.func_111125_b() * 0.25);
        }
        if (this.func_110261_ca()) {
            object = p_70037_1_.func_74761_m("Items");
            this.func_110226_cD();
            for (int i = 0; i < ((NBTTagList)object).func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)((NBTTagList)object).func_74743_b(i);
                int n = nBTTagCompound.func_74771_c("Slot") & 0xFF;
                if (n < 2 || n >= this.field_110296_bG.func_70302_i_()) continue;
                this.field_110296_bG.func_70299_a(n, ItemStack.func_77949_a(nBTTagCompound));
            }
        }
        if (p_70037_1_.func_74764_b("ArmorItem") && (object = ItemStack.func_77949_a(p_70037_1_.func_74775_l("ArmorItem"))) != null && EntityHorse.func_110211_v(((ItemStack)object).field_77993_c)) {
            this.field_110296_bG.func_70299_a(1, (ItemStack)object);
        }
        if (p_70037_1_.func_74764_b("SaddleItem")) {
            object = ItemStack.func_77949_a(p_70037_1_.func_74775_l("SaddleItem"));
            if (object != null && ((ItemStack)object).field_77993_c == Item.field_77765_aA.field_77779_bT) {
                this.field_110296_bG.func_70299_a(0, (ItemStack)object);
            }
        } else if (p_70037_1_.func_74767_n("Saddle")) {
            this.field_110296_bG.func_70299_a(0, new ItemStack(Item.field_77765_aA));
        }
        this.func_110232_cE();
    }

    @Override
    public boolean func_70878_b(EntityAnimal p_70878_1_) {
        int n;
        if (p_70878_1_ == this) {
            return false;
        }
        if (p_70878_1_.getClass() != this.getClass()) {
            return false;
        }
        EntityHorse entityHorse = (EntityHorse)p_70878_1_;
        if (!this.func_110200_cJ() || !entityHorse.func_110200_cJ()) {
            return false;
        }
        int n2 = this.func_110265_bP();
        return n2 == (n = entityHorse.func_110265_bP()) || n2 == 0 && n == 1 || n2 == 1 && n == 0;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable p_90011_1_) {
        EntityHorse entityHorse = (EntityHorse)p_90011_1_;
        EntityHorse entityHorse2 = new EntityHorse(this.field_70170_p);
        int n = this.func_110265_bP();
        int n2 = entityHorse.func_110265_bP();
        int n3 = 0;
        if (n == n2) {
            n3 = n;
        } else if (n == 0 && n2 == 1 || n == 1 && n2 == 0) {
            n3 = 2;
        }
        if (n3 == 0) {
            int n4 = this.field_70146_Z.nextInt(9);
            int n5 = n4 < 4 ? this.func_110202_bQ() & 0xFF : (n4 < 8 ? entityHorse.func_110202_bQ() & 0xFF : this.field_70146_Z.nextInt(7));
            int n6 = this.field_70146_Z.nextInt(5);
            n5 = n6 < 4 ? (n5 |= this.func_110202_bQ() & 0xFF00) : (n6 < 8 ? (n5 |= entityHorse.func_110202_bQ() & 0xFF00) : (n5 |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
            entityHorse2.func_110235_q(n5);
        }
        entityHorse2.func_110214_p(n3);
        double d = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + p_90011_1_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL();
        entityHorse2.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d / 3.0);
        double d2 = this.func_110148_a(field_110271_bv).func_111125_b() + p_90011_1_.func_110148_a(field_110271_bv).func_111125_b() + this.func_110245_cM();
        entityHorse2.func_110148_a(field_110271_bv).func_111128_a(d2 / 3.0);
        double d3 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + p_90011_1_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN();
        entityHorse2.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d3 / 3.0);
        return entityHorse2;
    }

    @Override
    public EntityLivingData func_110161_a(EntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_110161_a(p_110161_1_);
        int n = 0;
        int n2 = 0;
        if (p_110161_1_ instanceof EntityHorseGroupData) {
            n = ((EntityHorseGroupData)p_110161_1_).field_111107_a;
            n2 = ((EntityHorseGroupData)p_110161_1_).field_111106_b & 0xFF | this.field_70146_Z.nextInt(5) << 8;
        } else {
            if (this.field_70146_Z.nextInt(10) == 0) {
                n = 1;
            } else {
                int n3 = this.field_70146_Z.nextInt(7);
                int n4 = this.field_70146_Z.nextInt(5);
                n = 0;
                n2 = n3 | n4 << 8;
            }
            p_110161_1_ = new EntityHorseGroupData(n, n2);
        }
        this.func_110214_p(n);
        this.func_110235_q(n2);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        if (n == 4 || n == 3) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2f);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110267_cL());
            if (n == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.175f);
            }
        }
        if (n == 2 || n == 1) {
            this.func_110148_a(field_110271_bv).func_111128_a(0.5);
        } else {
            this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
        }
        this.func_70606_j(this.func_110138_aP());
        return p_110161_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_110258_o(float p_110258_1_) {
        return this.field_110284_bK + (this.field_110283_bJ - this.field_110284_bK) * p_110258_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_110223_p(float p_110223_1_) {
        return this.field_110282_bM + (this.field_110281_bL - this.field_110282_bM) * p_110223_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_110201_q(float p_110201_1_) {
        return this.field_110288_bO + (this.field_110287_bN - this.field_110288_bO) * p_110201_1_;
    }

    @Override
    protected boolean func_70650_aV() {
        return true;
    }

    public void func_110206_u(int p_110206_1_) {
        if (this.func_110257_ck()) {
            if (p_110206_1_ < 0) {
                p_110206_1_ = 0;
            } else {
                this.field_110294_bI = true;
                this.func_110220_cK();
            }
            this.field_110277_bt = p_110206_1_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_110206_1_ / 90.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_110216_r(boolean p_110216_1_) {
        String string = p_110216_1_ ? "heart" : "smoke";
        for (int i = 0; i < 7; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(string, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d2, d3);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 7) {
            this.func_110216_r(true);
        } else if (p_70103_1_ == 6) {
            this.func_110216_r(false);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @Override
    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_110282_bM > 0.0f) {
            float f = MathHelper.func_76126_a(this.field_70761_aq * (float)Math.PI / 180.0f);
            float f2 = MathHelper.func_76134_b(this.field_70761_aq * (float)Math.PI / 180.0f);
            float f3 = 0.7f * this.field_110282_bM;
            float f4 = 0.15f * this.field_110282_bM;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f3 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f4, this.field_70161_v - (double)(f3 * f2));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    private float func_110267_cL() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    private double func_110245_cM() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    private double func_110203_cN() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public static boolean func_110211_v(int p_110211_0_) {
        return p_110211_0_ == Item.field_111215_ce.field_77779_bT || p_110211_0_ == Item.field_111216_cf.field_77779_bT || p_110211_0_ == Item.field_111213_cg.field_77779_bT;
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }
}

