/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.CallableChunkPosHash;
import net.minecraft.world.gen.structure.CallableIsFeatureChunk;
import net.minecraft.world.gen.structure.CallableStructureType;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public abstract class MapGenStructure
extends MapGenBase {
    private MapGenStructureData field_143029_e;
    protected Map field_75053_d = new HashMap();

    public abstract String func_143025_a();

    @Override
    protected final void func_75037_a(World p_75037_1_, int p_75037_2_, int p_75037_3_, int p_75037_4_, int p_75037_5_, byte[] p_75037_6_) {
        this.func_143027_a(p_75037_1_);
        if (this.field_75053_d.containsKey(ChunkCoordIntPair.func_77272_a(p_75037_2_, p_75037_3_))) {
            return;
        }
        this.field_75038_b.nextInt();
        try {
            if (this.func_75047_a(p_75037_2_, p_75037_3_)) {
                StructureStart structureStart = this.func_75049_b(p_75037_2_, p_75037_3_);
                this.field_75053_d.put(ChunkCoordIntPair.func_77272_a(p_75037_2_, p_75037_3_), structureStart);
                this.func_143026_a(p_75037_2_, p_75037_3_, structureStart);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception preparing structure feature");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Feature being prepared");
            crashReportCategory.func_71500_a("Is feature chunk", new CallableIsFeatureChunk(this, p_75037_2_, p_75037_3_));
            crashReportCategory.func_71507_a("Chunk location", String.format("%d,%d", p_75037_2_, p_75037_3_));
            crashReportCategory.func_71500_a("Chunk pos hash", new CallableChunkPosHash(this, p_75037_2_, p_75037_3_));
            crashReportCategory.func_71500_a("Structure type", new CallableStructureType(this));
            throw new ReportedException(crashReport);
        }
    }

    public boolean func_75051_a(World p_75051_1_, Random p_75051_2_, int p_75051_3_, int p_75051_4_) {
        this.func_143027_a(p_75051_1_);
        int n = (p_75051_3_ << 4) + 8;
        int n2 = (p_75051_4_ << 4) + 8;
        boolean bl = false;
        for (StructureStart structureStart : this.field_75053_d.values()) {
            if (!structureStart.func_75069_d() || !structureStart.func_75071_a().func_78885_a(n, n2, n + 15, n2 + 15)) continue;
            structureStart.func_75068_a(p_75051_1_, p_75051_2_, new StructureBoundingBox(n, n2, n + 15, n2 + 15));
            bl = true;
            this.func_143026_a(structureStart.func_143019_e(), structureStart.func_143018_f(), structureStart);
        }
        return bl;
    }

    public boolean func_75048_a(int p_75048_1_, int p_75048_2_, int p_75048_3_) {
        this.func_143027_a(this.field_75039_c);
        return this.func_143028_c(p_75048_1_, p_75048_2_, p_75048_3_) != null;
    }

    protected StructureStart func_143028_c(int p_143028_1_, int p_143028_2_, int p_143028_3_) {
        for (StructureStart structureStart : this.field_75053_d.values()) {
            if (!structureStart.func_75069_d() || !structureStart.func_75071_a().func_78885_a(p_143028_1_, p_143028_3_, p_143028_1_, p_143028_3_)) continue;
            for (StructureComponent structureComponent : structureStart.func_75073_b()) {
                if (!structureComponent.func_74874_b().func_78890_b(p_143028_1_, p_143028_2_, p_143028_3_)) continue;
                return structureStart;
            }
        }
        return null;
    }

    public boolean func_142038_b(int p_142038_1_, int p_142038_2_, int p_142038_3_) {
        this.func_143027_a(this.field_75039_c);
        for (StructureStart structureStart : this.field_75053_d.values()) {
            if (!structureStart.func_75069_d()) continue;
            return structureStart.func_75071_a().func_78885_a(p_142038_1_, p_142038_3_, p_142038_1_, p_142038_3_);
        }
        return false;
    }

    public ChunkPosition func_75050_a(World p_75050_1_, int p_75050_2_, int p_75050_3_, int p_75050_4_) {
        double d;
        int n;
        int n2;
        int n3;
        ChunkPosition chunkPosition;
        Object object;
        this.field_75039_c = p_75050_1_;
        this.func_143027_a(p_75050_1_);
        this.field_75038_b.setSeed(p_75050_1_.func_72905_C());
        long l = this.field_75038_b.nextLong();
        long l2 = this.field_75038_b.nextLong();
        long l3 = (long)(p_75050_2_ >> 4) * l;
        long l4 = (long)(p_75050_4_ >> 4) * l2;
        this.field_75038_b.setSeed(l3 ^ l4 ^ p_75050_1_.func_72905_C());
        this.func_75037_a(p_75050_1_, p_75050_2_ >> 4, p_75050_4_ >> 4, 0, 0, null);
        double d2 = Double.MAX_VALUE;
        ChunkPosition chunkPosition2 = null;
        for (Object object2 : this.field_75053_d.values()) {
            if (!((StructureStart)object2).func_75069_d()) continue;
            object = (StructureComponent)((StructureStart)object2).func_75073_b().get(0);
            chunkPosition = ((StructureComponent)object).func_74868_a();
            n3 = chunkPosition.field_76930_a - p_75050_2_;
            n2 = chunkPosition.field_76928_b - p_75050_3_;
            n = chunkPosition.field_76929_c - p_75050_4_;
            d = n3 * n3 + n2 * n2 + n * n;
            if (!(d < d2)) continue;
            d2 = d;
            chunkPosition2 = chunkPosition;
        }
        if (chunkPosition2 != null) {
            return chunkPosition2;
        }
        List list = this.func_75052_o_();
        if (list != null) {
            Object object2;
            object2 = null;
            object = list.iterator();
            while (object.hasNext()) {
                chunkPosition = (ChunkPosition)object.next();
                n3 = chunkPosition.field_76930_a - p_75050_2_;
                n2 = chunkPosition.field_76928_b - p_75050_3_;
                n = chunkPosition.field_76929_c - p_75050_4_;
                d = n3 * n3 + n2 * n2 + n * n;
                if (!(d < d2)) continue;
                d2 = d;
                object2 = chunkPosition;
            }
            return object2;
        }
        return null;
    }

    protected List func_75052_o_() {
        return null;
    }

    private void func_143027_a(World p_143027_1_) {
        if (this.field_143029_e == null) {
            this.field_143029_e = (MapGenStructureData)p_143027_1_.func_72943_a(MapGenStructureData.class, this.func_143025_a());
            if (this.field_143029_e == null) {
                this.field_143029_e = new MapGenStructureData(this.func_143025_a());
                p_143027_1_.func_72823_a(this.func_143025_a(), this.field_143029_e);
            } else {
                NBTTagCompound nBTTagCompound = this.field_143029_e.func_143041_a();
                for (NBTBase nBTBase : nBTTagCompound.func_74758_c()) {
                    NBTTagCompound nBTTagCompound2;
                    if (nBTBase.func_74732_a() != 10 || !(nBTTagCompound2 = (NBTTagCompound)nBTBase).func_74764_b("ChunkX") || !nBTTagCompound2.func_74764_b("ChunkZ")) continue;
                    int n = nBTTagCompound2.func_74762_e("ChunkX");
                    int n2 = nBTTagCompound2.func_74762_e("ChunkZ");
                    StructureStart structureStart = MapGenStructureIO.func_143035_a(nBTTagCompound2, p_143027_1_);
                    this.field_75053_d.put(ChunkCoordIntPair.func_77272_a(n, n2), structureStart);
                }
            }
        }
    }

    private void func_143026_a(int p_143026_1_, int p_143026_2_, StructureStart p_143026_3_) {
        this.field_143029_e.func_143043_a(p_143026_3_.func_143021_a(p_143026_1_, p_143026_2_), p_143026_1_, p_143026_2_);
        this.field_143029_e.func_76185_a();
    }

    protected abstract boolean func_75047_a(int var1, int var2);

    protected abstract StructureStart func_75049_b(int var1, int var2);
}

