/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.logging.ILogAgent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3Pool;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.CallableLvl1;
import net.minecraft.world.CallableLvl2;
import net.minecraft.world.CallableLvl3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;

public abstract class World
implements IBlockAccess {
    public boolean field_72999_e;
    public List field_72996_f = new ArrayList();
    protected List field_72997_g = new ArrayList();
    public List field_73009_h = new ArrayList();
    private List field_73002_a = new ArrayList();
    private List field_73000_b = new ArrayList();
    public List field_73010_i = new ArrayList();
    public List field_73007_j = new ArrayList();
    private long field_73001_c = 0xFFFFFFL;
    public int field_73008_k;
    protected int field_73005_l = new Random().nextInt();
    protected final int field_73006_m = 1013904223;
    public float field_73003_n;
    public float field_73004_o;
    public float field_73018_p;
    public float field_73017_q;
    public int field_73016_r;
    public int field_73013_u;
    public Random field_73012_v = new Random();
    public final WorldProvider field_73011_w;
    protected List field_73021_x = new ArrayList();
    protected IChunkProvider field_73020_y;
    protected final ISaveHandler field_73019_z;
    protected WorldInfo field_72986_A;
    public boolean field_72987_B;
    public MapStorage field_72988_C;
    public VillageCollection field_72982_D;
    protected final VillageSiege field_72983_E = new VillageSiege(this);
    public final Profiler field_72984_F;
    private final Vec3Pool field_82741_K = new Vec3Pool(300, 2000);
    private final Calendar field_83016_L = Calendar.getInstance();
    protected Scoreboard field_96442_D = new Scoreboard();
    private final ILogAgent field_98181_L;
    private ArrayList field_72998_d = new ArrayList();
    private boolean field_72989_L;
    protected boolean field_72985_G = true;
    protected boolean field_72992_H = true;
    public Set field_72993_I = new HashSet();
    private int field_72990_M = this.field_73012_v.nextInt(12000);
    int[] field_72994_J = new int[32768];
    public boolean field_72995_K;

    @Override
    public BiomeGenBase func_72807_a(int p_72807_1_, int p_72807_2_) {
        Chunk chunk;
        if (this.func_72899_e(p_72807_1_, 0, p_72807_2_) && (chunk = this.func_72938_d(p_72807_1_, p_72807_2_)) != null) {
            return chunk.func_76591_a(p_72807_1_ & 0xF, p_72807_2_ & 0xF, this.field_73011_w.field_76578_c);
        }
        return this.field_73011_w.field_76578_c.func_76935_a(p_72807_1_, p_72807_2_);
    }

    public WorldChunkManager func_72959_q() {
        return this.field_73011_w.field_76578_c;
    }

    @SideOnly(value=Side.CLIENT)
    public World(ISaveHandler p_i1953_1_, String p_i1953_2_, WorldProvider p_i1953_3_, WorldSettings p_i1953_4_, Profiler p_i1953_5_, ILogAgent p_i1953_6_) {
        this.field_73019_z = p_i1953_1_;
        this.field_72984_F = p_i1953_5_;
        this.field_72986_A = new WorldInfo(p_i1953_4_, p_i1953_2_);
        this.field_73011_w = p_i1953_3_;
        this.field_72988_C = new MapStorage(p_i1953_1_);
        this.field_98181_L = p_i1953_6_;
        VillageCollection villageCollection = (VillageCollection)this.field_72988_C.func_75742_a(VillageCollection.class, "villages");
        if (villageCollection == null) {
            this.field_72982_D = new VillageCollection(this);
            this.field_72988_C.func_75745_a("villages", this.field_72982_D);
        } else {
            this.field_72982_D = villageCollection;
            this.field_72982_D.func_82566_a(this);
        }
        p_i1953_3_.func_76558_a(this);
        this.field_73020_y = this.func_72970_h();
        this.func_72966_v();
        this.func_72947_a();
    }

    public World(ISaveHandler p_i1954_1_, String p_i1954_2_, WorldSettings p_i1954_3_, WorldProvider p_i1954_4_, Profiler p_i1954_5_, ILogAgent p_i1954_6_) {
        VillageCollection villageCollection;
        this.field_73019_z = p_i1954_1_;
        this.field_72984_F = p_i1954_5_;
        this.field_72988_C = new MapStorage(p_i1954_1_);
        this.field_98181_L = p_i1954_6_;
        this.field_72986_A = p_i1954_1_.func_75757_d();
        this.field_73011_w = p_i1954_4_ != null ? p_i1954_4_ : (this.field_72986_A != null && this.field_72986_A.func_76076_i() != 0 ? WorldProvider.func_76570_a(this.field_72986_A.func_76076_i()) : WorldProvider.func_76570_a(0));
        if (this.field_72986_A == null) {
            this.field_72986_A = new WorldInfo(p_i1954_3_, p_i1954_2_);
        } else {
            this.field_72986_A.func_76062_a(p_i1954_2_);
        }
        this.field_73011_w.func_76558_a(this);
        this.field_73020_y = this.func_72970_h();
        if (!this.field_72986_A.func_76070_v()) {
            try {
                this.func_72963_a(p_i1954_3_);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    this.func_72914_a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            this.field_72986_A.func_76091_d(true);
        }
        if ((villageCollection = (VillageCollection)this.field_72988_C.func_75742_a(VillageCollection.class, "villages")) == null) {
            this.field_72982_D = new VillageCollection(this);
            this.field_72988_C.func_75745_a("villages", this.field_72982_D);
        } else {
            this.field_72982_D = villageCollection;
            this.field_72982_D.func_82566_a(this);
        }
        this.func_72966_v();
        this.func_72947_a();
    }

    protected abstract IChunkProvider func_72970_h();

    protected void func_72963_a(WorldSettings p_72963_1_) {
        this.field_72986_A.func_76091_d(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72974_f() {
        this.func_72950_A(8, 64, 8);
    }

    public int func_72922_b(int p_72922_1_, int p_72922_2_) {
        int n = 63;
        while (!this.func_72799_c(p_72922_1_, n + 1, p_72922_2_)) {
            ++n;
        }
        return this.func_72798_a(p_72922_1_, n, p_72922_2_);
    }

    @Override
    public int func_72798_a(int p_72798_1_, int p_72798_2_, int p_72798_3_) {
        if (p_72798_1_ < -30000000 || p_72798_3_ < -30000000 || p_72798_1_ >= 30000000 || p_72798_3_ >= 30000000) {
            return 0;
        }
        if (p_72798_2_ < 0) {
            return 0;
        }
        if (p_72798_2_ >= 256) {
            return 0;
        }
        Chunk chunk = null;
        try {
            chunk = this.func_72964_e(p_72798_1_ >> 4, p_72798_3_ >> 4);
            return chunk.func_76610_a(p_72798_1_ & 0xF, p_72798_2_, p_72798_3_ & 0xF);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception getting block type in world");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Requested block coordinates");
            crashReportCategory.func_71507_a("Found chunk", chunk == null);
            crashReportCategory.func_71507_a("Location", CrashReportCategory.func_85071_a(p_72798_1_, p_72798_2_, p_72798_3_));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public boolean func_72799_c(int p_72799_1_, int p_72799_2_, int p_72799_3_) {
        return this.func_72798_a(p_72799_1_, p_72799_2_, p_72799_3_) == 0;
    }

    public boolean func_72927_d(int p_72927_1_, int p_72927_2_, int p_72927_3_) {
        int n = this.func_72798_a(p_72927_1_, p_72927_2_, p_72927_3_);
        return Block.field_71973_m[n] != null && Block.field_71973_m[n].func_71887_s();
    }

    public int func_85175_e(int p_85175_1_, int p_85175_2_, int p_85175_3_) {
        int n = this.func_72798_a(p_85175_1_, p_85175_2_, p_85175_3_);
        if (Block.field_71973_m[n] != null) {
            return Block.field_71973_m[n].func_71857_b();
        }
        return -1;
    }

    public boolean func_72899_e(int p_72899_1_, int p_72899_2_, int p_72899_3_) {
        if (p_72899_2_ < 0 || p_72899_2_ >= 256) {
            return false;
        }
        return this.func_72916_c(p_72899_1_ >> 4, p_72899_3_ >> 4);
    }

    public boolean func_72873_a(int p_72873_1_, int p_72873_2_, int p_72873_3_, int p_72873_4_) {
        return this.func_72904_c(p_72873_1_ - p_72873_4_, p_72873_2_ - p_72873_4_, p_72873_3_ - p_72873_4_, p_72873_1_ + p_72873_4_, p_72873_2_ + p_72873_4_, p_72873_3_ + p_72873_4_);
    }

    public boolean func_72904_c(int p_72904_1_, int p_72904_2_, int p_72904_3_, int p_72904_4_, int p_72904_5_, int p_72904_6_) {
        if (p_72904_5_ < 0 || p_72904_2_ >= 256) {
            return false;
        }
        p_72904_3_ >>= 4;
        p_72904_4_ >>= 4;
        p_72904_6_ >>= 4;
        for (int i = p_72904_1_ >>= 4; i <= p_72904_4_; ++i) {
            for (int j = p_72904_3_; j <= p_72904_6_; ++j) {
                if (this.func_72916_c(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean func_72916_c(int p_72916_1_, int p_72916_2_) {
        return this.field_73020_y.func_73149_a(p_72916_1_, p_72916_2_);
    }

    public Chunk func_72938_d(int p_72938_1_, int p_72938_2_) {
        return this.func_72964_e(p_72938_1_ >> 4, p_72938_2_ >> 4);
    }

    public Chunk func_72964_e(int p_72964_1_, int p_72964_2_) {
        return this.field_73020_y.func_73154_d(p_72964_1_, p_72964_2_);
    }

    public boolean func_72832_d(int p_72832_1_, int p_72832_2_, int p_72832_3_, int p_72832_4_, int p_72832_5_, int p_72832_6_) {
        if (p_72832_1_ < -30000000 || p_72832_3_ < -30000000 || p_72832_1_ >= 30000000 || p_72832_3_ >= 30000000) {
            return false;
        }
        if (p_72832_2_ < 0) {
            return false;
        }
        if (p_72832_2_ >= 256) {
            return false;
        }
        Chunk chunk = this.func_72964_e(p_72832_1_ >> 4, p_72832_3_ >> 4);
        int n = 0;
        if ((p_72832_6_ & 1) != 0) {
            n = chunk.func_76610_a(p_72832_1_ & 0xF, p_72832_2_, p_72832_3_ & 0xF);
        }
        boolean bl = chunk.func_76592_a(p_72832_1_ & 0xF, p_72832_2_, p_72832_3_ & 0xF, p_72832_4_, p_72832_5_);
        this.field_72984_F.func_76320_a("checkLight");
        this.func_72969_x(p_72832_1_, p_72832_2_, p_72832_3_);
        this.field_72984_F.func_76319_b();
        if (bl) {
            if (!((p_72832_6_ & 2) == 0 || this.field_72995_K && (p_72832_6_ & 4) != 0)) {
                this.func_72845_h(p_72832_1_, p_72832_2_, p_72832_3_);
            }
            if (!this.field_72995_K && (p_72832_6_ & 1) != 0) {
                this.func_72851_f(p_72832_1_, p_72832_2_, p_72832_3_, n);
                Block block = Block.field_71973_m[p_72832_4_];
                if (block != null && block.func_96468_q_()) {
                    this.func_96440_m(p_72832_1_, p_72832_2_, p_72832_3_, p_72832_4_);
                }
            }
        }
        return bl;
    }

    @Override
    public Material func_72803_f(int p_72803_1_, int p_72803_2_, int p_72803_3_) {
        int n = this.func_72798_a(p_72803_1_, p_72803_2_, p_72803_3_);
        if (n == 0) {
            return Material.field_76249_a;
        }
        return Block.field_71973_m[n].field_72018_cp;
    }

    @Override
    public int func_72805_g(int p_72805_1_, int p_72805_2_, int p_72805_3_) {
        if (p_72805_1_ < -30000000 || p_72805_3_ < -30000000 || p_72805_1_ >= 30000000 || p_72805_3_ >= 30000000) {
            return 0;
        }
        if (p_72805_2_ < 0) {
            return 0;
        }
        if (p_72805_2_ >= 256) {
            return 0;
        }
        Chunk chunk = this.func_72964_e(p_72805_1_ >> 4, p_72805_3_ >> 4);
        return chunk.func_76628_c(p_72805_1_ &= 0xF, p_72805_2_, p_72805_3_ &= 0xF);
    }

    public boolean func_72921_c(int p_72921_1_, int p_72921_2_, int p_72921_3_, int p_72921_4_, int p_72921_5_) {
        int n;
        int n2;
        if (p_72921_1_ < -30000000 || p_72921_3_ < -30000000 || p_72921_1_ >= 30000000 || p_72921_3_ >= 30000000) {
            return false;
        }
        if (p_72921_2_ < 0) {
            return false;
        }
        if (p_72921_2_ >= 256) {
            return false;
        }
        Chunk chunk = this.func_72964_e(p_72921_1_ >> 4, p_72921_3_ >> 4);
        boolean bl = chunk.func_76589_b(n2 = p_72921_1_ & 0xF, p_72921_2_, n = p_72921_3_ & 0xF, p_72921_4_);
        if (bl) {
            int n3 = chunk.func_76610_a(n2, p_72921_2_, n);
            if (!((p_72921_5_ & 2) == 0 || this.field_72995_K && (p_72921_5_ & 4) != 0)) {
                this.func_72845_h(p_72921_1_, p_72921_2_, p_72921_3_);
            }
            if (!this.field_72995_K && (p_72921_5_ & 1) != 0) {
                this.func_72851_f(p_72921_1_, p_72921_2_, p_72921_3_, n3);
                Block block = Block.field_71973_m[n3];
                if (block != null && block.func_96468_q_()) {
                    this.func_96440_m(p_72921_1_, p_72921_2_, p_72921_3_, n3);
                }
            }
        }
        return bl;
    }

    public boolean func_94571_i(int p_94571_1_, int p_94571_2_, int p_94571_3_) {
        return this.func_72832_d(p_94571_1_, p_94571_2_, p_94571_3_, 0, 0, 3);
    }

    public boolean func_94578_a(int p_94578_1_, int p_94578_2_, int p_94578_3_, boolean p_94578_4_) {
        int n = this.func_72798_a(p_94578_1_, p_94578_2_, p_94578_3_);
        if (n > 0) {
            int n2 = this.func_72805_g(p_94578_1_, p_94578_2_, p_94578_3_);
            this.func_72926_e(2001, p_94578_1_, p_94578_2_, p_94578_3_, n + (n2 << 12));
            if (p_94578_4_) {
                Block.field_71973_m[n].func_71897_c(this, p_94578_1_, p_94578_2_, p_94578_3_, n2, 0);
            }
            return this.func_72832_d(p_94578_1_, p_94578_2_, p_94578_3_, 0, 0, 3);
        }
        return false;
    }

    public boolean func_94575_c(int p_94575_1_, int p_94575_2_, int p_94575_3_, int p_94575_4_) {
        return this.func_72832_d(p_94575_1_, p_94575_2_, p_94575_3_, p_94575_4_, 0, 3);
    }

    public void func_72845_h(int p_72845_1_, int p_72845_2_, int p_72845_3_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72710_a(p_72845_1_, p_72845_2_, p_72845_3_);
        }
    }

    public void func_72851_f(int p_72851_1_, int p_72851_2_, int p_72851_3_, int p_72851_4_) {
        this.func_72898_h(p_72851_1_, p_72851_2_, p_72851_3_, p_72851_4_);
    }

    public void func_72975_g(int p_72975_1_, int p_72975_2_, int p_72975_3_, int p_72975_4_) {
        int n;
        if (p_72975_3_ > p_72975_4_) {
            n = p_72975_4_;
            p_72975_4_ = p_72975_3_;
            p_72975_3_ = n;
        }
        if (!this.field_73011_w.field_76576_e) {
            for (n = p_72975_3_; n <= p_72975_4_; ++n) {
                this.func_72936_c(EnumSkyBlock.Sky, p_72975_1_, n, p_72975_2_);
            }
        }
        this.func_72909_d(p_72975_1_, p_72975_3_, p_72975_2_, p_72975_1_, p_72975_4_, p_72975_2_);
    }

    public void func_72909_d(int p_72909_1_, int p_72909_2_, int p_72909_3_, int p_72909_4_, int p_72909_5_, int p_72909_6_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72707_a(p_72909_1_, p_72909_2_, p_72909_3_, p_72909_4_, p_72909_5_, p_72909_6_);
        }
    }

    public void func_72898_h(int p_72898_1_, int p_72898_2_, int p_72898_3_, int p_72898_4_) {
        this.func_72821_m(p_72898_1_ - 1, p_72898_2_, p_72898_3_, p_72898_4_);
        this.func_72821_m(p_72898_1_ + 1, p_72898_2_, p_72898_3_, p_72898_4_);
        this.func_72821_m(p_72898_1_, p_72898_2_ - 1, p_72898_3_, p_72898_4_);
        this.func_72821_m(p_72898_1_, p_72898_2_ + 1, p_72898_3_, p_72898_4_);
        this.func_72821_m(p_72898_1_, p_72898_2_, p_72898_3_ - 1, p_72898_4_);
        this.func_72821_m(p_72898_1_, p_72898_2_, p_72898_3_ + 1, p_72898_4_);
    }

    public void func_96439_d(int p_96439_1_, int p_96439_2_, int p_96439_3_, int p_96439_4_, int p_96439_5_) {
        if (p_96439_5_ != 4) {
            this.func_72821_m(p_96439_1_ - 1, p_96439_2_, p_96439_3_, p_96439_4_);
        }
        if (p_96439_5_ != 5) {
            this.func_72821_m(p_96439_1_ + 1, p_96439_2_, p_96439_3_, p_96439_4_);
        }
        if (p_96439_5_ != 0) {
            this.func_72821_m(p_96439_1_, p_96439_2_ - 1, p_96439_3_, p_96439_4_);
        }
        if (p_96439_5_ != 1) {
            this.func_72821_m(p_96439_1_, p_96439_2_ + 1, p_96439_3_, p_96439_4_);
        }
        if (p_96439_5_ != 2) {
            this.func_72821_m(p_96439_1_, p_96439_2_, p_96439_3_ - 1, p_96439_4_);
        }
        if (p_96439_5_ != 3) {
            this.func_72821_m(p_96439_1_, p_96439_2_, p_96439_3_ + 1, p_96439_4_);
        }
    }

    public void func_72821_m(int p_72821_1_, int p_72821_2_, int p_72821_3_, int p_72821_4_) {
        if (this.field_72995_K) {
            return;
        }
        int n = this.func_72798_a(p_72821_1_, p_72821_2_, p_72821_3_);
        Block block = Block.field_71973_m[n];
        if (block != null) {
            try {
                block.func_71863_a(this, p_72821_1_, p_72821_2_, p_72821_3_, p_72821_4_);
            }
            catch (Throwable throwable) {
                int n2;
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception while updating neighbours");
                CrashReportCategory crashReportCategory = crashReport.func_85058_a("Block being updated");
                try {
                    n2 = this.func_72805_g(p_72821_1_, p_72821_2_, p_72821_3_);
                }
                catch (Throwable throwable2) {
                    n2 = -1;
                }
                crashReportCategory.func_71500_a("Source block type", new CallableLvl1(this, p_72821_4_));
                CrashReportCategory.func_85068_a(crashReportCategory, p_72821_1_, p_72821_2_, p_72821_3_, n, n2);
                throw new ReportedException(crashReport);
            }
        }
    }

    public boolean func_94573_a(int p_94573_1_, int p_94573_2_, int p_94573_3_, int p_94573_4_) {
        return false;
    }

    public boolean func_72937_j(int p_72937_1_, int p_72937_2_, int p_72937_3_) {
        return this.func_72964_e(p_72937_1_ >> 4, p_72937_3_ >> 4).func_76619_d(p_72937_1_ & 0xF, p_72937_2_, p_72937_3_ & 0xF);
    }

    public int func_72883_k(int p_72883_1_, int p_72883_2_, int p_72883_3_) {
        if (p_72883_2_ < 0) {
            return 0;
        }
        if (p_72883_2_ >= 256) {
            p_72883_2_ = 255;
        }
        return this.func_72964_e(p_72883_1_ >> 4, p_72883_3_ >> 4).func_76629_c(p_72883_1_ & 0xF, p_72883_2_, p_72883_3_ & 0xF, 0);
    }

    public int func_72957_l(int p_72957_1_, int p_72957_2_, int p_72957_3_) {
        return this.func_72849_a(p_72957_1_, p_72957_2_, p_72957_3_, true);
    }

    public int func_72849_a(int p_72849_1_, int p_72849_2_, int p_72849_3_, boolean p_72849_4_) {
        int n;
        if (p_72849_1_ < -30000000 || p_72849_3_ < -30000000 || p_72849_1_ >= 30000000 || p_72849_3_ >= 30000000) {
            return 15;
        }
        if (p_72849_4_ && Block.field_71982_s[n = this.func_72798_a(p_72849_1_, p_72849_2_, p_72849_3_)]) {
            int n2 = this.func_72849_a(p_72849_1_, p_72849_2_ + 1, p_72849_3_, false);
            int n3 = this.func_72849_a(p_72849_1_ + 1, p_72849_2_, p_72849_3_, false);
            int n4 = this.func_72849_a(p_72849_1_ - 1, p_72849_2_, p_72849_3_, false);
            int n5 = this.func_72849_a(p_72849_1_, p_72849_2_, p_72849_3_ + 1, false);
            int n6 = this.func_72849_a(p_72849_1_, p_72849_2_, p_72849_3_ - 1, false);
            if (n3 > n2) {
                n2 = n3;
            }
            if (n4 > n2) {
                n2 = n4;
            }
            if (n5 > n2) {
                n2 = n5;
            }
            if (n6 > n2) {
                n2 = n6;
            }
            return n2;
        }
        if (p_72849_2_ < 0) {
            return 0;
        }
        if (p_72849_2_ >= 256) {
            p_72849_2_ = 255;
        }
        Chunk chunk = this.func_72964_e(p_72849_1_ >> 4, p_72849_3_ >> 4);
        return chunk.func_76629_c(p_72849_1_ &= 0xF, p_72849_2_, p_72849_3_ &= 0xF, this.field_73008_k);
    }

    public int func_72976_f(int p_72976_1_, int p_72976_2_) {
        if (p_72976_1_ < -30000000 || p_72976_2_ < -30000000 || p_72976_1_ >= 30000000 || p_72976_2_ >= 30000000) {
            return 0;
        }
        if (!this.func_72916_c(p_72976_1_ >> 4, p_72976_2_ >> 4)) {
            return 0;
        }
        Chunk chunk = this.func_72964_e(p_72976_1_ >> 4, p_72976_2_ >> 4);
        return chunk.func_76611_b(p_72976_1_ & 0xF, p_72976_2_ & 0xF);
    }

    public int func_82734_g(int p_82734_1_, int p_82734_2_) {
        if (p_82734_1_ < -30000000 || p_82734_2_ < -30000000 || p_82734_1_ >= 30000000 || p_82734_2_ >= 30000000) {
            return 0;
        }
        if (!this.func_72916_c(p_82734_1_ >> 4, p_82734_2_ >> 4)) {
            return 0;
        }
        Chunk chunk = this.func_72964_e(p_82734_1_ >> 4, p_82734_2_ >> 4);
        return chunk.field_82912_p;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72925_a(EnumSkyBlock p_72925_1_, int p_72925_2_, int p_72925_3_, int p_72925_4_) {
        if (this.field_73011_w.field_76576_e && p_72925_1_ == EnumSkyBlock.Sky) {
            return 0;
        }
        if (p_72925_3_ < 0) {
            p_72925_3_ = 0;
        }
        if (p_72925_3_ >= 256) {
            return p_72925_1_.field_77198_c;
        }
        if (p_72925_2_ < -30000000 || p_72925_4_ < -30000000 || p_72925_2_ >= 30000000 || p_72925_4_ >= 30000000) {
            return p_72925_1_.field_77198_c;
        }
        int n = p_72925_2_ >> 4;
        int n2 = p_72925_4_ >> 4;
        if (!this.func_72916_c(n, n2)) {
            return p_72925_1_.field_77198_c;
        }
        if (Block.field_71982_s[this.func_72798_a(p_72925_2_, p_72925_3_, p_72925_4_)]) {
            int n3 = this.func_72972_b(p_72925_1_, p_72925_2_, p_72925_3_ + 1, p_72925_4_);
            int n4 = this.func_72972_b(p_72925_1_, p_72925_2_ + 1, p_72925_3_, p_72925_4_);
            int n5 = this.func_72972_b(p_72925_1_, p_72925_2_ - 1, p_72925_3_, p_72925_4_);
            int n6 = this.func_72972_b(p_72925_1_, p_72925_2_, p_72925_3_, p_72925_4_ + 1);
            int n7 = this.func_72972_b(p_72925_1_, p_72925_2_, p_72925_3_, p_72925_4_ - 1);
            if (n4 > n3) {
                n3 = n4;
            }
            if (n5 > n3) {
                n3 = n5;
            }
            if (n6 > n3) {
                n3 = n6;
            }
            if (n7 > n3) {
                n3 = n7;
            }
            return n3;
        }
        Chunk chunk = this.func_72964_e(n, n2);
        return chunk.func_76614_a(p_72925_1_, p_72925_2_ & 0xF, p_72925_3_, p_72925_4_ & 0xF);
    }

    public int func_72972_b(EnumSkyBlock p_72972_1_, int p_72972_2_, int p_72972_3_, int p_72972_4_) {
        if (p_72972_3_ < 0) {
            p_72972_3_ = 0;
        }
        if (p_72972_3_ >= 256) {
            p_72972_3_ = 255;
        }
        if (p_72972_2_ < -30000000 || p_72972_4_ < -30000000 || p_72972_2_ >= 30000000 || p_72972_4_ >= 30000000) {
            return p_72972_1_.field_77198_c;
        }
        int n = p_72972_2_ >> 4;
        int n2 = p_72972_4_ >> 4;
        if (!this.func_72916_c(n, n2)) {
            return p_72972_1_.field_77198_c;
        }
        Chunk chunk = this.func_72964_e(n, n2);
        return chunk.func_76614_a(p_72972_1_, p_72972_2_ & 0xF, p_72972_3_, p_72972_4_ & 0xF);
    }

    public void func_72915_b(EnumSkyBlock p_72915_1_, int p_72915_2_, int p_72915_3_, int p_72915_4_, int p_72915_5_) {
        if (p_72915_2_ < -30000000 || p_72915_4_ < -30000000 || p_72915_2_ >= 30000000 || p_72915_4_ >= 30000000) {
            return;
        }
        if (p_72915_3_ < 0) {
            return;
        }
        if (p_72915_3_ >= 256) {
            return;
        }
        if (!this.func_72916_c(p_72915_2_ >> 4, p_72915_4_ >> 4)) {
            return;
        }
        Chunk chunk = this.func_72964_e(p_72915_2_ >> 4, p_72915_4_ >> 4);
        chunk.func_76633_a(p_72915_1_, p_72915_2_ & 0xF, p_72915_3_, p_72915_4_ & 0xF, p_72915_5_);
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72711_b(p_72915_2_, p_72915_3_, p_72915_4_);
        }
    }

    public void func_72902_n(int p_72902_1_, int p_72902_2_, int p_72902_3_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72711_b(p_72902_1_, p_72902_2_, p_72902_3_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        int n = this.func_72925_a(EnumSkyBlock.Sky, p_72802_1_, p_72802_2_, p_72802_3_);
        int n2 = this.func_72925_a(EnumSkyBlock.Block, p_72802_1_, p_72802_2_, p_72802_3_);
        if (n2 < p_72802_4_) {
            n2 = p_72802_4_;
        }
        return n << 20 | n2 << 4;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float func_72808_j(int p_72808_1_, int p_72808_2_, int p_72808_3_, int p_72808_4_) {
        int n = this.func_72957_l(p_72808_1_, p_72808_2_, p_72808_3_);
        if (n < p_72808_4_) {
            n = p_72808_4_;
        }
        return this.field_73011_w.field_76573_f[n];
    }

    @Override
    public float func_72801_o(int p_72801_1_, int p_72801_2_, int p_72801_3_) {
        return this.field_73011_w.field_76573_f[this.func_72957_l(p_72801_1_, p_72801_2_, p_72801_3_)];
    }

    public boolean func_72935_r() {
        return this.field_73008_k < 4;
    }

    public MovingObjectPosition func_72933_a(Vec3 p_72933_1_, Vec3 p_72933_2_) {
        return this.func_72831_a(p_72933_1_, p_72933_2_, false, false);
    }

    public MovingObjectPosition func_72901_a(Vec3 p_72901_1_, Vec3 p_72901_2_, boolean p_72901_3_) {
        return this.func_72831_a(p_72901_1_, p_72901_2_, p_72901_3_, false);
    }

    public MovingObjectPosition func_72831_a(Vec3 p_72831_1_, Vec3 p_72831_2_, boolean p_72831_3_, boolean p_72831_4_) {
        MovingObjectPosition movingObjectPosition;
        if (Double.isNaN(p_72831_1_.field_72450_a) || Double.isNaN(p_72831_1_.field_72448_b) || Double.isNaN(p_72831_1_.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(p_72831_2_.field_72450_a) || Double.isNaN(p_72831_2_.field_72448_b) || Double.isNaN(p_72831_2_.field_72449_c)) {
            return null;
        }
        int n = MathHelper.func_76128_c(p_72831_2_.field_72450_a);
        int n2 = MathHelper.func_76128_c(p_72831_2_.field_72448_b);
        int n3 = MathHelper.func_76128_c(p_72831_2_.field_72449_c);
        int n4 = MathHelper.func_76128_c(p_72831_1_.field_72450_a);
        int n5 = MathHelper.func_76128_c(p_72831_1_.field_72448_b);
        int n6 = MathHelper.func_76128_c(p_72831_1_.field_72449_c);
        int n7 = this.func_72798_a(n4, n5, n6);
        int n8 = this.func_72805_g(n4, n5, n6);
        Block block = Block.field_71973_m[n7];
        if ((!p_72831_4_ || block == null || block.func_71872_e(this, n4, n5, n6) != null) && n7 > 0 && block.func_71913_a(n8, p_72831_3_) && (movingObjectPosition = block.func_71878_a(this, n4, n5, n6, p_72831_1_, p_72831_2_)) != null) {
            return movingObjectPosition;
        }
        n7 = 200;
        while (n7-- >= 0) {
            MovingObjectPosition movingObjectPosition2;
            if (Double.isNaN(p_72831_1_.field_72450_a) || Double.isNaN(p_72831_1_.field_72448_b) || Double.isNaN(p_72831_1_.field_72449_c)) {
                return null;
            }
            if (n4 == n && n5 == n2 && n6 == n3) {
                return null;
            }
            n8 = 1;
            boolean bl = true;
            boolean bl2 = true;
            double d = 999.0;
            double d2 = 999.0;
            double d3 = 999.0;
            if (n > n4) {
                d = (double)n4 + 1.0;
            } else if (n < n4) {
                d = (double)n4 + 0.0;
            } else {
                n8 = 0;
            }
            if (n2 > n5) {
                d2 = (double)n5 + 1.0;
            } else if (n2 < n5) {
                d2 = (double)n5 + 0.0;
            } else {
                bl = false;
            }
            if (n3 > n6) {
                d3 = (double)n6 + 1.0;
            } else if (n3 < n6) {
                d3 = (double)n6 + 0.0;
            } else {
                bl2 = false;
            }
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = 999.0;
            double d7 = p_72831_2_.field_72450_a - p_72831_1_.field_72450_a;
            double d8 = p_72831_2_.field_72448_b - p_72831_1_.field_72448_b;
            double d9 = p_72831_2_.field_72449_c - p_72831_1_.field_72449_c;
            if (n8 != 0) {
                d4 = (d - p_72831_1_.field_72450_a) / d7;
            }
            if (bl) {
                d5 = (d2 - p_72831_1_.field_72448_b) / d8;
            }
            if (bl2) {
                d6 = (d3 - p_72831_1_.field_72449_c) / d9;
            }
            int n9 = 0;
            if (d4 < d5 && d4 < d6) {
                n9 = n > n4 ? 4 : 5;
                p_72831_1_.field_72450_a = d;
                p_72831_1_.field_72448_b += d8 * d4;
                p_72831_1_.field_72449_c += d9 * d4;
            } else if (d5 < d6) {
                n9 = n2 > n5 ? 0 : 1;
                p_72831_1_.field_72450_a += d7 * d5;
                p_72831_1_.field_72448_b = d2;
                p_72831_1_.field_72449_c += d9 * d5;
            } else {
                n9 = n3 > n6 ? 2 : 3;
                p_72831_1_.field_72450_a += d7 * d6;
                p_72831_1_.field_72448_b += d8 * d6;
                p_72831_1_.field_72449_c = d3;
            }
            Vec3 vec3 = this.func_82732_R().func_72345_a(p_72831_1_.field_72450_a, p_72831_1_.field_72448_b, p_72831_1_.field_72449_c);
            vec3.field_72450_a = MathHelper.func_76128_c(p_72831_1_.field_72450_a);
            n4 = (int)vec3.field_72450_a;
            if (n9 == 5) {
                --n4;
                vec3.field_72450_a += 1.0;
            }
            vec3.field_72448_b = MathHelper.func_76128_c(p_72831_1_.field_72448_b);
            n5 = (int)vec3.field_72448_b;
            if (n9 == 1) {
                --n5;
                vec3.field_72448_b += 1.0;
            }
            vec3.field_72449_c = MathHelper.func_76128_c(p_72831_1_.field_72449_c);
            n6 = (int)vec3.field_72449_c;
            if (n9 == 3) {
                --n6;
                vec3.field_72449_c += 1.0;
            }
            int n10 = this.func_72798_a(n4, n5, n6);
            int n11 = this.func_72805_g(n4, n5, n6);
            Block block2 = Block.field_71973_m[n10];
            if (p_72831_4_ && block2 != null && block2.func_71872_e(this, n4, n5, n6) == null || n10 <= 0 || !block2.func_71913_a(n11, p_72831_3_) || (movingObjectPosition2 = block2.func_71878_a(this, n4, n5, n6, p_72831_1_, p_72831_2_)) == null) continue;
            return movingObjectPosition2;
        }
        return null;
    }

    public void func_72956_a(Entity p_72956_1_, String p_72956_2_, float p_72956_3_, float p_72956_4_) {
        if (p_72956_1_ == null || p_72956_2_ == null) {
            return;
        }
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72704_a(p_72956_2_, p_72956_1_.field_70165_t, p_72956_1_.field_70163_u - (double)p_72956_1_.field_70129_M, p_72956_1_.field_70161_v, p_72956_3_, p_72956_4_);
        }
    }

    public void func_85173_a(EntityPlayer p_85173_1_, String p_85173_2_, float p_85173_3_, float p_85173_4_) {
        if (p_85173_1_ == null || p_85173_2_ == null) {
            return;
        }
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_85102_a(p_85173_1_, p_85173_2_, p_85173_1_.field_70165_t, p_85173_1_.field_70163_u - (double)p_85173_1_.field_70129_M, p_85173_1_.field_70161_v, p_85173_3_, p_85173_4_);
        }
    }

    public void func_72908_a(double p_72908_1_, double p_72908_3_, double p_72908_5_, String p_72908_7_, float p_72908_8_, float p_72908_9_) {
        if (p_72908_7_ == null) {
            return;
        }
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72704_a(p_72908_7_, p_72908_1_, p_72908_3_, p_72908_5_, p_72908_8_, p_72908_9_);
        }
    }

    public void func_72980_b(double p_72980_1_, double p_72980_3_, double p_72980_5_, String p_72980_7_, float p_72980_8_, float p_72980_9_, boolean p_72980_10_) {
    }

    public void func_72934_a(String p_72934_1_, int p_72934_2_, int p_72934_3_, int p_72934_4_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72702_a(p_72934_1_, p_72934_2_, p_72934_3_, p_72934_4_);
        }
    }

    public void func_72869_a(String p_72869_1_, double p_72869_2_, double p_72869_4_, double p_72869_6_, double p_72869_8_, double p_72869_10_, double p_72869_12_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72708_a(p_72869_1_, p_72869_2_, p_72869_4_, p_72869_6_, p_72869_8_, p_72869_10_, p_72869_12_);
        }
    }

    public boolean func_72942_c(Entity p_72942_1_) {
        this.field_73007_j.add(p_72942_1_);
        return true;
    }

    public boolean func_72838_d(Entity p_72838_1_) {
        int n = MathHelper.func_76128_c(p_72838_1_.field_70165_t / 16.0);
        int n2 = MathHelper.func_76128_c(p_72838_1_.field_70161_v / 16.0);
        boolean bl = p_72838_1_.field_98038_p;
        if (p_72838_1_ instanceof EntityPlayer) {
            bl = true;
        }
        if (bl || this.func_72916_c(n, n2)) {
            if (p_72838_1_ instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)p_72838_1_;
                this.field_73010_i.add(entityPlayer);
                this.func_72854_c();
            }
            this.func_72964_e(n, n2).func_76612_a(p_72838_1_);
            this.field_72996_f.add(p_72838_1_);
            this.func_72923_a(p_72838_1_);
            return true;
        }
        return false;
    }

    protected void func_72923_a(Entity p_72923_1_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72703_a(p_72923_1_);
        }
    }

    public void func_72847_b(Entity p_72847_1_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72709_b(p_72847_1_);
        }
    }

    public void func_72900_e(Entity p_72900_1_) {
        if (p_72900_1_.field_70153_n != null) {
            p_72900_1_.field_70153_n.func_70078_a(null);
        }
        if (p_72900_1_.field_70154_o != null) {
            p_72900_1_.func_70078_a(null);
        }
        p_72900_1_.func_70106_y();
        if (p_72900_1_ instanceof EntityPlayer) {
            this.field_73010_i.remove(p_72900_1_);
            this.func_72854_c();
        }
    }

    public void func_72973_f(Entity p_72973_1_) {
        p_72973_1_.func_70106_y();
        if (p_72973_1_ instanceof EntityPlayer) {
            this.field_73010_i.remove(p_72973_1_);
            this.func_72854_c();
        }
        int n = p_72973_1_.field_70176_ah;
        int n2 = p_72973_1_.field_70164_aj;
        if (p_72973_1_.field_70175_ag && this.func_72916_c(n, n2)) {
            this.func_72964_e(n, n2).func_76622_b(p_72973_1_);
        }
        this.field_72996_f.remove(p_72973_1_);
        this.func_72847_b(p_72973_1_);
    }

    public void func_72954_a(IWorldAccess p_72954_1_) {
        this.field_73021_x.add(p_72954_1_);
    }

    public List func_72945_a(Entity p_72945_1_, AxisAlignedBB p_72945_2_) {
        this.field_72998_d.clear();
        int n = MathHelper.func_76128_c(p_72945_2_.field_72340_a);
        int n2 = MathHelper.func_76128_c(p_72945_2_.field_72336_d + 1.0);
        int n3 = MathHelper.func_76128_c(p_72945_2_.field_72338_b);
        int n4 = MathHelper.func_76128_c(p_72945_2_.field_72337_e + 1.0);
        int n5 = MathHelper.func_76128_c(p_72945_2_.field_72339_c);
        int n6 = MathHelper.func_76128_c(p_72945_2_.field_72334_f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.func_72899_e(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.field_71973_m[this.func_72798_a(i, k, j)];
                    if (block == null) continue;
                    block.func_71871_a(this, i, k, j, p_72945_2_, this.field_72998_d, p_72945_1_);
                }
            }
        }
        double d = 0.25;
        List list = this.func_72839_b(p_72945_1_, p_72945_2_.func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisAlignedBB = ((Entity)list.get(i)).func_70046_E();
            if (axisAlignedBB != null && axisAlignedBB.func_72326_a(p_72945_2_)) {
                this.field_72998_d.add(axisAlignedBB);
            }
            if ((axisAlignedBB = p_72945_1_.func_70114_g((Entity)list.get(i))) == null || !axisAlignedBB.func_72326_a(p_72945_2_)) continue;
            this.field_72998_d.add(axisAlignedBB);
        }
        return this.field_72998_d;
    }

    public List func_72840_a(AxisAlignedBB p_72840_1_) {
        this.field_72998_d.clear();
        int n = MathHelper.func_76128_c(p_72840_1_.field_72340_a);
        int n2 = MathHelper.func_76128_c(p_72840_1_.field_72336_d + 1.0);
        int n3 = MathHelper.func_76128_c(p_72840_1_.field_72338_b);
        int n4 = MathHelper.func_76128_c(p_72840_1_.field_72337_e + 1.0);
        int n5 = MathHelper.func_76128_c(p_72840_1_.field_72339_c);
        int n6 = MathHelper.func_76128_c(p_72840_1_.field_72334_f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.func_72899_e(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.field_71973_m[this.func_72798_a(i, k, j)];
                    if (block == null) continue;
                    block.func_71871_a(this, i, k, j, p_72840_1_, this.field_72998_d, null);
                }
            }
        }
        return this.field_72998_d;
    }

    public int func_72967_a(float p_72967_1_) {
        float f = this.func_72826_c(p_72967_1_);
        float f2 = 1.0f - (MathHelper.func_76134_b(f * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72867_j(p_72967_1_) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72819_i(p_72967_1_) * 5.0f) / 16.0));
        f2 = 1.0f - f2;
        return (int)(f2 * 11.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72848_b(IWorldAccess p_72848_1_) {
        this.field_73021_x.remove(p_72848_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_72971_b(float p_72971_1_) {
        float f = this.func_72826_c(p_72971_1_);
        float f2 = 1.0f - (MathHelper.func_76134_b(f * (float)Math.PI * 2.0f) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72867_j(p_72971_1_) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72819_i(p_72971_1_) * 5.0f) / 16.0));
        return f2 * 0.8f + 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_72833_a(Entity p_72833_1_, float p_72833_2_) {
        float f;
        float f2;
        float f3 = this.func_72826_c(p_72833_2_);
        float f4 = MathHelper.func_76134_b(f3 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        int n = MathHelper.func_76128_c(p_72833_1_.field_70165_t);
        int n2 = MathHelper.func_76128_c(p_72833_1_.field_70161_v);
        BiomeGenBase biomeGenBase = this.func_72807_a(n, n2);
        float f5 = biomeGenBase.func_76743_j();
        int n3 = biomeGenBase.func_76731_a(f5);
        float f6 = (float)(n3 >> 16 & 0xFF) / 255.0f;
        float f7 = (float)(n3 >> 8 & 0xFF) / 255.0f;
        float f8 = (float)(n3 & 0xFF) / 255.0f;
        f6 *= f4;
        f7 *= f4;
        f8 *= f4;
        float f9 = this.func_72867_j(p_72833_2_);
        if (f9 > 0.0f) {
            f2 = (f6 * 0.3f + f7 * 0.59f + f8 * 0.11f) * 0.6f;
            f = 1.0f - f9 * 0.75f;
            f6 = f6 * f + f2 * (1.0f - f);
            f7 = f7 * f + f2 * (1.0f - f);
            f8 = f8 * f + f2 * (1.0f - f);
        }
        if ((f2 = this.func_72819_i(p_72833_2_)) > 0.0f) {
            f = (f6 * 0.3f + f7 * 0.59f + f8 * 0.11f) * 0.2f;
            float f10 = 1.0f - f2 * 0.75f;
            f6 = f6 * f10 + f * (1.0f - f10);
            f7 = f7 * f10 + f * (1.0f - f10);
            f8 = f8 * f10 + f * (1.0f - f10);
        }
        if (this.field_73016_r > 0) {
            f = (float)this.field_73016_r - p_72833_2_;
            if (f > 1.0f) {
                f = 1.0f;
            }
            f6 = f6 * (1.0f - (f *= 0.45f)) + 0.8f * f;
            f7 = f7 * (1.0f - f) + 0.8f * f;
            f8 = f8 * (1.0f - f) + 1.0f * f;
        }
        return this.func_82732_R().func_72345_a(f6, f7, f8);
    }

    public float func_72826_c(float p_72826_1_) {
        return this.field_73011_w.func_76563_a(this.field_72986_A.func_76073_f(), p_72826_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72853_d() {
        return this.field_73011_w.func_76559_b(this.field_72986_A.func_76073_f());
    }

    public float func_130001_d() {
        return WorldProvider.field_111203_a[this.field_73011_w.func_76559_b(this.field_72986_A.func_76073_f())];
    }

    public float func_72929_e(float p_72929_1_) {
        float f = this.func_72826_c(p_72929_1_);
        return f * (float)Math.PI * 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_72824_f(float p_72824_1_) {
        float f;
        float f2;
        float f3 = this.func_72826_c(p_72824_1_);
        float f4 = MathHelper.func_76134_b(f3 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        float f5 = (float)(this.field_73001_c >> 16 & 0xFFL) / 255.0f;
        float f6 = (float)(this.field_73001_c >> 8 & 0xFFL) / 255.0f;
        float f7 = (float)(this.field_73001_c & 0xFFL) / 255.0f;
        float f8 = this.func_72867_j(p_72824_1_);
        if (f8 > 0.0f) {
            f2 = (f5 * 0.3f + f6 * 0.59f + f7 * 0.11f) * 0.6f;
            f = 1.0f - f8 * 0.95f;
            f5 = f5 * f + f2 * (1.0f - f);
            f6 = f6 * f + f2 * (1.0f - f);
            f7 = f7 * f + f2 * (1.0f - f);
        }
        f5 *= f4 * 0.9f + 0.1f;
        f6 *= f4 * 0.9f + 0.1f;
        f7 *= f4 * 0.85f + 0.15f;
        f2 = this.func_72819_i(p_72824_1_);
        if (f2 > 0.0f) {
            f = (f5 * 0.3f + f6 * 0.59f + f7 * 0.11f) * 0.2f;
            float f9 = 1.0f - f2 * 0.95f;
            f5 = f5 * f9 + f * (1.0f - f9);
            f6 = f6 * f9 + f * (1.0f - f9);
            f7 = f7 * f9 + f * (1.0f - f9);
        }
        return this.func_82732_R().func_72345_a(f5, f6, f7);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_72948_g(float p_72948_1_) {
        float f = this.func_72826_c(p_72948_1_);
        return this.field_73011_w.func_76562_b(f, p_72948_1_);
    }

    public int func_72874_g(int p_72874_1_, int p_72874_2_) {
        return this.func_72938_d(p_72874_1_, p_72874_2_).func_76626_d(p_72874_1_ & 0xF, p_72874_2_ & 0xF);
    }

    public int func_72825_h(int p_72825_1_, int p_72825_2_) {
        Chunk chunk = this.func_72938_d(p_72825_1_, p_72825_2_);
        p_72825_1_ &= 0xF;
        p_72825_2_ &= 0xF;
        for (int i = chunk.func_76625_h() + 15; i > 0; --i) {
            int n = chunk.func_76610_a(p_72825_1_, i, p_72825_2_);
            if (n == 0 || !Block.field_71973_m[n].field_72018_cp.func_76230_c() || Block.field_71973_m[n].field_72018_cp == Material.field_76257_i) {
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_72880_h(float p_72880_1_) {
        float f = this.func_72826_c(p_72880_1_);
        float f2 = 1.0f - (MathHelper.func_76134_b(f * (float)Math.PI * 2.0f) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.5f;
    }

    public void func_72836_a(int p_72836_1_, int p_72836_2_, int p_72836_3_, int p_72836_4_, int p_72836_5_) {
    }

    public void func_82740_a(int p_82740_1_, int p_82740_2_, int p_82740_3_, int p_82740_4_, int p_82740_5_, int p_82740_6_) {
    }

    public void func_72892_b(int p_72892_1_, int p_72892_2_, int p_72892_3_, int p_72892_4_, int p_72892_5_, int p_72892_6_) {
    }

    public void func_72939_s() {
        int n;
        int n2;
        Object object;
        int n3;
        this.field_72984_F.func_76320_a("entities");
        this.field_72984_F.func_76320_a("global");
        for (n3 = 0; n3 < this.field_73007_j.size(); ++n3) {
            object = (Entity)this.field_73007_j.get(n3);
            try {
                ++((Entity)object).field_70173_aa;
                ((Entity)object).func_70071_h_();
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking entity");
                CrashReportCategory crashReportCategory = crashReport.func_85058_a("Entity being ticked");
                if (object == null) {
                    crashReportCategory.func_71507_a("Entity", "~~NULL~~");
                } else {
                    ((Entity)object).func_85029_a(crashReportCategory);
                }
                throw new ReportedException(crashReport);
            }
            if (!((Entity)object).field_70128_L) continue;
            this.field_73007_j.remove(n3--);
        }
        this.field_72984_F.func_76318_c("remove");
        this.field_72996_f.removeAll(this.field_72997_g);
        for (n3 = 0; n3 < this.field_72997_g.size(); ++n3) {
            object = (Entity)this.field_72997_g.get(n3);
            n2 = ((Entity)object).field_70176_ah;
            n = ((Entity)object).field_70164_aj;
            if (!((Entity)object).field_70175_ag || !this.func_72916_c(n2, n)) continue;
            this.func_72964_e(n2, n).func_76622_b((Entity)object);
        }
        for (n3 = 0; n3 < this.field_72997_g.size(); ++n3) {
            this.func_72847_b((Entity)this.field_72997_g.get(n3));
        }
        this.field_72997_g.clear();
        this.field_72984_F.func_76318_c("regular");
        for (n3 = 0; n3 < this.field_72996_f.size(); ++n3) {
            object = (Entity)this.field_72996_f.get(n3);
            if (((Entity)object).field_70154_o != null) {
                if (!((Entity)object).field_70154_o.field_70128_L && ((Entity)object).field_70154_o.field_70153_n == object) continue;
                ((Entity)object).field_70154_o.field_70153_n = null;
                ((Entity)object).field_70154_o = null;
            }
            this.field_72984_F.func_76320_a("tick");
            if (!((Entity)object).field_70128_L) {
                try {
                    this.func_72870_g((Entity)object);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking entity");
                    CrashReportCategory crashReportCategory = crashReport.func_85058_a("Entity being ticked");
                    ((Entity)object).func_85029_a(crashReportCategory);
                    throw new ReportedException(crashReport);
                }
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("remove");
            if (((Entity)object).field_70128_L) {
                n2 = ((Entity)object).field_70176_ah;
                n = ((Entity)object).field_70164_aj;
                if (((Entity)object).field_70175_ag && this.func_72916_c(n2, n)) {
                    this.func_72964_e(n2, n).func_76622_b((Entity)object);
                }
                this.field_72996_f.remove(n3--);
                this.func_72847_b((Entity)object);
            }
            this.field_72984_F.func_76319_b();
        }
        this.field_72984_F.func_76318_c("tileEntities");
        this.field_72989_L = true;
        Iterator iterator = this.field_73009_h.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            object = (TileEntity)iterator.next();
            if (!((TileEntity)object).func_70320_p() && ((TileEntity)object).func_70309_m() && this.func_72899_e(((TileEntity)object).field_70329_l, ((TileEntity)object).field_70330_m, ((TileEntity)object).field_70327_n)) {
                try {
                    ((TileEntity)object).func_70316_g();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking tile entity");
                    CrashReportCategory crashReportCategory = crashReport.func_85058_a("Tile entity being ticked");
                    ((TileEntity)object).func_85027_a(crashReportCategory);
                    throw new ReportedException(crashReport);
                }
            }
            if (!((TileEntity)object).func_70320_p()) continue;
            iterator.remove();
            if (!this.func_72916_c(((TileEntity)object).field_70329_l >> 4, ((TileEntity)object).field_70327_n >> 4) || (chunk = this.func_72964_e(((TileEntity)object).field_70329_l >> 4, ((TileEntity)object).field_70327_n >> 4)) == null) continue;
            chunk.func_76627_f(((TileEntity)object).field_70329_l & 0xF, ((TileEntity)object).field_70330_m, ((TileEntity)object).field_70327_n & 0xF);
        }
        this.field_72989_L = false;
        if (!this.field_73000_b.isEmpty()) {
            this.field_73009_h.removeAll(this.field_73000_b);
            this.field_73000_b.clear();
        }
        this.field_72984_F.func_76318_c("pendingTileEntities");
        if (!this.field_73002_a.isEmpty()) {
            for (int i = 0; i < this.field_73002_a.size(); ++i) {
                Chunk chunk;
                TileEntity tileEntity = (TileEntity)this.field_73002_a.get(i);
                if (tileEntity.func_70320_p()) continue;
                if (!this.field_73009_h.contains(tileEntity)) {
                    this.field_73009_h.add(tileEntity);
                }
                if (this.func_72916_c(tileEntity.field_70329_l >> 4, tileEntity.field_70327_n >> 4) && (chunk = this.func_72964_e(tileEntity.field_70329_l >> 4, tileEntity.field_70327_n >> 4)) != null) {
                    chunk.func_76604_a(tileEntity.field_70329_l & 0xF, tileEntity.field_70330_m, tileEntity.field_70327_n & 0xF, tileEntity);
                }
                this.func_72845_h(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
            }
            this.field_73002_a.clear();
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76319_b();
    }

    public void func_72852_a(Collection p_72852_1_) {
        if (this.field_72989_L) {
            this.field_73002_a.addAll(p_72852_1_);
        } else {
            this.field_73009_h.addAll(p_72852_1_);
        }
    }

    public void func_72870_g(Entity p_72870_1_) {
        this.func_72866_a(p_72870_1_, true);
    }

    public void func_72866_a(Entity p_72866_1_, boolean p_72866_2_) {
        int n = MathHelper.func_76128_c(p_72866_1_.field_70165_t);
        int n2 = MathHelper.func_76128_c(p_72866_1_.field_70161_v);
        int n3 = 32;
        if (p_72866_2_ && !this.func_72904_c(n - n3, 0, n2 - n3, n + n3, 0, n2 + n3)) {
            return;
        }
        p_72866_1_.field_70142_S = p_72866_1_.field_70165_t;
        p_72866_1_.field_70137_T = p_72866_1_.field_70163_u;
        p_72866_1_.field_70136_U = p_72866_1_.field_70161_v;
        p_72866_1_.field_70126_B = p_72866_1_.field_70177_z;
        p_72866_1_.field_70127_C = p_72866_1_.field_70125_A;
        if (p_72866_2_ && p_72866_1_.field_70175_ag) {
            ++p_72866_1_.field_70173_aa;
            if (p_72866_1_.field_70154_o != null) {
                p_72866_1_.func_70098_U();
            } else {
                p_72866_1_.func_70071_h_();
            }
        }
        this.field_72984_F.func_76320_a("chunkCheck");
        if (Double.isNaN(p_72866_1_.field_70165_t) || Double.isInfinite(p_72866_1_.field_70165_t)) {
            p_72866_1_.field_70165_t = p_72866_1_.field_70142_S;
        }
        if (Double.isNaN(p_72866_1_.field_70163_u) || Double.isInfinite(p_72866_1_.field_70163_u)) {
            p_72866_1_.field_70163_u = p_72866_1_.field_70137_T;
        }
        if (Double.isNaN(p_72866_1_.field_70161_v) || Double.isInfinite(p_72866_1_.field_70161_v)) {
            p_72866_1_.field_70161_v = p_72866_1_.field_70136_U;
        }
        if (Double.isNaN(p_72866_1_.field_70125_A) || Double.isInfinite(p_72866_1_.field_70125_A)) {
            p_72866_1_.field_70125_A = p_72866_1_.field_70127_C;
        }
        if (Double.isNaN(p_72866_1_.field_70177_z) || Double.isInfinite(p_72866_1_.field_70177_z)) {
            p_72866_1_.field_70177_z = p_72866_1_.field_70126_B;
        }
        int n4 = MathHelper.func_76128_c(p_72866_1_.field_70165_t / 16.0);
        int n5 = MathHelper.func_76128_c(p_72866_1_.field_70163_u / 16.0);
        int n6 = MathHelper.func_76128_c(p_72866_1_.field_70161_v / 16.0);
        if (!p_72866_1_.field_70175_ag || p_72866_1_.field_70176_ah != n4 || p_72866_1_.field_70162_ai != n5 || p_72866_1_.field_70164_aj != n6) {
            if (p_72866_1_.field_70175_ag && this.func_72916_c(p_72866_1_.field_70176_ah, p_72866_1_.field_70164_aj)) {
                this.func_72964_e(p_72866_1_.field_70176_ah, p_72866_1_.field_70164_aj).func_76608_a(p_72866_1_, p_72866_1_.field_70162_ai);
            }
            if (this.func_72916_c(n4, n6)) {
                p_72866_1_.field_70175_ag = true;
                this.func_72964_e(n4, n6).func_76612_a(p_72866_1_);
            } else {
                p_72866_1_.field_70175_ag = false;
            }
        }
        this.field_72984_F.func_76319_b();
        if (p_72866_2_ && p_72866_1_.field_70175_ag && p_72866_1_.field_70153_n != null) {
            if (p_72866_1_.field_70153_n.field_70128_L || p_72866_1_.field_70153_n.field_70154_o != p_72866_1_) {
                p_72866_1_.field_70153_n.field_70154_o = null;
                p_72866_1_.field_70153_n = null;
            } else {
                this.func_72870_g(p_72866_1_.field_70153_n);
            }
        }
    }

    public boolean func_72855_b(AxisAlignedBB p_72855_1_) {
        return this.func_72917_a(p_72855_1_, null);
    }

    public boolean func_72917_a(AxisAlignedBB p_72917_1_, Entity p_72917_2_) {
        List list = this.func_72839_b(null, p_72917_1_);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity.field_70128_L || !entity.field_70156_m || entity == p_72917_2_) continue;
            return false;
        }
        return true;
    }

    public boolean func_72829_c(AxisAlignedBB p_72829_1_) {
        int n = MathHelper.func_76128_c(p_72829_1_.field_72340_a);
        int n2 = MathHelper.func_76128_c(p_72829_1_.field_72336_d + 1.0);
        int n3 = MathHelper.func_76128_c(p_72829_1_.field_72338_b);
        int n4 = MathHelper.func_76128_c(p_72829_1_.field_72337_e + 1.0);
        int n5 = MathHelper.func_76128_c(p_72829_1_.field_72339_c);
        int n6 = MathHelper.func_76128_c(p_72829_1_.field_72334_f + 1.0);
        if (p_72829_1_.field_72340_a < 0.0) {
            --n;
        }
        if (p_72829_1_.field_72338_b < 0.0) {
            --n3;
        }
        if (p_72829_1_.field_72339_c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.field_71973_m[this.func_72798_a(i, j, k)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_72953_d(AxisAlignedBB p_72953_1_) {
        int n = MathHelper.func_76128_c(p_72953_1_.field_72340_a);
        int n2 = MathHelper.func_76128_c(p_72953_1_.field_72336_d + 1.0);
        int n3 = MathHelper.func_76128_c(p_72953_1_.field_72338_b);
        int n4 = MathHelper.func_76128_c(p_72953_1_.field_72337_e + 1.0);
        int n5 = MathHelper.func_76128_c(p_72953_1_.field_72339_c);
        int n6 = MathHelper.func_76128_c(p_72953_1_.field_72334_f + 1.0);
        if (p_72953_1_.field_72340_a < 0.0) {
            --n;
        }
        if (p_72953_1_.field_72338_b < 0.0) {
            --n3;
        }
        if (p_72953_1_.field_72339_c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.field_71973_m[this.func_72798_a(i, j, k)];
                    if (block == null || !block.field_72018_cp.func_76224_d()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_72978_e(AxisAlignedBB p_72978_1_) {
        int n;
        int n2 = MathHelper.func_76128_c(p_72978_1_.field_72340_a);
        int n3 = MathHelper.func_76128_c(p_72978_1_.field_72336_d + 1.0);
        int n4 = MathHelper.func_76128_c(p_72978_1_.field_72338_b);
        int n5 = MathHelper.func_76128_c(p_72978_1_.field_72337_e + 1.0);
        int n6 = MathHelper.func_76128_c(p_72978_1_.field_72339_c);
        if (this.func_72904_c(n2, n4, n6, n3, n5, n = MathHelper.func_76128_c(p_72978_1_.field_72334_f + 1.0))) {
            for (int i = n2; i < n3; ++i) {
                for (int j = n4; j < n5; ++j) {
                    for (int k = n6; k < n; ++k) {
                        int n7 = this.func_72798_a(i, j, k);
                        if (n7 != Block.field_72067_ar.field_71990_ca && n7 != Block.field_71944_C.field_71990_ca && n7 != Block.field_71938_D.field_71990_ca) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_72918_a(AxisAlignedBB p_72918_1_, Material p_72918_2_, Entity p_72918_3_) {
        int n;
        int n2 = MathHelper.func_76128_c(p_72918_1_.field_72340_a);
        int n3 = MathHelper.func_76128_c(p_72918_1_.field_72336_d + 1.0);
        int n4 = MathHelper.func_76128_c(p_72918_1_.field_72338_b);
        int n5 = MathHelper.func_76128_c(p_72918_1_.field_72337_e + 1.0);
        int n6 = MathHelper.func_76128_c(p_72918_1_.field_72339_c);
        if (!this.func_72904_c(n2, n4, n6, n3, n5, n = MathHelper.func_76128_c(p_72918_1_.field_72334_f + 1.0))) {
            return false;
        }
        boolean bl = false;
        Vec3 vec3 = this.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        for (int i = n2; i < n3; ++i) {
            for (int j = n4; j < n5; ++j) {
                for (int k = n6; k < n; ++k) {
                    double d;
                    Block block = Block.field_71973_m[this.func_72798_a(i, j, k)];
                    if (block == null || block.field_72018_cp != p_72918_2_ || !((double)n5 >= (d = (double)((float)(j + 1) - BlockFluid.func_72199_d(this.func_72805_g(i, j, k)))))) continue;
                    bl = true;
                    block.func_71901_a(this, i, j, k, p_72918_3_, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && p_72918_3_.func_96092_aw()) {
            vec3 = vec3.func_72432_b();
            double d = 0.014;
            p_72918_3_.field_70159_w += vec3.field_72450_a * d;
            p_72918_3_.field_70181_x += vec3.field_72448_b * d;
            p_72918_3_.field_70179_y += vec3.field_72449_c * d;
        }
        return bl;
    }

    public boolean func_72875_a(AxisAlignedBB p_72875_1_, Material p_72875_2_) {
        int n = MathHelper.func_76128_c(p_72875_1_.field_72340_a);
        int n2 = MathHelper.func_76128_c(p_72875_1_.field_72336_d + 1.0);
        int n3 = MathHelper.func_76128_c(p_72875_1_.field_72338_b);
        int n4 = MathHelper.func_76128_c(p_72875_1_.field_72337_e + 1.0);
        int n5 = MathHelper.func_76128_c(p_72875_1_.field_72339_c);
        int n6 = MathHelper.func_76128_c(p_72875_1_.field_72334_f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.field_71973_m[this.func_72798_a(i, j, k)];
                    if (block == null || block.field_72018_cp != p_72875_2_) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_72830_b(AxisAlignedBB p_72830_1_, Material p_72830_2_) {
        int n = MathHelper.func_76128_c(p_72830_1_.field_72340_a);
        int n2 = MathHelper.func_76128_c(p_72830_1_.field_72336_d + 1.0);
        int n3 = MathHelper.func_76128_c(p_72830_1_.field_72338_b);
        int n4 = MathHelper.func_76128_c(p_72830_1_.field_72337_e + 1.0);
        int n5 = MathHelper.func_76128_c(p_72830_1_.field_72339_c);
        int n6 = MathHelper.func_76128_c(p_72830_1_.field_72334_f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.field_71973_m[this.func_72798_a(i, j, k)];
                    if (block == null || block.field_72018_cp != p_72830_2_) continue;
                    int n7 = this.func_72805_g(i, j, k);
                    double d = j + 1;
                    if (n7 < 8) {
                        d = (double)(j + 1) - (double)n7 / 8.0;
                    }
                    if (!(d >= p_72830_1_.field_72338_b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion func_72876_a(Entity p_72876_1_, double p_72876_2_, double p_72876_4_, double p_72876_6_, float p_72876_8_, boolean p_72876_9_) {
        return this.func_72885_a(p_72876_1_, p_72876_2_, p_72876_4_, p_72876_6_, p_72876_8_, false, p_72876_9_);
    }

    public Explosion func_72885_a(Entity p_72885_1_, double p_72885_2_, double p_72885_4_, double p_72885_6_, float p_72885_8_, boolean p_72885_9_, boolean p_72885_10_) {
        Explosion explosion = new Explosion(this, p_72885_1_, p_72885_2_, p_72885_4_, p_72885_6_, p_72885_8_);
        explosion.field_77286_a = p_72885_9_;
        explosion.field_82755_b = p_72885_10_;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public float func_72842_a(Vec3 p_72842_1_, AxisAlignedBB p_72842_2_) {
        double d = 1.0 / ((p_72842_2_.field_72336_d - p_72842_2_.field_72340_a) * 2.0 + 1.0);
        double d2 = 1.0 / ((p_72842_2_.field_72337_e - p_72842_2_.field_72338_b) * 2.0 + 1.0);
        double d3 = 1.0 / ((p_72842_2_.field_72334_f - p_72842_2_.field_72339_c) * 2.0 + 1.0);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    double d4 = p_72842_2_.field_72340_a + (p_72842_2_.field_72336_d - p_72842_2_.field_72340_a) * (double)f;
                    double d5 = p_72842_2_.field_72338_b + (p_72842_2_.field_72337_e - p_72842_2_.field_72338_b) * (double)f2;
                    double d6 = p_72842_2_.field_72339_c + (p_72842_2_.field_72334_f - p_72842_2_.field_72339_c) * (double)f3;
                    if (this.func_72933_a(this.func_82732_R().func_72345_a(d4, d5, d6), p_72842_1_) == null) {
                        ++n;
                    }
                    ++n2;
                    f3 = (float)((double)f3 + d3);
                }
                f2 = (float)((double)f2 + d2);
            }
            f = (float)((double)f + d);
        }
        return (float)n / (float)n2;
    }

    public boolean func_72886_a(EntityPlayer p_72886_1_, int p_72886_2_, int p_72886_3_, int p_72886_4_, int p_72886_5_) {
        if (p_72886_5_ == 0) {
            --p_72886_3_;
        }
        if (p_72886_5_ == 1) {
            ++p_72886_3_;
        }
        if (p_72886_5_ == 2) {
            --p_72886_4_;
        }
        if (p_72886_5_ == 3) {
            ++p_72886_4_;
        }
        if (p_72886_5_ == 4) {
            --p_72886_2_;
        }
        if (p_72886_5_ == 5) {
            ++p_72886_2_;
        }
        if (this.func_72798_a(p_72886_2_, p_72886_3_, p_72886_4_) == Block.field_72067_ar.field_71990_ca) {
            this.func_72889_a(p_72886_1_, 1004, p_72886_2_, p_72886_3_, p_72886_4_, 0);
            this.func_94571_i(p_72886_2_, p_72886_3_, p_72886_4_);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_72981_t() {
        return "All: " + this.field_72996_f.size();
    }

    @SideOnly(value=Side.CLIENT)
    public String func_72827_u() {
        return this.field_73020_y.func_73148_d();
    }

    @Override
    public TileEntity func_72796_p(int p_72796_1_, int p_72796_2_, int p_72796_3_) {
        Chunk chunk;
        TileEntity tileEntity;
        int n;
        if (p_72796_2_ < 0 || p_72796_2_ >= 256) {
            return null;
        }
        TileEntity tileEntity2 = null;
        if (this.field_72989_L) {
            for (n = 0; n < this.field_73002_a.size(); ++n) {
                tileEntity = (TileEntity)this.field_73002_a.get(n);
                if (tileEntity.func_70320_p() || tileEntity.field_70329_l != p_72796_1_ || tileEntity.field_70330_m != p_72796_2_ || tileEntity.field_70327_n != p_72796_3_) continue;
                tileEntity2 = tileEntity;
                break;
            }
        }
        if (tileEntity2 == null && (chunk = this.func_72964_e(p_72796_1_ >> 4, p_72796_3_ >> 4)) != null) {
            tileEntity2 = chunk.func_76597_e(p_72796_1_ & 0xF, p_72796_2_, p_72796_3_ & 0xF);
        }
        if (tileEntity2 == null) {
            for (n = 0; n < this.field_73002_a.size(); ++n) {
                tileEntity = (TileEntity)this.field_73002_a.get(n);
                if (tileEntity.func_70320_p() || tileEntity.field_70329_l != p_72796_1_ || tileEntity.field_70330_m != p_72796_2_ || tileEntity.field_70327_n != p_72796_3_) continue;
                tileEntity2 = tileEntity;
                break;
            }
        }
        return tileEntity2;
    }

    public void func_72837_a(int p_72837_1_, int p_72837_2_, int p_72837_3_, TileEntity p_72837_4_) {
        if (p_72837_4_ != null && !p_72837_4_.func_70320_p()) {
            if (this.field_72989_L) {
                p_72837_4_.field_70329_l = p_72837_1_;
                p_72837_4_.field_70330_m = p_72837_2_;
                p_72837_4_.field_70327_n = p_72837_3_;
                Iterator iterator = this.field_73002_a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileEntity = (TileEntity)iterator.next();
                    if (tileEntity.field_70329_l != p_72837_1_ || tileEntity.field_70330_m != p_72837_2_ || tileEntity.field_70327_n != p_72837_3_) continue;
                    tileEntity.func_70313_j();
                    iterator.remove();
                }
                this.field_73002_a.add(p_72837_4_);
            } else {
                this.field_73009_h.add(p_72837_4_);
                Chunk chunk = this.func_72964_e(p_72837_1_ >> 4, p_72837_3_ >> 4);
                if (chunk != null) {
                    chunk.func_76604_a(p_72837_1_ & 0xF, p_72837_2_, p_72837_3_ & 0xF, p_72837_4_);
                }
            }
        }
    }

    public void func_72932_q(int p_72932_1_, int p_72932_2_, int p_72932_3_) {
        TileEntity tileEntity = this.func_72796_p(p_72932_1_, p_72932_2_, p_72932_3_);
        if (tileEntity != null && this.field_72989_L) {
            tileEntity.func_70313_j();
            this.field_73002_a.remove(tileEntity);
        } else {
            Chunk chunk;
            if (tileEntity != null) {
                this.field_73002_a.remove(tileEntity);
                this.field_73009_h.remove(tileEntity);
            }
            if ((chunk = this.func_72964_e(p_72932_1_ >> 4, p_72932_3_ >> 4)) != null) {
                chunk.func_76627_f(p_72932_1_ & 0xF, p_72932_2_, p_72932_3_ & 0xF);
            }
        }
    }

    public void func_72928_a(TileEntity p_72928_1_) {
        this.field_73000_b.add(p_72928_1_);
    }

    @Override
    public boolean func_72804_r(int p_72804_1_, int p_72804_2_, int p_72804_3_) {
        Block block = Block.field_71973_m[this.func_72798_a(p_72804_1_, p_72804_2_, p_72804_3_)];
        if (block == null) {
            return false;
        }
        return block.func_71926_d();
    }

    @Override
    public boolean func_72809_s(int p_72809_1_, int p_72809_2_, int p_72809_3_) {
        return Block.func_71932_i(this.func_72798_a(p_72809_1_, p_72809_2_, p_72809_3_));
    }

    public boolean func_85174_u(int p_85174_1_, int p_85174_2_, int p_85174_3_) {
        int n = this.func_72798_a(p_85174_1_, p_85174_2_, p_85174_3_);
        if (n == 0 || Block.field_71973_m[n] == null) {
            return false;
        }
        AxisAlignedBB axisAlignedBB = Block.field_71973_m[n].func_71872_e(this, p_85174_1_, p_85174_2_, p_85174_3_);
        return axisAlignedBB != null && axisAlignedBB.func_72320_b() >= 1.0;
    }

    @Override
    public boolean func_72797_t(int p_72797_1_, int p_72797_2_, int p_72797_3_) {
        Block block = Block.field_71973_m[this.func_72798_a(p_72797_1_, p_72797_2_, p_72797_3_)];
        return this.func_102026_a(block, this.func_72805_g(p_72797_1_, p_72797_2_, p_72797_3_));
    }

    public boolean func_102026_a(Block p_102026_1_, int p_102026_2_) {
        if (p_102026_1_ == null) {
            return false;
        }
        if (p_102026_1_.field_72018_cp.func_76218_k() && p_102026_1_.func_71886_c()) {
            return true;
        }
        if (p_102026_1_ instanceof BlockStairs) {
            return (p_102026_2_ & 4) == 4;
        }
        if (p_102026_1_ instanceof BlockHalfSlab) {
            return (p_102026_2_ & 8) == 8;
        }
        if (p_102026_1_ instanceof BlockHopper) {
            return true;
        }
        if (p_102026_1_ instanceof BlockSnow) {
            return (p_102026_2_ & 7) == 7;
        }
        return false;
    }

    public boolean func_72887_b(int p_72887_1_, int p_72887_2_, int p_72887_3_, boolean p_72887_4_) {
        if (p_72887_1_ < -30000000 || p_72887_3_ < -30000000 || p_72887_1_ >= 30000000 || p_72887_3_ >= 30000000) {
            return p_72887_4_;
        }
        Chunk chunk = this.field_73020_y.func_73154_d(p_72887_1_ >> 4, p_72887_3_ >> 4);
        if (chunk == null || chunk.func_76621_g()) {
            return p_72887_4_;
        }
        Block block = Block.field_71973_m[this.func_72798_a(p_72887_1_, p_72887_2_, p_72887_3_)];
        if (block == null) {
            return false;
        }
        return block.field_72018_cp.func_76218_k() && block.func_71886_c();
    }

    public void func_72966_v() {
        int n = this.func_72967_a(1.0f);
        if (n != this.field_73008_k) {
            this.field_73008_k = n;
        }
    }

    public void func_72891_a(boolean p_72891_1_, boolean p_72891_2_) {
        this.field_72985_G = p_72891_1_;
        this.field_72992_H = p_72891_2_;
    }

    public void func_72835_b() {
        this.func_72979_l();
    }

    private void func_72947_a() {
        if (this.field_72986_A.func_76059_o()) {
            this.field_73004_o = 1.0f;
            if (this.field_72986_A.func_76061_m()) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    protected void func_72979_l() {
        if (this.field_73011_w.field_76576_e) {
            return;
        }
        int n = this.field_72986_A.func_76071_n();
        if (n <= 0) {
            if (this.field_72986_A.func_76061_m()) {
                this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(12000) + 3600);
            } else {
                this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(168000) + 12000);
            }
        } else {
            this.field_72986_A.func_76090_f(--n);
            if (n <= 0) {
                this.field_72986_A.func_76069_a(!this.field_72986_A.func_76061_m());
            }
        }
        int n2 = this.field_72986_A.func_76083_p();
        if (n2 <= 0) {
            if (this.field_72986_A.func_76059_o()) {
                this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(12000) + 12000);
            } else {
                this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(168000) + 12000);
            }
        } else {
            this.field_72986_A.func_76080_g(--n2);
            if (n2 <= 0) {
                this.field_72986_A.func_76084_b(!this.field_72986_A.func_76059_o());
            }
        }
        this.field_73003_n = this.field_73004_o;
        this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
        if (this.field_73004_o < 0.0f) {
            this.field_73004_o = 0.0f;
        }
        if (this.field_73004_o > 1.0f) {
            this.field_73004_o = 1.0f;
        }
        this.field_73018_p = this.field_73017_q;
        this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
        if (this.field_73017_q < 0.0f) {
            this.field_73017_q = 0.0f;
        }
        if (this.field_73017_q > 1.0f) {
            this.field_73017_q = 1.0f;
        }
    }

    public void func_72913_w() {
        this.field_72986_A.func_76080_g(1);
    }

    protected void func_72903_x() {
        int n;
        int n2;
        int n3;
        EntityPlayer entityPlayer;
        int n4;
        this.field_72993_I.clear();
        this.field_72984_F.func_76320_a("buildList");
        for (n4 = 0; n4 < this.field_73010_i.size(); ++n4) {
            entityPlayer = (EntityPlayer)this.field_73010_i.get(n4);
            n3 = MathHelper.func_76128_c(entityPlayer.field_70165_t / 16.0);
            n2 = MathHelper.func_76128_c(entityPlayer.field_70161_v / 16.0);
            n = 7;
            for (int i = -n; i <= n; ++i) {
                for (int j = -n; j <= n; ++j) {
                    this.field_72993_I.add(new ChunkCoordIntPair(i + n3, j + n2));
                }
            }
        }
        this.field_72984_F.func_76319_b();
        if (this.field_72990_M > 0) {
            --this.field_72990_M;
        }
        this.field_72984_F.func_76320_a("playerCheckLight");
        if (!this.field_73010_i.isEmpty()) {
            n4 = this.field_73012_v.nextInt(this.field_73010_i.size());
            entityPlayer = (EntityPlayer)this.field_73010_i.get(n4);
            n3 = MathHelper.func_76128_c(entityPlayer.field_70165_t) + this.field_73012_v.nextInt(11) - 5;
            n2 = MathHelper.func_76128_c(entityPlayer.field_70163_u) + this.field_73012_v.nextInt(11) - 5;
            n = MathHelper.func_76128_c(entityPlayer.field_70161_v) + this.field_73012_v.nextInt(11) - 5;
            this.func_72969_x(n3, n2, n);
        }
        this.field_72984_F.func_76319_b();
    }

    protected void func_72941_a(int p_72941_1_, int p_72941_2_, Chunk p_72941_3_) {
        this.field_72984_F.func_76318_c("moodSound");
        if (this.field_72990_M == 0 && !this.field_72995_K) {
            EntityPlayer entityPlayer;
            this.field_73005_l = this.field_73005_l * 3 + 1013904223;
            int n = this.field_73005_l >> 2;
            int n2 = n & 0xF;
            int n3 = n >> 8 & 0xF;
            int n4 = n >> 16 & 0x7F;
            int n5 = p_72941_3_.func_76610_a(n2, n4, n3);
            if (n5 == 0 && this.func_72883_k(n2 += p_72941_1_, n4, n3 += p_72941_2_) <= this.field_73012_v.nextInt(8) && this.func_72972_b(EnumSkyBlock.Sky, n2, n4, n3) <= 0 && (entityPlayer = this.func_72977_a((double)n2 + 0.5, (double)n4 + 0.5, (double)n3 + 0.5, 8.0)) != null && entityPlayer.func_70092_e((double)n2 + 0.5, (double)n4 + 0.5, (double)n3 + 0.5) > 4.0) {
                this.func_72908_a((double)n2 + 0.5, (double)n4 + 0.5, (double)n3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.field_73012_v.nextFloat() * 0.2f);
                this.field_72990_M = this.field_73012_v.nextInt(12000) + 6000;
            }
        }
        this.field_72984_F.func_76318_c("checkLight");
        p_72941_3_.func_76594_o();
    }

    protected void func_72893_g() {
        this.func_72903_x();
    }

    public boolean func_72884_u(int p_72884_1_, int p_72884_2_, int p_72884_3_) {
        return this.func_72834_c(p_72884_1_, p_72884_2_, p_72884_3_, false);
    }

    public boolean func_72850_v(int p_72850_1_, int p_72850_2_, int p_72850_3_) {
        return this.func_72834_c(p_72850_1_, p_72850_2_, p_72850_3_, true);
    }

    public boolean func_72834_c(int p_72834_1_, int p_72834_2_, int p_72834_3_, boolean p_72834_4_) {
        int n;
        BiomeGenBase biomeGenBase = this.func_72807_a(p_72834_1_, p_72834_3_);
        float f = biomeGenBase.func_76743_j();
        if (f > 0.15f) {
            return false;
        }
        if (p_72834_2_ >= 0 && p_72834_2_ < 256 && this.func_72972_b(EnumSkyBlock.Block, p_72834_1_, p_72834_2_, p_72834_3_) < 10 && ((n = this.func_72798_a(p_72834_1_, p_72834_2_, p_72834_3_)) == Block.field_71943_B.field_71990_ca || n == Block.field_71942_A.field_71990_ca) && this.func_72805_g(p_72834_1_, p_72834_2_, p_72834_3_) == 0) {
            if (!p_72834_4_) {
                return true;
            }
            boolean bl = true;
            if (bl && this.func_72803_f(p_72834_1_ - 1, p_72834_2_, p_72834_3_) != Material.field_76244_g) {
                bl = false;
            }
            if (bl && this.func_72803_f(p_72834_1_ + 1, p_72834_2_, p_72834_3_) != Material.field_76244_g) {
                bl = false;
            }
            if (bl && this.func_72803_f(p_72834_1_, p_72834_2_, p_72834_3_ - 1) != Material.field_76244_g) {
                bl = false;
            }
            if (bl && this.func_72803_f(p_72834_1_, p_72834_2_, p_72834_3_ + 1) != Material.field_76244_g) {
                bl = false;
            }
            if (!bl) {
                return true;
            }
        }
        return false;
    }

    public boolean func_72858_w(int p_72858_1_, int p_72858_2_, int p_72858_3_) {
        BiomeGenBase biomeGenBase = this.func_72807_a(p_72858_1_, p_72858_3_);
        float f = biomeGenBase.func_76743_j();
        if (f > 0.15f) {
            return false;
        }
        if (p_72858_2_ >= 0 && p_72858_2_ < 256 && this.func_72972_b(EnumSkyBlock.Block, p_72858_1_, p_72858_2_, p_72858_3_) < 10) {
            int n = this.func_72798_a(p_72858_1_, p_72858_2_ - 1, p_72858_3_);
            int n2 = this.func_72798_a(p_72858_1_, p_72858_2_, p_72858_3_);
            if (n2 == 0 && Block.field_72037_aS.func_71930_b(this, p_72858_1_, p_72858_2_, p_72858_3_) && n != 0 && n != Block.field_72036_aT.field_71990_ca && Block.field_71973_m[n].field_72018_cp.func_76230_c()) {
                return true;
            }
        }
        return false;
    }

    public void func_72969_x(int p_72969_1_, int p_72969_2_, int p_72969_3_) {
        if (!this.field_73011_w.field_76576_e) {
            this.func_72936_c(EnumSkyBlock.Sky, p_72969_1_, p_72969_2_, p_72969_3_);
        }
        this.func_72936_c(EnumSkyBlock.Block, p_72969_1_, p_72969_2_, p_72969_3_);
    }

    private int func_98179_a(int p_98179_1_, int p_98179_2_, int p_98179_3_, EnumSkyBlock p_98179_4_) {
        if (p_98179_4_ == EnumSkyBlock.Sky && this.func_72937_j(p_98179_1_, p_98179_2_, p_98179_3_)) {
            return 15;
        }
        int n = this.func_72798_a(p_98179_1_, p_98179_2_, p_98179_3_);
        int n2 = p_98179_4_ == EnumSkyBlock.Sky ? 0 : Block.field_71984_q[n];
        int n3 = Block.field_71971_o[n];
        if (n3 >= 15 && Block.field_71984_q[n] > 0) {
            n3 = 1;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        if (n3 >= 15) {
            return 0;
        }
        if (n2 >= 14) {
            return n2;
        }
        for (int i = 0; i < 6; ++i) {
            int n4 = p_98179_1_ + Facing.field_71586_b[i];
            int n5 = p_98179_2_ + Facing.field_71587_c[i];
            int n6 = p_98179_3_ + Facing.field_71585_d[i];
            int n7 = this.func_72972_b(p_98179_4_, n4, n5, n6) - n3;
            if (n7 > n2) {
                n2 = n7;
            }
            if (n2 < 14) continue;
            return n2;
        }
        return n2;
    }

    public void func_72936_c(EnumSkyBlock p_72936_1_, int p_72936_2_, int p_72936_3_, int p_72936_4_) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        if (!this.func_72873_a(p_72936_2_, p_72936_3_, p_72936_4_, 17)) {
            return;
        }
        int n11 = 0;
        int n12 = 0;
        this.field_72984_F.func_76320_a("getBrightness");
        int n13 = this.func_72972_b(p_72936_1_, p_72936_2_, p_72936_3_, p_72936_4_);
        int n14 = this.func_98179_a(p_72936_2_, p_72936_3_, p_72936_4_, p_72936_1_);
        if (n14 > n13) {
            this.field_72994_J[n12++] = 133152;
        } else if (n14 < n13) {
            this.field_72994_J[n12++] = 0x20820 | n13 << 18;
            while (n11 < n12) {
                n10 = this.field_72994_J[n11++];
                n9 = (n10 & 0x3F) - 32 + p_72936_2_;
                n8 = (n10 >> 6 & 0x3F) - 32 + p_72936_3_;
                n7 = (n10 >> 12 & 0x3F) - 32 + p_72936_4_;
                n6 = n10 >> 18 & 0xF;
                n5 = this.func_72972_b(p_72936_1_, n9, n8, n7);
                if (n5 != n6) continue;
                this.func_72915_b(p_72936_1_, n9, n8, n7, 0);
                if (n6 <= 0 || (n4 = MathHelper.func_76130_a(n9 - p_72936_2_)) + (n3 = MathHelper.func_76130_a(n8 - p_72936_3_)) + (n2 = MathHelper.func_76130_a(n7 - p_72936_4_)) >= 17) continue;
                for (n = 0; n < 6; ++n) {
                    int n15 = n9 + Facing.field_71586_b[n];
                    int n16 = n8 + Facing.field_71587_c[n];
                    int n17 = n7 + Facing.field_71585_d[n];
                    int n18 = Math.max(1, Block.field_71971_o[this.func_72798_a(n15, n16, n17)]);
                    n5 = this.func_72972_b(p_72936_1_, n15, n16, n17);
                    if (n5 != n6 - n18 || n12 >= this.field_72994_J.length) continue;
                    this.field_72994_J[n12++] = n15 - p_72936_2_ + 32 | n16 - p_72936_3_ + 32 << 6 | n17 - p_72936_4_ + 32 << 12 | n6 - n18 << 18;
                }
            }
            n11 = 0;
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76320_a("checkedPosition < toCheckCount");
        while (n11 < n12) {
            n10 = this.field_72994_J[n11++];
            n9 = (n10 & 0x3F) - 32 + p_72936_2_;
            n8 = (n10 >> 6 & 0x3F) - 32 + p_72936_3_;
            n7 = (n10 >> 12 & 0x3F) - 32 + p_72936_4_;
            n6 = this.func_72972_b(p_72936_1_, n9, n8, n7);
            n5 = this.func_98179_a(n9, n8, n7, p_72936_1_);
            if (n5 == n6) continue;
            this.func_72915_b(p_72936_1_, n9, n8, n7, n5);
            if (n5 <= n6) continue;
            n4 = Math.abs(n9 - p_72936_2_);
            n3 = Math.abs(n8 - p_72936_3_);
            n2 = Math.abs(n7 - p_72936_4_);
            int n19 = n = n12 < this.field_72994_J.length - 6 ? 1 : 0;
            if (n4 + n3 + n2 >= 17 || n == 0) continue;
            if (this.func_72972_b(p_72936_1_, n9 - 1, n8, n7) < n5) {
                this.field_72994_J[n12++] = n9 - 1 - p_72936_2_ + 32 + (n8 - p_72936_3_ + 32 << 6) + (n7 - p_72936_4_ + 32 << 12);
            }
            if (this.func_72972_b(p_72936_1_, n9 + 1, n8, n7) < n5) {
                this.field_72994_J[n12++] = n9 + 1 - p_72936_2_ + 32 + (n8 - p_72936_3_ + 32 << 6) + (n7 - p_72936_4_ + 32 << 12);
            }
            if (this.func_72972_b(p_72936_1_, n9, n8 - 1, n7) < n5) {
                this.field_72994_J[n12++] = n9 - p_72936_2_ + 32 + (n8 - 1 - p_72936_3_ + 32 << 6) + (n7 - p_72936_4_ + 32 << 12);
            }
            if (this.func_72972_b(p_72936_1_, n9, n8 + 1, n7) < n5) {
                this.field_72994_J[n12++] = n9 - p_72936_2_ + 32 + (n8 + 1 - p_72936_3_ + 32 << 6) + (n7 - p_72936_4_ + 32 << 12);
            }
            if (this.func_72972_b(p_72936_1_, n9, n8, n7 - 1) < n5) {
                this.field_72994_J[n12++] = n9 - p_72936_2_ + 32 + (n8 - p_72936_3_ + 32 << 6) + (n7 - 1 - p_72936_4_ + 32 << 12);
            }
            if (this.func_72972_b(p_72936_1_, n9, n8, n7 + 1) >= n5) continue;
            this.field_72994_J[n12++] = n9 - p_72936_2_ + 32 + (n8 - p_72936_3_ + 32 << 6) + (n7 + 1 - p_72936_4_ + 32 << 12);
        }
        this.field_72984_F.func_76319_b();
    }

    public boolean func_72955_a(boolean p_72955_1_) {
        return false;
    }

    public List func_72920_a(Chunk p_72920_1_, boolean p_72920_2_) {
        return null;
    }

    public List func_72839_b(Entity p_72839_1_, AxisAlignedBB p_72839_2_) {
        return this.func_94576_a(p_72839_1_, p_72839_2_, null);
    }

    public List func_94576_a(Entity p_94576_1_, AxisAlignedBB p_94576_2_, IEntitySelector p_94576_3_) {
        ArrayList arrayList = new ArrayList();
        int n = MathHelper.func_76128_c((p_94576_2_.field_72340_a - 2.0) / 16.0);
        int n2 = MathHelper.func_76128_c((p_94576_2_.field_72336_d + 2.0) / 16.0);
        int n3 = MathHelper.func_76128_c((p_94576_2_.field_72339_c - 2.0) / 16.0);
        int n4 = MathHelper.func_76128_c((p_94576_2_.field_72334_f + 2.0) / 16.0);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.func_72916_c(i, j)) continue;
                this.func_72964_e(i, j).func_76588_a(p_94576_1_, p_94576_2_, arrayList, p_94576_3_);
            }
        }
        return arrayList;
    }

    public List func_72872_a(Class p_72872_1_, AxisAlignedBB p_72872_2_) {
        return this.func_82733_a(p_72872_1_, p_72872_2_, null);
    }

    public List func_82733_a(Class p_82733_1_, AxisAlignedBB p_82733_2_, IEntitySelector p_82733_3_) {
        int n = MathHelper.func_76128_c((p_82733_2_.field_72340_a - 2.0) / 16.0);
        int n2 = MathHelper.func_76128_c((p_82733_2_.field_72336_d + 2.0) / 16.0);
        int n3 = MathHelper.func_76128_c((p_82733_2_.field_72339_c - 2.0) / 16.0);
        int n4 = MathHelper.func_76128_c((p_82733_2_.field_72334_f + 2.0) / 16.0);
        ArrayList arrayList = new ArrayList();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.func_72916_c(i, j)) continue;
                this.func_72964_e(i, j).func_76618_a(p_82733_1_, p_82733_2_, arrayList, p_82733_3_);
            }
        }
        return arrayList;
    }

    public Entity func_72857_a(Class p_72857_1_, AxisAlignedBB p_72857_2_, Entity p_72857_3_) {
        List list = this.func_72872_a(p_72857_1_, p_72857_2_);
        Entity entity = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            Entity entity2 = (Entity)list.get(i);
            if (entity2 == p_72857_3_ || (d2 = p_72857_3_.func_70068_e(entity2)) > d) continue;
            entity = entity2;
            d = d2;
        }
        return entity;
    }

    public abstract Entity func_73045_a(int var1);

    @SideOnly(value=Side.CLIENT)
    public List func_72910_y() {
        return this.field_72996_f;
    }

    public void func_72944_b(int p_72944_1_, int p_72944_2_, int p_72944_3_, TileEntity p_72944_4_) {
        if (this.func_72899_e(p_72944_1_, p_72944_2_, p_72944_3_)) {
            this.func_72938_d(p_72944_1_, p_72944_3_).func_76630_e();
        }
    }

    public int func_72907_a(Class p_72907_1_) {
        int n = 0;
        for (int i = 0; i < this.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_72996_f.get(i);
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_104002_bU() || !p_72907_1_.isAssignableFrom(entity.getClass())) continue;
            ++n;
        }
        return n;
    }

    public void func_72868_a(List p_72868_1_) {
        this.field_72996_f.addAll(p_72868_1_);
        for (int i = 0; i < p_72868_1_.size(); ++i) {
            this.func_72923_a((Entity)p_72868_1_.get(i));
        }
    }

    public void func_72828_b(List p_72828_1_) {
        this.field_72997_g.addAll(p_72828_1_);
    }

    public boolean func_72931_a(int p_72931_1_, int p_72931_2_, int p_72931_3_, int p_72931_4_, boolean p_72931_5_, int p_72931_6_, Entity p_72931_7_, ItemStack p_72931_8_) {
        int n = this.func_72798_a(p_72931_2_, p_72931_3_, p_72931_4_);
        Block block = Block.field_71973_m[n];
        Block block2 = Block.field_71973_m[p_72931_1_];
        AxisAlignedBB axisAlignedBB = block2.func_71872_e(this, p_72931_2_, p_72931_3_, p_72931_4_);
        if (p_72931_5_) {
            axisAlignedBB = null;
        }
        if (axisAlignedBB != null && !this.func_72917_a(axisAlignedBB, p_72931_7_)) {
            return false;
        }
        if (block != null && (block == Block.field_71942_A || block == Block.field_71943_B || block == Block.field_71944_C || block == Block.field_71938_D || block == Block.field_72067_ar || block.field_72018_cp.func_76222_j())) {
            block = null;
        }
        if (block != null && block.field_72018_cp == Material.field_76265_p && block2 == Block.field_82510_ck) {
            return true;
        }
        return p_72931_1_ > 0 && block == null && block2.func_94331_a(this, p_72931_2_, p_72931_3_, p_72931_4_, p_72931_6_, p_72931_8_);
    }

    public PathEntity func_72865_a(Entity p_72865_1_, Entity p_72865_2_, float p_72865_3_, boolean p_72865_4_, boolean p_72865_5_, boolean p_72865_6_, boolean p_72865_7_) {
        this.field_72984_F.func_76320_a("pathfind");
        int n = MathHelper.func_76128_c(p_72865_1_.field_70165_t);
        int n2 = MathHelper.func_76128_c(p_72865_1_.field_70163_u + 1.0);
        int n3 = MathHelper.func_76128_c(p_72865_1_.field_70161_v);
        int n4 = (int)(p_72865_3_ + 16.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        ChunkCache chunkCache = new ChunkCache(this, n5, n6, n7, n8, n9, n10, 0);
        PathEntity pathEntity = new PathFinder(chunkCache, p_72865_4_, p_72865_5_, p_72865_6_, p_72865_7_).func_75856_a(p_72865_1_, p_72865_2_, p_72865_3_);
        this.field_72984_F.func_76319_b();
        return pathEntity;
    }

    public PathEntity func_72844_a(Entity p_72844_1_, int p_72844_2_, int p_72844_3_, int p_72844_4_, float p_72844_5_, boolean p_72844_6_, boolean p_72844_7_, boolean p_72844_8_, boolean p_72844_9_) {
        this.field_72984_F.func_76320_a("pathfind");
        int n = MathHelper.func_76128_c(p_72844_1_.field_70165_t);
        int n2 = MathHelper.func_76128_c(p_72844_1_.field_70163_u);
        int n3 = MathHelper.func_76128_c(p_72844_1_.field_70161_v);
        int n4 = (int)(p_72844_5_ + 8.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        ChunkCache chunkCache = new ChunkCache(this, n5, n6, n7, n8, n9, n10, 0);
        PathEntity pathEntity = new PathFinder(chunkCache, p_72844_6_, p_72844_7_, p_72844_8_, p_72844_9_).func_75859_a(p_72844_1_, p_72844_2_, p_72844_3_, p_72844_4_, p_72844_5_);
        this.field_72984_F.func_76319_b();
        return pathEntity;
    }

    @Override
    public int func_72879_k(int p_72879_1_, int p_72879_2_, int p_72879_3_, int p_72879_4_) {
        int n = this.func_72798_a(p_72879_1_, p_72879_2_, p_72879_3_);
        if (n == 0) {
            return 0;
        }
        return Block.field_71973_m[n].func_71855_c(this, p_72879_1_, p_72879_2_, p_72879_3_, p_72879_4_);
    }

    public int func_94577_B(int p_94577_1_, int p_94577_2_, int p_94577_3_) {
        int n = 0;
        if ((n = Math.max(n, this.func_72879_k(p_94577_1_, p_94577_2_ - 1, p_94577_3_, 0))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_72879_k(p_94577_1_, p_94577_2_ + 1, p_94577_3_, 1))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_72879_k(p_94577_1_, p_94577_2_, p_94577_3_ - 1, 2))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_72879_k(p_94577_1_, p_94577_2_, p_94577_3_ + 1, 3))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_72879_k(p_94577_1_ - 1, p_94577_2_, p_94577_3_, 4))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_72879_k(p_94577_1_ + 1, p_94577_2_, p_94577_3_, 5))) >= 15) {
            return n;
        }
        return n;
    }

    public boolean func_94574_k(int p_94574_1_, int p_94574_2_, int p_94574_3_, int p_94574_4_) {
        return this.func_72878_l(p_94574_1_, p_94574_2_, p_94574_3_, p_94574_4_) > 0;
    }

    public int func_72878_l(int p_72878_1_, int p_72878_2_, int p_72878_3_, int p_72878_4_) {
        if (this.func_72809_s(p_72878_1_, p_72878_2_, p_72878_3_)) {
            return this.func_94577_B(p_72878_1_, p_72878_2_, p_72878_3_);
        }
        int n = this.func_72798_a(p_72878_1_, p_72878_2_, p_72878_3_);
        if (n == 0) {
            return 0;
        }
        return Block.field_71973_m[n].func_71865_a(this, p_72878_1_, p_72878_2_, p_72878_3_, p_72878_4_);
    }

    public boolean func_72864_z(int p_72864_1_, int p_72864_2_, int p_72864_3_) {
        if (this.func_72878_l(p_72864_1_, p_72864_2_ - 1, p_72864_3_, 0) > 0) {
            return true;
        }
        if (this.func_72878_l(p_72864_1_, p_72864_2_ + 1, p_72864_3_, 1) > 0) {
            return true;
        }
        if (this.func_72878_l(p_72864_1_, p_72864_2_, p_72864_3_ - 1, 2) > 0) {
            return true;
        }
        if (this.func_72878_l(p_72864_1_, p_72864_2_, p_72864_3_ + 1, 3) > 0) {
            return true;
        }
        if (this.func_72878_l(p_72864_1_ - 1, p_72864_2_, p_72864_3_, 4) > 0) {
            return true;
        }
        return this.func_72878_l(p_72864_1_ + 1, p_72864_2_, p_72864_3_, 5) > 0;
    }

    public int func_94572_D(int p_94572_1_, int p_94572_2_, int p_94572_3_) {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            int n2 = this.func_72878_l(p_94572_1_ + Facing.field_71586_b[i], p_94572_2_ + Facing.field_71587_c[i], p_94572_3_ + Facing.field_71585_d[i], i);
            if (n2 >= 15) {
                return 15;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public EntityPlayer func_72890_a(Entity p_72890_1_, double p_72890_2_) {
        return this.func_72977_a(p_72890_1_.field_70165_t, p_72890_1_.field_70163_u, p_72890_1_.field_70161_v, p_72890_2_);
    }

    public EntityPlayer func_72977_a(double p_72977_1_, double p_72977_3_, double p_72977_5_, double p_72977_7_) {
        double d = -1.0;
        EntityPlayer entityPlayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer2 = (EntityPlayer)this.field_73010_i.get(i);
            double d2 = entityPlayer2.func_70092_e(p_72977_1_, p_72977_3_, p_72977_5_);
            if (!(p_72977_7_ < 0.0) && !(d2 < p_72977_7_ * p_72977_7_) || d != -1.0 && !(d2 < d)) continue;
            d = d2;
            entityPlayer = entityPlayer2;
        }
        return entityPlayer;
    }

    public EntityPlayer func_72856_b(Entity p_72856_1_, double p_72856_2_) {
        return this.func_72846_b(p_72856_1_.field_70165_t, p_72856_1_.field_70163_u, p_72856_1_.field_70161_v, p_72856_2_);
    }

    public EntityPlayer func_72846_b(double p_72846_1_, double p_72846_3_, double p_72846_5_, double p_72846_7_) {
        double d = -1.0;
        EntityPlayer entityPlayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer2 = (EntityPlayer)this.field_73010_i.get(i);
            if (entityPlayer2.field_71075_bZ.field_75102_a || !entityPlayer2.func_70089_S()) continue;
            double d2 = entityPlayer2.func_70092_e(p_72846_1_, p_72846_3_, p_72846_5_);
            double d3 = p_72846_7_;
            if (entityPlayer2.func_70093_af()) {
                d3 *= (double)0.8f;
            }
            if (entityPlayer2.func_82150_aj()) {
                float f = entityPlayer2.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d3 *= (double)(0.7f * f);
            }
            if (!(p_72846_7_ < 0.0) && !(d2 < d3 * d3) || d != -1.0 && !(d2 < d)) continue;
            d = d2;
            entityPlayer = entityPlayer2;
        }
        return entityPlayer;
    }

    public EntityPlayer func_72924_a(String p_72924_1_) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            if (!p_72924_1_.equals(((EntityPlayer)this.field_73010_i.get(i)).func_70005_c_())) continue;
            return (EntityPlayer)this.field_73010_i.get(i);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72882_A() {
    }

    public void func_72906_B() throws MinecraftException {
        this.field_73019_z.func_75762_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_82738_a(long p_82738_1_) {
        this.field_72986_A.func_82572_b(p_82738_1_);
    }

    public long func_72905_C() {
        return this.field_72986_A.func_76063_b();
    }

    public long func_82737_E() {
        return this.field_72986_A.func_82573_f();
    }

    public long func_72820_D() {
        return this.field_72986_A.func_76073_f();
    }

    public void func_72877_b(long p_72877_1_) {
        this.field_72986_A.func_76068_b(p_72877_1_);
    }

    public ChunkCoordinates func_72861_E() {
        return new ChunkCoordinates(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72950_A(int p_72950_1_, int p_72950_2_, int p_72950_3_) {
        this.field_72986_A.func_76081_a(p_72950_1_, p_72950_2_, p_72950_3_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72897_h(Entity p_72897_1_) {
        int n = MathHelper.func_76128_c(p_72897_1_.field_70165_t / 16.0);
        int n2 = MathHelper.func_76128_c(p_72897_1_.field_70161_v / 16.0);
        int n3 = 2;
        for (int i = n - n3; i <= n + n3; ++i) {
            for (int j = n2 - n3; j <= n2 + n3; ++j) {
                this.func_72964_e(i, j);
            }
        }
        if (!this.field_72996_f.contains(p_72897_1_)) {
            this.field_72996_f.add(p_72897_1_);
        }
    }

    public boolean func_72962_a(EntityPlayer p_72962_1_, int p_72962_2_, int p_72962_3_, int p_72962_4_) {
        return true;
    }

    public void func_72960_a(Entity p_72960_1_, byte p_72960_2_) {
    }

    public IChunkProvider func_72863_F() {
        return this.field_73020_y;
    }

    public void func_72965_b(int p_72965_1_, int p_72965_2_, int p_72965_3_, int p_72965_4_, int p_72965_5_, int p_72965_6_) {
        if (p_72965_4_ > 0) {
            Block.field_71973_m[p_72965_4_].func_71883_b(this, p_72965_1_, p_72965_2_, p_72965_3_, p_72965_5_, p_72965_6_);
        }
    }

    public ISaveHandler func_72860_G() {
        return this.field_73019_z;
    }

    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.field_72986_A.func_82574_x();
    }

    public void func_72854_c() {
    }

    public float func_72819_i(float p_72819_1_) {
        return (this.field_73018_p + (this.field_73017_q - this.field_73018_p) * p_72819_1_) * this.func_72867_j(p_72819_1_);
    }

    public float func_72867_j(float p_72867_1_) {
        return this.field_73003_n + (this.field_73004_o - this.field_73003_n) * p_72867_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72894_k(float p_72894_1_) {
        this.field_73003_n = p_72894_1_;
        this.field_73004_o = p_72894_1_;
    }

    public boolean func_72911_I() {
        return (double)this.func_72819_i(1.0f) > 0.9;
    }

    public boolean func_72896_J() {
        return (double)this.func_72867_j(1.0f) > 0.2;
    }

    public boolean func_72951_B(int p_72951_1_, int p_72951_2_, int p_72951_3_) {
        if (!this.func_72896_J()) {
            return false;
        }
        if (!this.func_72937_j(p_72951_1_, p_72951_2_, p_72951_3_)) {
            return false;
        }
        if (this.func_72874_g(p_72951_1_, p_72951_3_) > p_72951_2_) {
            return false;
        }
        BiomeGenBase biomeGenBase = this.func_72807_a(p_72951_1_, p_72951_3_);
        if (biomeGenBase.func_76746_c()) {
            return false;
        }
        return biomeGenBase.func_76738_d();
    }

    public boolean func_72958_C(int p_72958_1_, int p_72958_2_, int p_72958_3_) {
        BiomeGenBase biomeGenBase = this.func_72807_a(p_72958_1_, p_72958_3_);
        return biomeGenBase.func_76736_e();
    }

    public void func_72823_a(String p_72823_1_, WorldSavedData p_72823_2_) {
        this.field_72988_C.func_75745_a(p_72823_1_, p_72823_2_);
    }

    public WorldSavedData func_72943_a(Class p_72943_1_, String p_72943_2_) {
        return this.field_72988_C.func_75742_a(p_72943_1_, p_72943_2_);
    }

    public int func_72841_b(String p_72841_1_) {
        return this.field_72988_C.func_75743_a(p_72841_1_);
    }

    public void func_82739_e(int p_82739_1_, int p_82739_2_, int p_82739_3_, int p_82739_4_, int p_82739_5_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_82746_a(p_82739_1_, p_82739_2_, p_82739_3_, p_82739_4_, p_82739_5_);
        }
    }

    public void func_72926_e(int p_72926_1_, int p_72926_2_, int p_72926_3_, int p_72926_4_, int p_72926_5_) {
        this.func_72889_a(null, p_72926_1_, p_72926_2_, p_72926_3_, p_72926_4_, p_72926_5_);
    }

    public void func_72889_a(EntityPlayer p_72889_1_, int p_72889_2_, int p_72889_3_, int p_72889_4_, int p_72889_5_, int p_72889_6_) {
        try {
            for (int i = 0; i < this.field_73021_x.size(); ++i) {
                ((IWorldAccess)this.field_73021_x.get(i)).func_72706_a(p_72889_1_, p_72889_2_, p_72889_3_, p_72889_4_, p_72889_5_, p_72889_6_);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Level event being played");
            crashReportCategory.func_71507_a("Block coordinates", CrashReportCategory.func_85071_a(p_72889_3_, p_72889_4_, p_72889_5_));
            crashReportCategory.func_71507_a("Event source", p_72889_1_);
            crashReportCategory.func_71507_a("Event type", p_72889_2_);
            crashReportCategory.func_71507_a("Event data", p_72889_6_);
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public int func_72800_K() {
        return 256;
    }

    public int func_72940_L() {
        return this.field_73011_w.field_76576_e ? 128 : 256;
    }

    public IUpdatePlayerListBox func_82735_a(EntityMinecart p_82735_1_) {
        return null;
    }

    public Random func_72843_D(int p_72843_1_, int p_72843_2_, int p_72843_3_) {
        long l = (long)p_72843_1_ * 341873128712L + (long)p_72843_2_ * 132897987541L + this.func_72912_H().func_76063_b() + (long)p_72843_3_;
        this.field_73012_v.setSeed(l);
        return this.field_73012_v;
    }

    public ChunkPosition func_72946_b(String p_72946_1_, int p_72946_2_, int p_72946_3_, int p_72946_4_) {
        return this.func_72863_F().func_73150_a(this, p_72946_1_, p_72946_2_, p_72946_3_, p_72946_4_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_72919_O() {
        if (this.field_72986_A.func_76067_t() == WorldType.field_77138_c) {
            return 0.0;
        }
        return 63.0;
    }

    public CrashReportCategory func_72914_a(CrashReport p_72914_1_) {
        CrashReportCategory crashReportCategory = p_72914_1_.func_85057_a("Affected level", 1);
        crashReportCategory.func_71507_a("Level name", this.field_72986_A == null ? "????" : this.field_72986_A.func_76065_j());
        crashReportCategory.func_71500_a("All players", new CallableLvl2(this));
        crashReportCategory.func_71500_a("Chunk stats", new CallableLvl3(this));
        try {
            this.field_72986_A.func_85118_a(crashReportCategory);
        }
        catch (Throwable throwable) {
            crashReportCategory.func_71499_a("Level Data Unobtainable", throwable);
        }
        return crashReportCategory;
    }

    public void func_72888_f(int p_72888_1_, int p_72888_2_, int p_72888_3_, int p_72888_4_, int p_72888_5_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            IWorldAccess iWorldAccess = (IWorldAccess)this.field_73021_x.get(i);
            iWorldAccess.func_72705_a(p_72888_1_, p_72888_2_, p_72888_3_, p_72888_4_, p_72888_5_);
        }
    }

    @Override
    public Vec3Pool func_82732_R() {
        return this.field_82741_K;
    }

    public Calendar func_83015_S() {
        if (this.func_82737_E() % 600L == 0L) {
            this.field_83016_L.setTimeInMillis(MinecraftServer.func_130071_aq());
        }
        return this.field_83016_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_92088_a(double p_92088_1_, double p_92088_3_, double p_92088_5_, double p_92088_7_, double p_92088_9_, double p_92088_11_, NBTTagCompound p_92088_13_) {
    }

    public Scoreboard func_96441_U() {
        return this.field_96442_D;
    }

    public void func_96440_m(int p_96440_1_, int p_96440_2_, int p_96440_3_, int p_96440_4_) {
        for (int i = 0; i < 4; ++i) {
            int n = p_96440_1_ + Direction.field_71583_a[i];
            int n2 = p_96440_3_ + Direction.field_71581_b[i];
            int n3 = this.func_72798_a(n, p_96440_2_, n2);
            if (n3 == 0) continue;
            Block block = Block.field_71973_m[n3];
            if (Block.field_94346_cn.func_94487_f(n3)) {
                block.func_71863_a(this, n, p_96440_2_, n2, p_96440_4_);
                continue;
            }
            if (!Block.func_71932_i(n3)) continue;
            n3 = this.func_72798_a(n += Direction.field_71583_a[i], p_96440_2_, n2 += Direction.field_71581_b[i]);
            block = Block.field_71973_m[n3];
            if (!Block.field_94346_cn.func_94487_f(n3)) continue;
            block.func_71863_a(this, n, p_96440_2_, n2, p_96440_4_);
        }
    }

    public ILogAgent func_98180_V() {
        return this.field_98181_L;
    }

    public float func_110746_b(double p_110746_1_, double p_110746_3_, double p_110746_5_) {
        return this.func_110750_I(MathHelper.func_76128_c(p_110746_1_), MathHelper.func_76128_c(p_110746_3_), MathHelper.func_76128_c(p_110746_5_));
    }

    public float func_110750_I(int p_110750_1_, int p_110750_2_, int p_110750_3_) {
        boolean bl;
        float f = 0.0f;
        boolean bl2 = bl = this.field_73013_u == 3;
        if (this.func_72899_e(p_110750_1_, p_110750_2_, p_110750_3_)) {
            float f2 = this.func_130001_d();
            f += MathHelper.func_76131_a((float)this.func_72938_d((int)p_110750_1_, (int)p_110750_3_).field_111204_q / 3600000.0f, 0.0f, 1.0f) * (bl ? 1.0f : 0.75f);
            f += f2 * 0.25f;
        }
        if (this.field_73013_u < 2) {
            f *= (float)this.field_73013_u / 2.0f;
        }
        return MathHelper.func_76131_a(f, 0.0f, bl ? 1.5f : 1.0f);
    }
}

