/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.AnvilChunkLoaderPending;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;

public class AnvilChunkLoader
implements IChunkLoader,
IThreadedFileIO {
    private List field_75828_a = new ArrayList();
    private Set field_75826_b = new HashSet();
    private Object field_75827_c = new Object();
    public final File field_75825_d;

    public AnvilChunkLoader(File p_i2003_1_) {
        this.field_75825_d = p_i2003_1_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk func_75815_a(World p_75815_1_, int p_75815_2_, int p_75815_3_) throws IOException {
        NBTTagCompound nBTTagCompound = null;
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(p_75815_2_, p_75815_3_);
        Object object = this.field_75827_c;
        synchronized (object) {
            if (this.field_75826_b.contains(chunkCoordIntPair)) {
                for (int i = 0; i < this.field_75828_a.size(); ++i) {
                    if (!((AnvilChunkLoaderPending)this.field_75828_a.get((int)i)).field_76548_a.equals(chunkCoordIntPair)) continue;
                    nBTTagCompound = ((AnvilChunkLoaderPending)this.field_75828_a.get((int)i)).field_76547_b;
                    break;
                }
            }
        }
        if (nBTTagCompound == null) {
            object = RegionFileCache.func_76549_c(this.field_75825_d, p_75815_2_, p_75815_3_);
            if (object != null) {
                nBTTagCompound = CompressedStreamTools.func_74794_a((DataInput)object);
            } else {
                return null;
            }
        }
        return this.func_75822_a(p_75815_1_, p_75815_2_, p_75815_3_, nBTTagCompound);
    }

    protected Chunk func_75822_a(World p_75822_1_, int p_75822_2_, int p_75822_3_, NBTTagCompound p_75822_4_) {
        if (!p_75822_4_.func_74764_b("Level")) {
            p_75822_1_.func_98180_V().func_98232_c("Chunk file at " + p_75822_2_ + "," + p_75822_3_ + " is missing level data, skipping");
            return null;
        }
        if (!p_75822_4_.func_74775_l("Level").func_74764_b("Sections")) {
            p_75822_1_.func_98180_V().func_98232_c("Chunk file at " + p_75822_2_ + "," + p_75822_3_ + " is missing block data, skipping");
            return null;
        }
        Chunk chunk = this.func_75823_a(p_75822_1_, p_75822_4_.func_74775_l("Level"));
        if (!chunk.func_76600_a(p_75822_2_, p_75822_3_)) {
            p_75822_1_.func_98180_V().func_98232_c("Chunk file at " + p_75822_2_ + "," + p_75822_3_ + " is in the wrong location; relocating. (Expected " + p_75822_2_ + ", " + p_75822_3_ + ", got " + chunk.field_76635_g + ", " + chunk.field_76647_h + ")");
            p_75822_4_.func_74768_a("xPos", p_75822_2_);
            p_75822_4_.func_74768_a("zPos", p_75822_3_);
            chunk = this.func_75823_a(p_75822_1_, p_75822_4_.func_74775_l("Level"));
        }
        return chunk;
    }

    @Override
    public void func_75816_a(World p_75816_1_, Chunk p_75816_2_) throws MinecraftException, IOException {
        p_75816_1_.func_72906_B();
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound.func_74782_a("Level", nBTTagCompound2);
            this.func_75820_a(p_75816_2_, p_75816_1_, nBTTagCompound2);
            this.func_75824_a(p_75816_2_.func_76632_l(), nBTTagCompound);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_75824_a(ChunkCoordIntPair p_75824_1_, NBTTagCompound p_75824_2_) {
        Object object = this.field_75827_c;
        synchronized (object) {
            if (this.field_75826_b.contains(p_75824_1_)) {
                for (int i = 0; i < this.field_75828_a.size(); ++i) {
                    if (!((AnvilChunkLoaderPending)this.field_75828_a.get((int)i)).field_76548_a.equals(p_75824_1_)) continue;
                    this.field_75828_a.set(i, new AnvilChunkLoaderPending(p_75824_1_, p_75824_2_));
                    return;
                }
            }
            this.field_75828_a.add(new AnvilChunkLoaderPending(p_75824_1_, p_75824_2_));
            this.field_75826_b.add(p_75824_1_);
            ThreadedFileIOBase.field_75741_a.func_75735_a(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_75814_c() {
        AnvilChunkLoaderPending anvilChunkLoaderPending = null;
        Object object = this.field_75827_c;
        synchronized (object) {
            if (this.field_75828_a.isEmpty()) {
                return false;
            }
            anvilChunkLoaderPending = (AnvilChunkLoaderPending)this.field_75828_a.remove(0);
            this.field_75826_b.remove(anvilChunkLoaderPending.field_76548_a);
        }
        if (anvilChunkLoaderPending != null) {
            try {
                this.func_75821_a(anvilChunkLoaderPending);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    private void func_75821_a(AnvilChunkLoaderPending p_75821_1_) throws IOException {
        DataOutputStream dataOutputStream = RegionFileCache.func_76552_d(this.field_75825_d, p_75821_1_.field_76548_a.field_77276_a, p_75821_1_.field_76548_a.field_77275_b);
        CompressedStreamTools.func_74800_a(p_75821_1_.field_76547_b, dataOutputStream);
        dataOutputStream.close();
    }

    @Override
    public void func_75819_b(World p_75819_1_, Chunk p_75819_2_) {
    }

    @Override
    public void func_75817_a() {
    }

    @Override
    public void func_75818_b() {
        while (this.func_75814_c()) {
        }
    }

    private void func_75820_a(Chunk p_75820_1_, World p_75820_2_, NBTTagCompound p_75820_3_) {
        NBTTagCompound nBTTagCompound;
        p_75820_3_.func_74768_a("xPos", p_75820_1_.field_76635_g);
        p_75820_3_.func_74768_a("zPos", p_75820_1_.field_76647_h);
        p_75820_3_.func_74772_a("LastUpdate", p_75820_2_.func_82737_E());
        p_75820_3_.func_74783_a("HeightMap", p_75820_1_.field_76634_f);
        p_75820_3_.func_74757_a("TerrainPopulated", p_75820_1_.field_76646_k);
        p_75820_3_.func_74772_a("InhabitedTime", p_75820_1_.field_111204_q);
        ExtendedBlockStorage[] extendedBlockStorageArray = p_75820_1_.func_76587_i();
        NBTTagList nBTTagList = new NBTTagList("Sections");
        boolean bl = !p_75820_2_.field_73011_w.field_76576_e;
        for (ExtendedBlockStorage object : extendedBlockStorageArray) {
            if (object == null) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74774_a("Y", (byte)(object.func_76662_d() >> 4 & 0xFF));
            nBTTagCompound.func_74773_a("Blocks", object.func_76658_g());
            if (object.func_76660_i() != null) {
                nBTTagCompound.func_74773_a("Add", object.func_76660_i().field_76585_a);
            }
            nBTTagCompound.func_74773_a("Data", object.func_76669_j().field_76585_a);
            nBTTagCompound.func_74773_a("BlockLight", object.func_76661_k().field_76585_a);
            if (bl) {
                nBTTagCompound.func_74773_a("SkyLight", object.func_76671_l().field_76585_a);
            } else {
                nBTTagCompound.func_74773_a("SkyLight", new byte[object.func_76661_k().field_76585_a.length]);
            }
            nBTTagList.func_74742_a(nBTTagCompound);
        }
        p_75820_3_.func_74782_a("Sections", nBTTagList);
        p_75820_3_.func_74773_a("Biomes", p_75820_1_.func_76605_m());
        p_75820_1_.field_76644_m = false;
        NBTTagList nBTTagList2 = new NBTTagList();
        for (int i = 0; i < p_75820_1_.field_76645_j.length; ++i) {
            for (Entity entity : p_75820_1_.field_76645_j[i]) {
                if (!entity.func_70039_c(nBTTagCompound = new NBTTagCompound())) continue;
                p_75820_1_.field_76644_m = true;
                nBTTagList2.func_74742_a(nBTTagCompound);
            }
        }
        p_75820_3_.func_74782_a("Entities", nBTTagList2);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (TileEntity tileEntity : p_75820_1_.field_76648_i.values()) {
            nBTTagCompound = new NBTTagCompound();
            tileEntity.func_70310_b(nBTTagCompound);
            nBTTagList3.func_74742_a(nBTTagCompound);
        }
        p_75820_3_.func_74782_a("TileEntities", nBTTagList3);
        List list = p_75820_2_.func_72920_a(p_75820_1_, false);
        if (list != null) {
            long l = p_75820_2_.func_82737_E();
            NBTTagList nBTTagList4 = new NBTTagList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.func_74768_a("i", nextTickListEntry.field_77179_d);
                nBTTagCompound2.func_74768_a("x", nextTickListEntry.field_77183_a);
                nBTTagCompound2.func_74768_a("y", nextTickListEntry.field_77181_b);
                nBTTagCompound2.func_74768_a("z", nextTickListEntry.field_77182_c);
                nBTTagCompound2.func_74768_a("t", (int)(nextTickListEntry.field_77180_e - l));
                nBTTagCompound2.func_74768_a("p", nextTickListEntry.field_82754_f);
                nBTTagList4.func_74742_a(nBTTagCompound2);
            }
            p_75820_3_.func_74782_a("TileTicks", nBTTagList4);
        }
    }

    private Chunk func_75823_a(World p_75823_1_, NBTTagCompound p_75823_2_) {
        NBTTagList nBTTagList;
        NBTTagList nBTTagList2;
        Object object;
        NBTTagList nBTTagList3;
        Object object2;
        int n = p_75823_2_.func_74762_e("xPos");
        int n2 = p_75823_2_.func_74762_e("zPos");
        Chunk chunk = new Chunk(p_75823_1_, n, n2);
        chunk.field_76634_f = p_75823_2_.func_74759_k("HeightMap");
        chunk.field_76646_k = p_75823_2_.func_74767_n("TerrainPopulated");
        chunk.field_111204_q = p_75823_2_.func_74763_f("InhabitedTime");
        NBTTagList nBTTagList4 = p_75823_2_.func_74761_m("Sections");
        int n3 = 16;
        ExtendedBlockStorage[] extendedBlockStorageArray = new ExtendedBlockStorage[n3];
        boolean bl = !p_75823_1_.field_73011_w.field_76576_e;
        for (int i = 0; i < nBTTagList4.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList4.func_74743_b(i);
            byte by = nBTTagCompound.func_74771_c("Y");
            object2 = new ExtendedBlockStorage(by << 4, bl);
            ((ExtendedBlockStorage)object2).func_76664_a(nBTTagCompound.func_74770_j("Blocks"));
            if (nBTTagCompound.func_74764_b("Add")) {
                ((ExtendedBlockStorage)object2).func_76673_a(new NibbleArray(nBTTagCompound.func_74770_j("Add"), 4));
            }
            ((ExtendedBlockStorage)object2).func_76668_b(new NibbleArray(nBTTagCompound.func_74770_j("Data"), 4));
            ((ExtendedBlockStorage)object2).func_76659_c(new NibbleArray(nBTTagCompound.func_74770_j("BlockLight"), 4));
            if (bl) {
                ((ExtendedBlockStorage)object2).func_76666_d(new NibbleArray(nBTTagCompound.func_74770_j("SkyLight"), 4));
            }
            ((ExtendedBlockStorage)object2).func_76672_e();
            extendedBlockStorageArray[by] = object2;
        }
        chunk.func_76602_a(extendedBlockStorageArray);
        if (p_75823_2_.func_74764_b("Biomes")) {
            chunk.func_76616_a(p_75823_2_.func_74770_j("Biomes"));
        }
        if ((nBTTagList3 = p_75823_2_.func_74761_m("Entities")) != null) {
            for (int i = 0; i < nBTTagList3.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList3.func_74743_b(i);
                object2 = EntityList.func_75615_a(nBTTagCompound, p_75823_1_);
                chunk.field_76644_m = true;
                if (object2 == null) continue;
                chunk.func_76612_a((Entity)object2);
                object = object2;
                NBTTagCompound nBTTagCompound2 = nBTTagCompound;
                while (nBTTagCompound2.func_74764_b("Riding")) {
                    Entity entity = EntityList.func_75615_a(nBTTagCompound2.func_74775_l("Riding"), p_75823_1_);
                    if (entity != null) {
                        chunk.func_76612_a(entity);
                        ((Entity)object).func_70078_a(entity);
                    }
                    object = entity;
                    nBTTagCompound2 = nBTTagCompound2.func_74775_l("Riding");
                }
            }
        }
        if ((nBTTagList2 = p_75823_2_.func_74761_m("TileEntities")) != null) {
            for (int i = 0; i < nBTTagList2.func_74745_c(); ++i) {
                object2 = (NBTTagCompound)nBTTagList2.func_74743_b(i);
                object = TileEntity.func_70317_c((NBTTagCompound)object2);
                if (object == null) continue;
                chunk.func_76620_a((TileEntity)object);
            }
        }
        if (p_75823_2_.func_74764_b("TileTicks") && (nBTTagList = p_75823_2_.func_74761_m("TileTicks")) != null) {
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                object = (NBTTagCompound)nBTTagList.func_74743_b(i);
                p_75823_1_.func_72892_b(((NBTTagCompound)object).func_74762_e("x"), ((NBTTagCompound)object).func_74762_e("y"), ((NBTTagCompound)object).func_74762_e("z"), ((NBTTagCompound)object).func_74762_e("i"), ((NBTTagCompound)object).func_74762_e("t"), ((NBTTagCompound)object).func_74762_e("p"));
            }
        }
        return chunk;
    }
}

