/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.logging.ILogAgent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SharedMonsterAttributes {
    public static final Attribute field_111267_a = new RangedAttribute("generic.maxHealth", 20.0, 0.0, Double.MAX_VALUE).func_111117_a("Max Health").func_111112_a(true);
    public static final Attribute field_111265_b = new RangedAttribute("generic.followRange", 32.0, 0.0, 2048.0).func_111117_a("Follow Range");
    public static final Attribute field_111266_c = new RangedAttribute("generic.knockbackResistance", 0.0, 0.0, 1.0).func_111117_a("Knockback Resistance");
    public static final Attribute field_111263_d = new RangedAttribute("generic.movementSpeed", 0.7f, 0.0, Double.MAX_VALUE).func_111117_a("Movement Speed").func_111112_a(true);
    public static final Attribute field_111264_e = new RangedAttribute("generic.attackDamage", 2.0, 0.0, Double.MAX_VALUE);

    public static NBTTagList func_111257_a(BaseAttributeMap p_111257_0_) {
        NBTTagList nBTTagList = new NBTTagList();
        for (AttributeInstance attributeInstance : p_111257_0_.func_111146_a()) {
            nBTTagList.func_74742_a(SharedMonsterAttributes.func_111261_a(attributeInstance));
        }
        return nBTTagList;
    }

    private static NBTTagCompound func_111261_a(AttributeInstance p_111261_0_) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        Attribute attribute = p_111261_0_.func_111123_a();
        nBTTagCompound.func_74778_a("Name", attribute.func_111108_a());
        nBTTagCompound.func_74780_a("Base", p_111261_0_.func_111125_b());
        Collection collection = p_111261_0_.func_111122_c();
        if (collection != null && !collection.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (AttributeModifier attributeModifier : collection) {
                if (!attributeModifier.func_111165_e()) continue;
                nBTTagList.func_74742_a(SharedMonsterAttributes.func_111262_a(attributeModifier));
            }
            nBTTagCompound.func_74782_a("Modifiers", nBTTagList);
        }
        return nBTTagCompound;
    }

    private static NBTTagCompound func_111262_a(AttributeModifier p_111262_0_) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("Name", p_111262_0_.func_111166_b());
        nBTTagCompound.func_74780_a("Amount", p_111262_0_.func_111164_d());
        nBTTagCompound.func_74768_a("Operation", p_111262_0_.func_111169_c());
        nBTTagCompound.func_74772_a("UUIDMost", p_111262_0_.func_111167_a().getMostSignificantBits());
        nBTTagCompound.func_74772_a("UUIDLeast", p_111262_0_.func_111167_a().getLeastSignificantBits());
        return nBTTagCompound;
    }

    public static void func_111260_a(BaseAttributeMap p_111260_0_, NBTTagList p_111260_1_, ILogAgent p_111260_2_) {
        for (int i = 0; i < p_111260_1_.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)p_111260_1_.func_74743_b(i);
            AttributeInstance attributeInstance = p_111260_0_.func_111152_a(nBTTagCompound.func_74779_i("Name"));
            if (attributeInstance != null) {
                SharedMonsterAttributes.func_111258_a(attributeInstance, nBTTagCompound);
                continue;
            }
            if (p_111260_2_ == null) continue;
            p_111260_2_.func_98236_b("Ignoring unknown attribute '" + nBTTagCompound.func_74779_i("Name") + "'");
        }
    }

    private static void func_111258_a(AttributeInstance p_111258_0_, NBTTagCompound p_111258_1_) {
        p_111258_0_.func_111128_a(p_111258_1_.func_74769_h("Base"));
        if (p_111258_1_.func_74764_b("Modifiers")) {
            NBTTagList nBTTagList = p_111258_1_.func_74761_m("Modifiers");
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                AttributeModifier attributeModifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)nBTTagList.func_74743_b(i));
                AttributeModifier attributeModifier2 = p_111258_0_.func_111127_a(attributeModifier.func_111167_a());
                if (attributeModifier2 != null) {
                    p_111258_0_.func_111124_b(attributeModifier2);
                }
                p_111258_0_.func_111121_a(attributeModifier);
            }
        }
    }

    public static AttributeModifier func_111259_a(NBTTagCompound p_111259_0_) {
        UUID uUID = new UUID(p_111259_0_.func_74763_f("UUIDMost"), p_111259_0_.func_74763_f("UUIDLeast"));
        return new AttributeModifier(uUID, p_111259_0_.func_74779_i("Name"), p_111259_0_.func_74769_h("Amount"), p_111259_0_.func_74762_e("Operation"));
    }
}

