/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.WatchableObject;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ReportedException;

public class DataWatcher {
    private boolean field_92086_a = true;
    private static final HashMap field_75697_a = new HashMap();
    private final Map field_75695_b = new HashMap();
    private boolean field_75696_c;
    private ReadWriteLock field_75694_d = new ReentrantReadWriteLock();

    public void func_75682_a(int p_75682_1_, Object p_75682_2_) {
        Integer n = (Integer)field_75697_a.get(p_75682_2_.getClass());
        if (n == null) {
            throw new IllegalArgumentException("Unknown data type: " + p_75682_2_.getClass());
        }
        if (p_75682_1_ > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + p_75682_1_ + "! (Max is " + 31 + ")");
        }
        if (this.field_75695_b.containsKey(p_75682_1_)) {
            throw new IllegalArgumentException("Duplicate id value for " + p_75682_1_ + "!");
        }
        WatchableObject watchableObject = new WatchableObject(n, p_75682_1_, p_75682_2_);
        this.field_75694_d.writeLock().lock();
        this.field_75695_b.put(p_75682_1_, watchableObject);
        this.field_75694_d.writeLock().unlock();
        this.field_92086_a = false;
    }

    public void func_82709_a(int p_82709_1_, int p_82709_2_) {
        WatchableObject watchableObject = new WatchableObject(p_82709_2_, p_82709_1_, null);
        this.field_75694_d.writeLock().lock();
        this.field_75695_b.put(p_82709_1_, watchableObject);
        this.field_75694_d.writeLock().unlock();
        this.field_92086_a = false;
    }

    public byte func_75683_a(int p_75683_1_) {
        return (Byte)this.func_75691_i(p_75683_1_).func_75669_b();
    }

    public short func_75693_b(int p_75693_1_) {
        return (Short)this.func_75691_i(p_75693_1_).func_75669_b();
    }

    public int func_75679_c(int p_75679_1_) {
        return (Integer)this.func_75691_i(p_75679_1_).func_75669_b();
    }

    public float func_111145_d(int p_111145_1_) {
        return ((Float)this.func_75691_i(p_111145_1_).func_75669_b()).floatValue();
    }

    public String func_75681_e(int p_75681_1_) {
        return (String)this.func_75691_i(p_75681_1_).func_75669_b();
    }

    public ItemStack func_82710_f(int p_82710_1_) {
        return (ItemStack)this.func_75691_i(p_82710_1_).func_75669_b();
    }

    private WatchableObject func_75691_i(int p_75691_1_) {
        WatchableObject watchableObject;
        this.field_75694_d.readLock().lock();
        try {
            watchableObject = (WatchableObject)this.field_75695_b.get(p_75691_1_);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Getting synched entity data");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Synched entity data");
            crashReportCategory.func_71507_a("Data ID", p_75691_1_);
            throw new ReportedException(crashReport);
        }
        this.field_75694_d.readLock().unlock();
        return watchableObject;
    }

    public void func_75692_b(int p_75692_1_, Object p_75692_2_) {
        WatchableObject watchableObject = this.func_75691_i(p_75692_1_);
        if (!p_75692_2_.equals(watchableObject.func_75669_b())) {
            watchableObject.func_75673_a(p_75692_2_);
            watchableObject.func_75671_a(true);
            this.field_75696_c = true;
        }
    }

    public void func_82708_h(int p_82708_1_) {
        WatchableObject.func_82711_a(this.func_75691_i(p_82708_1_), true);
        this.field_75696_c = true;
    }

    public boolean func_75684_a() {
        return this.field_75696_c;
    }

    public static void func_75680_a(List p_75680_0_, DataOutput p_75680_1_) throws IOException {
        if (p_75680_0_ != null) {
            for (WatchableObject watchableObject : p_75680_0_) {
                DataWatcher.func_75690_a(p_75680_1_, watchableObject);
            }
        }
        p_75680_1_.writeByte(127);
    }

    public List func_75688_b() {
        ArrayList<WatchableObject> arrayList = null;
        if (this.field_75696_c) {
            this.field_75694_d.readLock().lock();
            for (WatchableObject watchableObject : this.field_75695_b.values()) {
                if (!watchableObject.func_75670_d()) continue;
                watchableObject.func_75671_a(false);
                if (arrayList == null) {
                    arrayList = new ArrayList<WatchableObject>();
                }
                arrayList.add(watchableObject);
            }
            this.field_75694_d.readLock().unlock();
        }
        this.field_75696_c = false;
        return arrayList;
    }

    public void func_75689_a(DataOutput p_75689_1_) throws IOException {
        this.field_75694_d.readLock().lock();
        for (WatchableObject watchableObject : this.field_75695_b.values()) {
            DataWatcher.func_75690_a(p_75689_1_, watchableObject);
        }
        this.field_75694_d.readLock().unlock();
        p_75689_1_.writeByte(127);
    }

    public List func_75685_c() {
        ArrayList<WatchableObject> arrayList = null;
        this.field_75694_d.readLock().lock();
        for (WatchableObject watchableObject : this.field_75695_b.values()) {
            if (arrayList == null) {
                arrayList = new ArrayList<WatchableObject>();
            }
            arrayList.add(watchableObject);
        }
        this.field_75694_d.readLock().unlock();
        return arrayList;
    }

    private static void func_75690_a(DataOutput p_75690_0_, WatchableObject p_75690_1_) throws IOException {
        int n = (p_75690_1_.func_75674_c() << 5 | p_75690_1_.func_75672_a() & 0x1F) & 0xFF;
        p_75690_0_.writeByte(n);
        switch (p_75690_1_.func_75674_c()) {
            case 0: {
                p_75690_0_.writeByte(((Byte)p_75690_1_.func_75669_b()).byteValue());
                break;
            }
            case 1: {
                p_75690_0_.writeShort(((Short)p_75690_1_.func_75669_b()).shortValue());
                break;
            }
            case 2: {
                p_75690_0_.writeInt((Integer)p_75690_1_.func_75669_b());
                break;
            }
            case 3: {
                p_75690_0_.writeFloat(((Float)p_75690_1_.func_75669_b()).floatValue());
                break;
            }
            case 4: {
                Packet.func_73271_a((String)p_75690_1_.func_75669_b(), p_75690_0_);
                break;
            }
            case 5: {
                ItemStack itemStack = (ItemStack)p_75690_1_.func_75669_b();
                Packet.func_73270_a(itemStack, p_75690_0_);
                break;
            }
            case 6: {
                ChunkCoordinates chunkCoordinates = (ChunkCoordinates)p_75690_1_.func_75669_b();
                p_75690_0_.writeInt(chunkCoordinates.field_71574_a);
                p_75690_0_.writeInt(chunkCoordinates.field_71572_b);
                p_75690_0_.writeInt(chunkCoordinates.field_71573_c);
            }
        }
    }

    public static List func_75686_a(DataInput p_75686_0_) throws IOException {
        ArrayList<WatchableObject> arrayList = null;
        byte by = p_75686_0_.readByte();
        while (by != 127) {
            if (arrayList == null) {
                arrayList = new ArrayList<WatchableObject>();
            }
            int n = (by & 0xE0) >> 5;
            int n2 = by & 0x1F;
            WatchableObject watchableObject = null;
            switch (n) {
                case 0: {
                    watchableObject = new WatchableObject(n, n2, p_75686_0_.readByte());
                    break;
                }
                case 1: {
                    watchableObject = new WatchableObject(n, n2, p_75686_0_.readShort());
                    break;
                }
                case 2: {
                    watchableObject = new WatchableObject(n, n2, p_75686_0_.readInt());
                    break;
                }
                case 3: {
                    watchableObject = new WatchableObject(n, n2, Float.valueOf(p_75686_0_.readFloat()));
                    break;
                }
                case 4: {
                    watchableObject = new WatchableObject(n, n2, Packet.func_73282_a(p_75686_0_, 64));
                    break;
                }
                case 5: {
                    watchableObject = new WatchableObject(n, n2, Packet.func_73276_c(p_75686_0_));
                    break;
                }
                case 6: {
                    int n3 = p_75686_0_.readInt();
                    int n4 = p_75686_0_.readInt();
                    int n5 = p_75686_0_.readInt();
                    watchableObject = new WatchableObject(n, n2, new ChunkCoordinates(n3, n4, n5));
                }
            }
            arrayList.add(watchableObject);
            by = p_75686_0_.readByte();
        }
        return arrayList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75687_a(List p_75687_1_) {
        this.field_75694_d.writeLock().lock();
        for (WatchableObject watchableObject : p_75687_1_) {
            WatchableObject watchableObject2 = (WatchableObject)this.field_75695_b.get(watchableObject.func_75672_a());
            if (watchableObject2 == null) continue;
            watchableObject2.func_75673_a(watchableObject.func_75669_b());
        }
        this.field_75694_d.writeLock().unlock();
        this.field_75696_c = true;
    }

    public boolean func_92085_d() {
        return this.field_92086_a;
    }

    public void func_111144_e() {
        this.field_75696_c = false;
    }

    static {
        field_75697_a.put(Byte.class, 0);
        field_75697_a.put(Short.class, 1);
        field_75697_a.put(Integer.class, 2);
        field_75697_a.put(Float.class, 3);
        field_75697_a.put(String.class, 4);
        field_75697_a.put(ItemStack.class, 5);
        field_75697_a.put(ChunkCoordinates.class, 6);
    }
}

