package net.minecraft.village;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.village.MerchantRecipe;

public class MerchantRecipeList extends ArrayList {

   public MerchantRecipeList() {}

   public MerchantRecipeList(NBTTagCompound p_i1944_1_) {
      this.func_77201_a(p_i1944_1_);
   }

   public MerchantRecipe func_77203_a(ItemStack p_77203_1_, ItemStack p_77203_2_, int p_77203_3_) {
      if(p_77203_3_ > 0 && p_77203_3_ < this.size()) {
         MerchantRecipe var6 = (MerchantRecipe)this.get(p_77203_3_);
         return p_77203_1_.field_77993_c == var6.func_77394_a().field_77993_c && (p_77203_2_ == null && !var6.func_77398_c() || var6.func_77398_c() && p_77203_2_ != null && var6.func_77396_b().field_77993_c == p_77203_2_.field_77993_c) && p_77203_1_.field_77994_a >= var6.func_77394_a().field_77994_a && (!var6.func_77398_c() || p_77203_2_.field_77994_a >= var6.func_77396_b().field_77994_a)?var6:null;
      } else {
         for(int var4 = 0; var4 < this.size(); ++var4) {
            MerchantRecipe var5 = (MerchantRecipe)this.get(var4);
            if(p_77203_1_.field_77993_c == var5.func_77394_a().field_77993_c && p_77203_1_.field_77994_a >= var5.func_77394_a().field_77994_a && (!var5.func_77398_c() && p_77203_2_ == null || var5.func_77398_c() && p_77203_2_ != null && var5.func_77396_b().field_77993_c == p_77203_2_.field_77993_c && p_77203_2_.field_77994_a >= var5.func_77396_b().field_77994_a)) {
               return var5;
            }
         }

         return null;
      }
   }

   public void func_77205_a(MerchantRecipe p_77205_1_) {
      for(int var2 = 0; var2 < this.size(); ++var2) {
         MerchantRecipe var3 = (MerchantRecipe)this.get(var2);
         if(p_77205_1_.func_77393_a(var3)) {
            if(p_77205_1_.func_77391_b(var3)) {
               this.set(var2, p_77205_1_);
            }

            return;
         }
      }

      this.add(p_77205_1_);
   }

   public void func_77200_a(DataOutputStream p_77200_1_) throws IOException {
      p_77200_1_.writeByte((byte)(this.size() & 255));

      for(int var2 = 0; var2 < this.size(); ++var2) {
         MerchantRecipe var3 = (MerchantRecipe)this.get(var2);
         Packet.func_73270_a(var3.func_77394_a(), p_77200_1_);
         Packet.func_73270_a(var3.func_77397_d(), p_77200_1_);
         ItemStack var4 = var3.func_77396_b();
         p_77200_1_.writeBoolean(var4 != null);
         if(var4 != null) {
            Packet.func_73270_a(var4, p_77200_1_);
         }

         p_77200_1_.writeBoolean(var3.func_82784_g());
      }

   }

   @SideOnly(Side.CLIENT)
   public static MerchantRecipeList func_77204_a(DataInputStream p_77204_0_) throws IOException {
      MerchantRecipeList var1 = new MerchantRecipeList();
      int var2 = p_77204_0_.readByte() & 255;

      for(int var3 = 0; var3 < var2; ++var3) {
         ItemStack var4 = Packet.func_73276_c(p_77204_0_);
         ItemStack var5 = Packet.func_73276_c(p_77204_0_);
         ItemStack var6 = null;
         if(p_77204_0_.readBoolean()) {
            var6 = Packet.func_73276_c(p_77204_0_);
         }

         boolean var7 = p_77204_0_.readBoolean();
         MerchantRecipe var8 = new MerchantRecipe(var4, var6, var5);
         if(var7) {
            var8.func_82785_h();
         }

         var1.add(var8);
      }

      return var1;
   }

   public void func_77201_a(NBTTagCompound p_77201_1_) {
      NBTTagList var2 = p_77201_1_.func_74761_m("Recipes");

      for(int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
         NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
         this.add(new MerchantRecipe(var4));
      }

   }

   public NBTTagCompound func_77202_a() {
      NBTTagCompound var1 = new NBTTagCompound();
      NBTTagList var2 = new NBTTagList("Recipes");

      for(int var3 = 0; var3 < this.size(); ++var3) {
         MerchantRecipe var4 = (MerchantRecipe)this.get(var3);
         var2.func_74742_a(var4.func_77395_g());
      }

      var1.func_74782_a("Recipes", var2);
      return var1;
   }
}
