/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.item.CrystalshotItem;

public record CrystalshotModule(int durabilityUsage, boolean checkStandardArrows) implements ModifierModule,
BowAmmoModifierHook,
ModifierRemovalHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BOW_AMMO, ModifierHooks.REMOVE);
    public static final RecordLoadable<CrystalshotModule> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ZERO.requiredField("durability_usage", CrystalshotModule::durabilityUsage), (RecordField)BooleanLoadable.INSTANCE.defaultField("check_standard_arrows", Boolean.valueOf(true), CrystalshotModule::checkStandardArrows), CrystalshotModule::new);

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        if (this.checkStandardArrows && !standardAmmo.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int count = this.durabilityUsage <= 0 ? 64 : Math.min(64, (tool.getCurrentDurability() + this.durabilityUsage - 1) / this.durabilityUsage);
        return CrystalshotItem.withVariant(tool.getPersistentData().getString(modifier.getId()), count);
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        if (this.durabilityUsage > 0) {
            ToolDamageUtil.damageAnimated(tool, this.durabilityUsage * needed, shooter, shooter.m_7655_());
        }
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(modifier.getId());
        return null;
    }
}

