/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.item.LecternBookItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.common.network.UpdateInventoryPagePacket;
import slimeknights.tconstruct.library.client.book.TinkerBook;
import slimeknights.tconstruct.library.tools.capability.inventory.InventorySlotMenuModule;

public class TinkerBookItem
extends LecternBookItem {
    private static final Component CLICK_TO_OPEN = TConstruct.makeTranslation("item", "book.click_to_open").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});
    private final BookType bookType;

    public TinkerBookItem(Item.Properties props, BookType bookType) {
        super(props);
        this.bookType = bookType;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        Player player;
        if (world != null && world.f_46443_ && (player = SafeClientAccess.getPlayer()) != null && InventorySlotMenuModule.isValidContainer(player.f_36096_)) {
            Inventory inventory = player.m_150109_();
            if (inventory.f_35974_.contains((Object)stack) || inventory.f_35976_.contains((Object)stack)) {
                tooltip.add(CLICK_TO_OPEN);
            }
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            TinkerBook.getBook(this.bookType).openGui(hand, stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void openLecternScreenClient(BlockPos pos, ItemStack stack) {
        TinkerBook.getBook(this.bookType).openGui(pos, stack);
    }

    public boolean m_142305_(ItemStack stack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && held.m_41619_() && slot.f_40218_ == player.m_150109_() && slot.m_150651_(player) && InventorySlotMenuModule.isValidContainer(player.f_36096_)) {
            if (player.m_9236_().f_46443_) {
                player.f_36096_.m_150444_();
                player.m_6915_();
                int index = slot.getSlotIndex();
                String page = BookHelper.getCurrentSavedPage((ItemStack)stack);
                TinkerBook.getBook(this.bookType).openGui(stack.m_41786_(), page, newPage -> {
                    BookHelper.writeSavedPageToBook((ItemStack)player.m_150109_().m_8020_(index), (String)newPage);
                    TinkerNetwork.getInstance().sendToServer(new UpdateInventoryPagePacket(index, (String)newPage));
                });
            }
            return true;
        }
        return false;
    }

    public static enum BookType {
        MATERIALS_AND_YOU,
        PUNY_SMELTING,
        MIGHTY_SMELTING,
        TINKERS_GADGETRY,
        FANTASTIC_FOUNDRY,
        ENCYCLOPEDIA;

    }
}

