/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.modifiers.SlotIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ModifierRecipeCategory
implements IRecipeCategory<IDisplayModifierRecipe> {
    protected static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "modifiers.title");
    private static final List<Component> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_MIN = TConstruct.makeTranslationKey("jei", "modifiers.level.min");
    private static final String KEY_MAX = TConstruct.makeTranslationKey("jei", "modifiers.level.max");
    private static final String KEY_RANGE = TConstruct.makeTranslationKey("jei", "modifiers.level.range");
    private static final String KEY_EXACT = TConstruct.makeTranslationKey("jei", "modifiers.level.exact");
    private final ModifierIngredientRenderer modifierRenderer = new ModifierIngredientRenderer(124, 10);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable requirements;
    private final IDrawable incremental;
    private final IDrawable[] slotIcons;
    private static List<ItemStack> SLIMESKULL_HELMETS = null;

    public ModifierRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CreativeSlotItem.withSlot(new ItemStack(TinkerModifiers.creativeSlotItem), SlotType.UPGRADE));
        this.slotIcons = new IDrawable[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = helper.createDrawable(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = helper.createDrawable(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = helper.createDrawable(BACKGROUND_LOC, 128, 33, 16, 16);
    }

    public RecipeType<IDisplayModifierRecipe> getRecipeType() {
        return TConstructJEIConstants.MODIFIERS;
    }

    public Component getTitle() {
        return TITLE;
    }

    private void drawSlot(GuiGraphics graphics, IDisplayModifierRecipe recipe, int slot, int x, int y) {
        List<ItemStack> stacks = recipe.getDisplayItems(slot);
        if (stacks.isEmpty()) {
            this.slotIcons[slot].draw(graphics, x + 1, y + 1);
        }
    }

    public void draw(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        SlotType.SlotCount slots;
        this.drawSlot(graphics, recipe, 0, 2, 32);
        this.drawSlot(graphics, recipe, 1, 24, 14);
        this.drawSlot(graphics, recipe, 2, 46, 32);
        this.drawSlot(graphics, recipe, 3, 42, 57);
        this.drawSlot(graphics, recipe, 4, 6, 57);
        ModifierEntry result = recipe.getDisplayResult();
        if (result.getHook(ModifierHooks.REQUIREMENTS).requirementsError(result) != null) {
            this.requirements.draw(graphics, 66, 58);
        }
        if (recipe.isIncremental()) {
            this.incremental.draw(graphics, 83, 59);
        }
        Component levelText = null;
        Component variant = recipe.getVariant();
        if (variant != null) {
            levelText = variant;
        } else {
            IntRange level = recipe.getLevel();
            int min = level.min();
            int max = level.max();
            if (min == 1) {
                if (max < ModifierEntry.VALID_LEVEL.max()) {
                    levelText = Component.m_237110_((String)KEY_MAX, (Object[])new Object[]{max});
                }
            } else {
                levelText = min == max ? Component.m_237110_((String)KEY_EXACT, (Object[])new Object[]{min}) : (max == ModifierEntry.VALID_LEVEL.max() ? Component.m_237110_((String)KEY_MIN, (Object[])new Object[]{min}) : Component.m_237110_((String)KEY_RANGE, (Object[])new Object[]{min, max}));
            }
        }
        if (levelText != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            graphics.m_280614_(fontRenderer, levelText, 86 - fontRenderer.m_92852_((FormattedText)levelText) / 2, 16, Color.GRAY.getRGB(), false);
        }
        if ((slots = recipe.getSlots()) == null) {
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_(102.0f, 58.0f, 0.0f);
            SlotIngredientRenderer.INPUT.render(graphics, null);
            pose.m_85849_();
        }
    }

    public List<Component> getTooltipStrings(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Component requirements;
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        ModifierEntry result = recipe.getDisplayResult();
        if (GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16) && (requirements = result.getHook(ModifierHooks.REQUIREMENTS).requirementsError(result)) != null) {
            return Collections.singletonList(requirements);
        }
        if (recipe.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        SlotType.SlotCount slots = recipe.getSlots();
        if (slots == null && GuiUtil.isHovered(checkX, checkY, 102, 58, 24, 16)) {
            return SlotIngredientRenderer.INPUT.getTooltip(null, (TooltipFlag)TooltipFlag.f_256752_);
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayModifierRecipe recipe, IFocusGroup focuses) {
        IFocus focus;
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 33).addItemStacks(recipe.getDisplayItems(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 15).addItemStacks(recipe.getDisplayItems(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 33).addItemStacks(recipe.getDisplayItems(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 58).addItemStacks(recipe.getDisplayItems(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 58).addItemStacks(recipe.getDisplayItems(4));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 3).setCustomRenderer(TConstructJEIConstants.MODIFIER_TYPE, (IIngredientRenderer)this.modifierRenderer).addIngredient(TConstructJEIConstants.MODIFIER_TYPE, (Object)recipe.getDisplayResult());
        List<ItemStack> toolWithoutModifier = recipe.getToolWithoutModifier();
        List<ItemStack> toolWithModifier = recipe.getToolWithModifier();
        Item slimeskull = (Item)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.HELMET);
        for (ItemStack stack : toolWithoutModifier) {
            if (!stack.m_150930_(slimeskull)) continue;
            builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStacks(ModifierRecipeCategory.getSlimeskullHelmets());
            break;
        }
        if ((focus = (IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).filter(f -> f.getRole() == RecipeIngredientRole.CATALYST).findFirst().orElse(null)) != null) {
            Item item = ((ItemStack)focus.getTypedValue().getIngredient()).m_41720_();
            for (ItemStack stack : toolWithoutModifier) {
                if (!stack.m_150930_(item)) continue;
                toolWithoutModifier = List.of(stack);
                break;
            }
            for (ItemStack stack : toolWithModifier) {
                if (!stack.m_150930_(item)) continue;
                toolWithModifier = List.of(stack);
                break;
            }
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 25, 38).addItemStacks(toolWithoutModifier);
        builder.addSlot(RecipeIngredientRole.CATALYST, 105, 34).addItemStacks(toolWithModifier);
        SlotType.SlotCount slots = recipe.getSlots();
        if (slots != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 102, 58).setCustomRenderer(TConstructJEIConstants.SLOT_TYPE, (IIngredientRenderer)SlotIngredientRenderer.INPUT).addIngredient(TConstructJEIConstants.SLOT_TYPE, (Object)recipe.getSlots());
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredients(TConstructJEIConstants.SLOT_TYPE, recipe.getResultSlots());
    }

    public static void clearSlimeskullCache() {
        SLIMESKULL_HELMETS = null;
    }

    private static List<ItemStack> getSlimeskullHelmets() {
        if (SLIMESKULL_HELMETS == null) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            IModifiable slimeskull = (IModifiable)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.HELMET);
            SLIMESKULL_HELMETS = registry.getAllMaterials().stream().filter(material -> registry.getMaterialStats(material.getIdentifier(), SkullStats.ID).isPresent()).map(material -> ToolBuildHandler.buildItemFromMaterials(slimeskull, MaterialNBT.of(material))).toList();
        }
        return SLIMESKULL_HELMETS;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

