/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;

public class MaterialPaletteDebugGenerator
extends GenericTextureGenerator {
    private final String name;
    private final AbstractMaterialSpriteProvider[] materialProviders;

    public MaterialPaletteDebugGenerator(PackOutput packOutput, String name, AbstractMaterialSpriteProvider ... materialProviders) {
        super(packOutput, "debug/material_palettes");
        this.name = name;
        this.materialProviders = materialProviders;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>();
        for (AbstractMaterialSpriteProvider materialProvider : this.materialProviders) {
            for (Map.Entry<ResourceLocation, AbstractMaterialSpriteProvider.MaterialSpriteInfo> entry : materialProvider.getMaterials().entrySet()) {
                ISpriteTransformer iSpriteTransformer = entry.getValue().getTransformer();
                if (!(iSpriteTransformer instanceof RecolorSpriteTransformer)) continue;
                RecolorSpriteTransformer recolor = (RecolorSpriteTransformer)iSpriteTransformer;
                IColorMapping colorMapping = recolor.getColorMapping();
                NativeImage palette = new NativeImage(256, 16, true);
                for (int grey = 0; grey < 256; ++grey) {
                    int color = colorMapping.mapColor(grey | grey << 8 | grey << 16 | 0xFF000000);
                    for (int height = 0; height < 16; ++height) {
                        palette.m_84988_(grey, height, color);
                    }
                }
                tasks.add(this.saveImage(cache, entry.getKey(), palette).thenRunAsync(() -> ((NativeImage)palette).close()));
            }
        }
        return MaterialPaletteDebugGenerator.allOf(tasks);
    }

    public String m_6055_() {
        return this.name + " Material Palette Debug";
    }
}

